/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionEvaluationRecipeRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationDatasetHelper;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesBasicService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesUtils;
import com.dataiku.dip.analysis.ml.prediction.flow.PyPredictionScoringRecipeSubrunner;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.TrainExecutionParams;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ClassicalPredictionEvaluationRecipeRunner
extends AbstractPredictionEvaluationRecipeRunner {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private PredictionRecipesBasicService predictionRecipesService;
    @Autowired
    private KernelsModelEvaluationStoresService modelEvaluationStoresService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.prediction.evaluation");

    public ClassicalPredictionEvaluationRecipeRunner(JobActivity activity) {
        super(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() throws Exception {
        inputFDS = this.activity.getSubgraph().getSourceDatasets();
        if (inputFDS.size() == 0) {
            throw ErrorContext.iae((String)"Missing input dataset in scoring recipe");
        }
        if (this.desc.dontComputePerformance && !this.getMetricsDatasetSmartName().isEmpty()) {
            throw new IllegalArgumentException("You cannot use the \"Skip performance metrics computation\" option with a metrics dataset. Either uncheck this option (make sure you have the ground truth in your input dataset) or remove the metrics dataset from the recipe outputs.");
        }
        customMetricsErrors = PredictionService.checkCustomMetricParams(this.desc.customEvaluationMetrics);
        if (!customMetricsErrors.isEmpty()) {
            throw new IllegalArgumentException(customMetricsErrors.get(0).toString());
        }
        this.checkTextDriftConfig();
        this.checkImageDriftConfig();
        computer = new MLFlowUtils.PredictionScoringRecipeStatusComputer(this.recipe.getModel(), JSON.json((Object)this.desc));
        versionIdOverride = this.predictionRecipesService.resolveVersionIdOverrideEvaluationRecipe(this.recipe.getProjectKey(), this.desc);
        scorability = computer.getScorability_T(this.authCtx, this.activity, versionIdOverride);
        inputDataset = scorability.inputDataset;
        inputDatasetSmartName = inputDataset.getSmartName(this.recipe.getProjectKey());
        outputDatasetType = inputDataset.getType();
        if (scorability.outputDataset != null) {
            outputDataset = scorability.outputDataset;
            outputDatasetSmartName = outputDataset.getSmartName(this.recipe.getProjectKey());
            outputDatasetType = outputDataset.getType();
        } else {
            outputDatasetSmartName = null;
        }
        metricsDatasetSmartName = this.getMetricsDatasetSmartName();
        managedFolderSmartId = PredictionRecipesUtils.getManagedFolderSmartNameOrNull(this.recipe);
        sm = scorability.model;
        fmi = scorability.fmi;
        activeModelFolder = scorability.activeModelFolder;
        if (!ClassicalPredictionEvaluationRecipeRunner.$assertionsDisabled && fmi == null) {
            throw new AssertionError();
        }
        if (!ClassicalPredictionEvaluationRecipeRunner.$assertionsDisabled && sm == null) {
            throw new AssertionError();
        }
        if (!ClassicalPredictionEvaluationRecipeRunner.$assertionsDisabled && activeModelFolder == null) {
            throw new AssertionError();
        }
        details = null;
        trainDataTypeAndParams = null;
        script = null;
        preparationOSchemaToUse = null;
        switch (2.$SwitchMap$com$dataiku$dip$dao$SavedModel$SavedModelHandlingType[sm.savedModelType.savedModelHandlingType.ordinal()]) {
            case 1: {
                details = PredictionResultsReader.makeDetails(fmi);
                this.executionParams = details.coreParams.executionParams;
                script = (SerializedShakerScript)JSON.parseFile((File)new File(activeModelFolder, "script.json"), SerializedShakerScript.class);
                script.contextProjectKey = sm.projectKey;
                inferredPreparedSchema = null;
                ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).stashTheSingleTransaction();
                try {
                    inferredPreparedSchema = MLFlowUtils.getInferredPreparationOutputSchema_NT(sm.projectKey, inputDataset, script, outputDatasetType, this.authCtx);
                }
                finally {
                    ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).unstashTheSingleTransaction();
                }
                preparationOSchemaToUse = MLFlowUtils.getSchemaToUseForPreparedScoringInput(details.preprocessing, details.splitDesc.schema, inferredPreparedSchema, this.desc.evaluationDatasetType != EvaluationDatasetHelper.EvaluationDatasetType.CLASSIC, true, this.activity);
                if (this.desc.computeAssertions) {
                    if (fmi.getAssertionsFile().exists()) {
                        this.enrichScriptWithMLAssertionsMasks(fmi, script, preparationOSchemaToUse);
                    } else {
                        ClassicalPredictionEvaluationRecipeRunner.logger.info((Object)"No assertion found, skipping their computation");
                    }
                }
                details.coreParams.weight.checkHasSampleWeightColumn(preparationOSchemaToUse, this.desc.evaluationDatasetType);
                trainDataTypeAndParams = this.modelEvaluationStoresService.makeTrainDataTypeAndParams(details.splitDesc, details.smOrigin == null ? null : details.smOrigin.fullModelId);
                break;
            }
            case 2: {
                mmvi = (MLFlowModelVersionInfo)JSON.parseFile((File)new File(activeModelFolder, "mlflow_imported_model.json"), MLFlowModelVersionInfo.class);
                if (mmvi.predictionType == null) {
                    throw new IllegalArgumentException("The MLflow model version does not declare a prediction type, cannot run evaluation on it");
                }
                if (this.desc.treatDriftFailureAsError) {
                    fmi.getClassicalPredictionPerf().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$0(), ()Ljava/lang/IllegalArgumentException;)());
                }
                details = new ClassicalPredictionModelDetails();
                mmvi.fillMinimalCoreParamsOfPredictionDetails(details);
                mmvi.fillMinimalModelingParamsOfPredictionDetails(details);
                this.executionParams = new TrainExecutionParams();
                this.executionParams.envName = mmvi.pythonCodeEnvName;
                trainDataTypeAndParams = new KernelsModelEvaluationStoresService.DataTypeAndParams();
                trainDataTypeAndParams.type = AbstractModelEvaluation.DataType.EXTERNAL;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalArgumentException("Agents are not supported in evaluation recipe");
            }
            case 6: {
                throw new IllegalArgumentException("Fine-tuned LLMs are not supported in evaluation recipe");
            }
            case 7: {
                throw new IllegalArgumentException("Retrieval Augmented LLMs are not supported in evaluation recipe");
            }
            default: {
                throw new IllegalStateException("Unhandled saved model type: " + String.valueOf((Object)sm.savedModelType));
            }
        }
        referenceClassifierThreshold = 0.0;
        if (details.coreParams.prediction_type == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION) {
            mum = fmi.getUserMetaOpt().orElse(null);
            v0 = referenceClassifierThreshold = mum == null ? 0.0 : mum.activeClassifierThreshold;
            if (!this.desc.overrideModelSpecifiedThreshold) {
                this.desc.forcedClassifierThreshold = referenceClassifierThreshold;
            }
            ClassicalPredictionEvaluationRecipeRunner.logger.info((Object)("Will predict with threshold = " + this.desc.forcedClassifierThreshold));
        }
        FilesystemACLUtils.grantFSReadACLs(this.authCtxService.getAuthCtx(), fmi.getProjectKey(), new File[]{fmi.getFolderEnsuringSecurity()});
        evaluationStoreRole = this.recipe.getModel().getOutputsForRole("evaluationStore");
        preprocessingFile = fmi.getPreprocessingFile("rpreprocessing_params.json");
        if (!evaluationStoreRole.isEmpty()) {
            if (this.desc.backendType.isSparkBased()) {
                throw new NotImplementedException("Writing to model evaluation stores is only possible in python");
            }
            if (sm.isPartitioned()) {
                throw new NotImplementedException("Output to an evaluation store is not possible for partitioned models");
            }
            mum = fmi.getUserMetaOpt().orElse(null);
            evaluationStoreLoc = DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.getProjectKey(), evaluationStoreRole.get((int)0).ref);
            subgraph = (RecipeRunnableSubgraph)this.activity.getSubgraph();
            inputPartitions = subgraph.getSourcePartitions(inputFDS.get(0));
            modelTypeAndParams = this.modelEvaluationStoresService.makeModelTypeAndParams(this.recipe.getProjectKey(), sm, fmi, details.trainInfo);
            datasetTypeAndParams = this.modelEvaluationStoresService.makeDataTypeAndParams(this.recipe.getProjectKey(), inputDataset, inputPartitions);
            evaluationModelInfo = this.modelEvaluationStoresService.makeEvaluationInfo(details, referenceClassifierThreshold, this.desc.forcedClassifierThreshold);
            evaluationModelInfo.evaluationId = this.desc.evaluationId;
            evaluationModelInfo.name = this.desc.name;
            evaluationModelInfo.predictionVariable = "prediction";
            evaluationModelInfo.labels = EvaluationLabelsHelper.getEvaluationTimeLabels_T(this.recipe.getProjectKey(), mum, inputDataset.serialize(), this.desc.labels, inputPartitions, this.desc.treatDataDriftColumnHandling != false ? this.desc.dataDriftColumnHandling : null);
            evaluationModelInfo.outputProbabilities = this.desc.outputProbabilities;
            evaluationModelInfo.evaluateRecipeParams = new KernelsModelEvaluationStoresService.EvaluateRecipeParams(this.desc.dontComputePerformance);
            evaluationModelInfo.evaluationDatasetType = this.desc.evaluationDatasetType;
            evaluationModelInfo.smvToFilterLogsOn = this.desc.filterApiLogsOnSmvId != false ? fmi : null;
            evaluationModelInfo.skipScoring = this.desc.skipScoring;
            evaluationModelInfo.limitSampling = this.desc.limitSampling;
            evaluationModelInfo.hasTextDrift = this.desc.hasTextDrift;
            evaluationModelInfo.textDriftParams = this.desc.textDriftParams;
            evaluationModelInfo.hasImageDrift = this.desc.hasImageDrift;
            evaluationModelInfo.imageDriftParams = this.desc.imageDriftParams;
            evaluationModelInfo.managedFolderSmartId = managedFolderSmartId;
            mes = this.modelEvaluationStoresService.getMandatory(evaluationStoreLoc.getProjectKey(), evaluationStoreLoc.getId());
            modelEvaluation = this.modelEvaluationStoresService.setupTabularRun(mes, modelTypeAndParams, datasetTypeAndParams, trainDataTypeAndParams, evaluationModelInfo);
            evaluationStoreFolder = modelEvaluation.ref.getMainFolder();
            if (preprocessingFile.exists()) {
                FileUtils.copyFile((File)preprocessingFile, (File)modelEvaluation.ref.getEvaluationFile("rpreprocessing_params.json"));
            }
            if ((iperfFile = fmi.getModelFile("iperf.json")).exists()) {
                FileUtils.copyFile((File)iperfFile, (File)modelEvaluation.ref.getEvaluationFile("iperf.json"));
            }
            if ((globalExplanationsObservationsFile = fmi.getGlobalExplanationsObservationsFile()).exists()) {
                FileUtils.copyFile((File)globalExplanationsObservationsFile, (File)modelEvaluation.ref.getEvaluationFile("global_explanations_observations.json"));
            }
            if ((globalExplanationsAbsoluteImportanceFile = fmi.getGlobalExplanationsAbsoluteImportanceFile()).exists()) {
                FileUtils.copyFile((File)globalExplanationsAbsoluteImportanceFile, (File)modelEvaluation.ref.getEvaluationFile("global_explanations_absolute_importance.json"));
            }
            if ((globalExplanationsFactsFile = fmi.getGlobalExplanationsFactsFile()).exists()) {
                FileUtils.copyFile((File)globalExplanationsFactsFile, (File)modelEvaluation.ref.getEvaluationFile("global_explanations_facts.json"));
            }
            if ((collectorFile = fmi.getPreprocessingFile("collector_data.json")).exists()) {
                FileUtils.copyFile((File)collectorFile, (File)modelEvaluation.ref.getEvaluationFile("collector_data.json"));
            }
            if ((columnImportanceFile = fmi.getModelFile("column_importance.json")).exists()) {
                FileUtils.copyFile((File)columnImportanceFile, (File)modelEvaluation.ref.getEvaluationFile("column_importance.json"));
            }
            if ((coreParamsFile = fmi.getModelFile("core_params.json")).exists()) {
                FileUtils.copyFile((File)coreParamsFile, (File)modelEvaluation.ref.getEvaluationFile("core_params.json"));
            }
            if ((modelingParamsFile = fmi.getPreprocessingFile("rmodeling_params.json")).exists()) {
                FileUtils.copyFile((File)modelingParamsFile, (File)modelEvaluation.ref.getEvaluationFile("rmodeling_params.json"));
            }
            if ((trainInfoFile = fmi.getModelFile("train_info.json")).exists()) {
                FileUtils.copyFile((File)trainInfoFile, (File)modelEvaluation.ref.getEvaluationFile("train_info.json"));
            }
            if ((modelDiagnosticsFile = fmi.getMLDiagnosticsFile()).exists()) {
                FileUtils.copyFile((File)modelDiagnosticsFile, (File)modelEvaluation.ref.getEvaluationFile("train_diagnostics.json"));
            }
            if (this.desc.computeAssertions && (assertionParamsFile = fmi.getAssertionsFile()).exists()) {
                FileUtils.copyFile((File)assertionParamsFile, (File)modelEvaluation.ref.getEvaluationFile("rassertions.json"));
            }
            if ((overridesFile = fmi.getOverridesFile()).exists()) {
                FileUtils.copyFile((File)overridesFile, (File)DKUFileUtils.getWithinFollowLink((File)evaluationStoreFolder, (String[])new String[]{"roverrides.json"}));
            }
            if ((featureSelectionFile = fmi.getModelFile("feature_selection.json")).exists()) {
                FileUtils.copyFile((File)featureSelectionFile, (File)modelEvaluation.ref.getEvaluationFile("feature_selection.json"));
            }
            if ((mlflowModelInfoFile = fmi.getModelFile("mlflow_imported_model.json")).exists()) {
                FileUtils.copyFile((File)mlflowModelInfoFile, (File)modelEvaluation.ref.getEvaluationFile("mlflow_imported_model.json"));
            }
            if ((mlModelFile = fmi.getModelFile("MLModel")).exists()) {
                FileUtils.copyFile((File)mlModelFile, (File)modelEvaluation.ref.getEvaluationFile("MLModel"));
            }
            FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.recipe.getProjectKey(), true, new File[]{evaluationStoreFolder});
            if (fmi.hasPredictionStatisticsFile()) {
                FileUtils.copyFile((File)fmi.getPredictionStatisticsFile(), (File)modelEvaluation.ref.getReferencePredictionStatisticsFile());
            }
        } else {
            evaluationStoreFolder = null;
            evaluationStoreLoc = null;
            modelEvaluation = null;
        }
        block17 : switch (2.$SwitchMap$com$dataiku$dip$dao$SavedModel$SavedModelHandlingType[sm.savedModelType.savedModelHandlingType.ordinal()]) {
            case 1: {
                if (!evaluationStoreRole.isEmpty() && (referenceSchema = fmi.getDataSchema()) != null && preprocessingFile.exists()) {
                    referenceDataFile = new File(evaluationStoreFolder, "drift_reference.csv.gz");
                    referenceSchemaFile = new File(evaluationStoreFolder, "drift_reference.json");
                    JSON.prettyToFile((Object)referenceSchema, (File)referenceSchemaFile);
                    fos = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(referenceDataFile)));
                    try {
                        fmi.streamDataCSV(fos);
                    }
                    finally {
                        fos.close();
                    }
                }
                try {
                    outputTmpDir = FlowJobUtils.getTmpFolder("evaluation-recipe", "pyrun");
                    try {
                        JSON.prettyToFile((Object)this.desc, (File)new File((File)outputTmpDir, "desc.json"));
                        JSON.prettyToFile((Object)preparationOSchemaToUse, (File)new File((File)outputTmpDir, "preparation_output_schema.json"));
                        JSON.prettyToFile(sm.conditionalOutputs, (File)new File((File)outputTmpDir, "conditional_outputs.json"));
                        FileUtils.copyFile((File)preprocessingFile, (File)DKUFileUtils.getWithinFollowLink((File)outputTmpDir, (String[])new String[]{"rpreprocessing_params.json"}));
                        switch (2.$SwitchMap$com$dataiku$dip$analysis$model$MLTask$BackendType[this.desc.backendType.ordinal()]) {
                            case 1: {
                                JobContext.getCurrentActivitySummary().engineType = "PYTHON";
                                this.runPython(fmi, script, inputDatasetSmartName, managedFolderSmartId, outputDatasetSmartName, metricsDatasetSmartName, activeModelFolder, outputTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_PYTHON, "dataiku.doctor.evaluation.reg_evaluation_recipe", evaluationStoreFolder, this.desc.evaluationDatasetType, this.desc.filterApiLogsOnSmvId != false ? fmi : null, this.desc.evaluatedDeploymentId, modelEvaluation, "");
                                ** break;
lbl188:
                                // 1 sources

                                break block17;
                            }
                            case 2: {
                                JobContext.getCurrentActivitySummary().engineType = "PYTHON";
                                this.runPython(fmi, script, inputDatasetSmartName, managedFolderSmartId, outputDatasetSmartName, metricsDatasetSmartName, activeModelFolder, outputTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_KERAS, "dataiku.doctor.evaluation.keras_evaluation_recipe", evaluationStoreFolder, this.desc.evaluationDatasetType, this.desc.filterApiLogsOnSmvId != false ? fmi : null, this.desc.evaluatedDeploymentId, modelEvaluation, "");
                                ** break;
lbl193:
                                // 1 sources

                                break block17;
                            }
                            case 3: 
                            case 4: {
                                fScript = script;
                                JobContext.getCurrentActivitySummary().engineType = "SPARK";
                                hiveDb = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
                                runner = new AbstractSparkBasedRecipeRunner(this.activity){

                                    @Override
                                    public void run() throws Exception {
                                        SerializedShakerScript expandedScript = fScript.expandedDeepCopy(ClassicalPredictionEvaluationRecipeRunner.this.variablesService.getForProject(this.projectKey));
                                        ClassicalPredictionEvaluationRecipeRunner.this.gatherer.gatherAndCompute(ClassicalPredictionEvaluationRecipeRunner.this.authCtx, this.projectKey, expandedScript.steps);
                                        JSON.prettyToFile((Object)expandedScript, (File)new File((File)outputTmpDir, "script.json"));
                                        JSON.prettyToFile(ClassicalPredictionEvaluationRecipeRunner.this.gatherer.getResourceMapping(), (File)new File((File)outputTmpDir, "resource_mapping.json"));
                                        this.runSpark("evaluate", ClassicalPredictionEvaluationRecipeRunner.this.desc.sparkParams.sparkExecutionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

                                            @Override
                                            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                                                return helper.makeClassJobWithNonSecretGlobalFiles("DSS  (predict): " + activity.id(), effectiveConf, ClassicalPredictionEvaluationRecipeRunner.this.gatherer.getResourceFiles(), ClassicalPredictionEvaluationRecipeRunner.this.desc.backendType == MLTask.BackendType.H2O, "com.dataiku.dip.spark.MLLibEvaluationJob", activeModelFolder.getAbsolutePath(), recipe.getProjectKey(), inputDatasetSmartName, StringUtils.defaultIfBlank((String)outputDatasetSmartName, (String)""), StringUtils.defaultIfBlank((String)metricsDatasetSmartName, (String)""), outputTmpDir.getAbsolutePath());
                                            }

                                            @Override
                                            public SparkOverrideConfig getRecipeOverrideConf() {
                                                return ClassicalPredictionEvaluationRecipeRunner.this.desc.sparkParams.sparkConf;
                                            }

                                            @Override
                                            public Map<String, String> getContextOverrideConf() {
                                                return CollectionUtils.appendableSSMap().put("spark.dku.ml.preparedDF.storageLevel", ClassicalPredictionEvaluationRecipeRunner.this.desc.sparkParams.sparkPreparedDFStorageLevel).put("spark.dku.ml.repartitionNonHDFS", String.valueOf(ClassicalPredictionEvaluationRecipeRunner.this.desc.sparkParams.sparkRepartitionNonHDFS)).put("spark.dku.ml.useGlobalMetastore", Boolean.toString(ClassicalPredictionEvaluationRecipeRunner.this.desc.sparkParams.sparkUseGlobalMetastore)).put("spark.dku.ml.hiveDb", StringUtils.defaultIfBlank((String)hiveDb, (String)"")).get();
                                            }

                                            @Override
                                            public List<File> getExtraRecursiveFolders() {
                                                return Lists.newArrayList((Object[])new File[]{activeModelFolder, outputTmpDir});
                                            }
                                        }, null);
                                    }

                                    @Override
                                    public void init() throws Exception {
                                    }
                                };
                                this.startRunner(runner);
                                ** break;
lbl201:
                                // 1 sources

                                break block17;
                            }
                            default: {
                                throw new NotImplementedException("Unsupported backend type: " + String.valueOf((Object)this.desc.backendType));
                            }
                        }
                    }
                    finally {
                        if (outputTmpDir != null) {
                            outputTmpDir.close();
                        }
                    }
                }
                catch (Exception e) {
                    if (evaluationStoreFolder != null) {
                        ClassicalPredictionEvaluationRecipeRunner.logger.warn((Object)"Fail to evaluate model, cleaning up evaluation store folder");
                        DKUFileUtils.forceDelete(evaluationStoreFolder);
                    }
                    throw e;
                }
            }
            case 2: {
                if (modelEvaluation != null) {
                    JSON.prettyToFile((Object)fmi.getResolvedPreprocessingParams(), (File)modelEvaluation.ref.getEvaluationFile("rpreprocessing_params.json"));
                }
                if ((referenceSchema = fmi.getDataSchema()) != null && !evaluationStoreRole.isEmpty()) {
                    referenceDataFile = new File(evaluationStoreFolder, "drift_reference.csv.gz");
                    referenceSchemaFile = new File(evaluationStoreFolder, "drift_reference.json");
                    JSON.prettyToFile((Object)referenceSchema, (File)referenceSchemaFile);
                    fos = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(referenceDataFile)));
                    try {
                        fmi.streamDataCSV(fos);
                    }
                    finally {
                        fos.close();
                    }
                }
                outputTmpDir = FlowJobUtils.getTmpFolder("evaluation-recipe", "pyrun");
                try {
                    JSON.prettyToFile((Object)this.desc, (File)new File((File)outputTmpDir, "desc.json"));
                    JSON.prettyToFile(sm.conditionalOutputs, (File)new File((File)outputTmpDir, "conditional_outputs.json"));
                    JSON.prettyToFile((Object)fmi.getResolvedPreprocessingParams(), (File)new File((File)outputTmpDir, "rpreprocessing_params.json"));
                    JobContext.getCurrentActivitySummary().engineType = "PYTHON";
                    if (Objects.nonNull(sm.proxyModelConfiguration) && StringUtils.isNotBlank((String)sm.proxyModelConfiguration.connection)) {
                        cdao = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
                        connection = cdao.getMandatoryConnection(this.authCtx, sm.proxyModelConfiguration.connection);
                        if (!connection.isFreelyUsableBy(this.authCtx)) {
                            throw new UnauthorizedException("Access to this connection is not authorized.", "connection-access-denied");
                        }
                        proxy = ExternalInfrasUtils.getProxy(connection).getAsString();
                    } else {
                        proxy = ApplicationConfigurator.getProxySettings().getAsString();
                    }
                    this.runPython(fmi, script, inputDatasetSmartName, managedFolderSmartId, outputDatasetSmartName, metricsDatasetSmartName, activeModelFolder, outputTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_MLFLOW, "dataiku.external_ml.mlflow.pyfunc_evaluation_recipe", evaluationStoreFolder, this.desc.evaluationDatasetType, this.desc.filterApiLogsOnSmvId != false ? fmi : null, this.desc.evaluatedDeploymentId, modelEvaluation, proxy);
                    if (outputTmpDir == null) break;
                }
                catch (Throwable var28_31) {
                    if (outputTmpDir != null) {
                        try {
                            outputTmpDir.close();
                        }
                        catch (Throwable var29_33) {
                            var28_31.addSuppressed(var29_33);
                        }
                    }
                    throw var28_31;
                }
                outputTmpDir.close();
                break;
            }
        }
        if (modelEvaluation != null) {
            this.activity.getTargetStatus((String)evaluationStoreLoc.getFullName()).evaluationId = modelEvaluation.ref.evaluationId;
            if (!this.desc.treatDriftFailureAsError && !modelEvaluation.ref.hasDataEvaluationMetrics()) {
                this.activity.warnContext.addWarning(WarningsContext.WarningType.DATA_DRIFT_COMPUTATION_ERROR, "Failed to compute input data drift", ClassicalPredictionEvaluationRecipeRunner.logger);
            }
            this.modelEvaluationStoresService.finaliseRun(modelEvaluation);
        }
    }

    private void checkTextDriftConfig() {
        if (this.desc.hasTextDrift) {
            if (this.desc.textDriftParams == null) {
                this.handleDriftFailure("The text drift parameters cannot be null with the text drift enabled. Please review your recipe configuration.");
            }
            if (StringUtils.isBlank((String)this.desc.textDriftParams.embeddingModelId)) {
                this.handleDriftFailure("No text embedding model is selected, whereas the text drift is enabled. Please review your recipe configuration.");
            }
        }
    }

    private void checkImageDriftConfig() {
        if (this.desc.hasImageDrift) {
            if (this.desc.savedModelType != SavedModel.SavedModelType.DSS_MANAGED) {
                this.handleDriftFailure(String.format("Image drift can not be computed: Only model type DSS_MANAGED is supported (current: %s).", new Object[]{this.desc.savedModelType}));
            }
            if (this.desc.imageDriftParams == null) {
                this.handleDriftFailure("The image drift parameters cannot be null with the image drift enabled. Please review your recipe configuration.");
            }
            if (StringUtils.isBlank((String)this.desc.imageDriftParams.embeddingModelId)) {
                this.handleDriftFailure("No image embedding model is selected, whereas the image drift is enabled. Please review your recipe configuration.");
            }
        }
    }

    private void handleDriftFailure(String customErrMessage) throws IllegalArgumentException {
        if (this.desc.treatDriftFailureAsError) {
            logger.error((Object)customErrMessage);
            throw new IllegalArgumentException(customErrMessage);
        }
        logger.warn((Object)customErrMessage);
    }

    private void enrichScriptWithMLAssertionsMasks(FullModelId fmi, SerializedShakerScript script, Schema schema) throws Exception {
        MLAssertionsParams assertionsParams = fmi.getAssertionsParams();
        MLAssertionsParams.AssertionsAsSteps assertionsAsSteps = MLAssertionsParams.generateScriptData(assertionsParams.assertions);
        script.steps.addAll(assertionsAsSteps.steps);
        schema.addColumns((Iterable)assertionsAsSteps.outputSchema.columns);
    }

    private void runPython(FullModelId fmi, SerializedShakerScript script, String inputDatasetSmartName, @Nullable String managedFolderSmartId, String outputDatasetSmartName, String metricsDatasetSmartName, File activeModelFolder, AutoDelete outputTmpDir, RemoteRunsRegistry.ExecutionType executionType, String cmd, File evaluationStoreFolder, EvaluationDatasetHelper.EvaluationDatasetType evaluationDatasetType, FullModelId smvToFilterLogsOn, String deploymentToFilterLogsOn, TabularModelEvaluation modelEvaluation, String proxy) throws Exception {
        if (script != null) {
            JSON.prettyToFile((Object)script, (File)new File((File)outputTmpDir, "script.json"));
        }
        JsonObject containerPayload = new JsonObject();
        containerPayload.addProperty("inputDatasetSmartName", inputDatasetSmartName);
        containerPayload.addProperty("managedFolderSmartId", managedFolderSmartId);
        containerPayload.addProperty("outputDatasetSmartName", outputDatasetSmartName);
        containerPayload.addProperty("metricsDatasetSmartName", metricsDatasetSmartName);
        if (evaluationStoreFolder != null) {
            containerPayload.addProperty("evaluationStoreFolder", evaluationStoreFolder.getAbsolutePath());
        }
        containerPayload.addProperty("inputModel", fmi.toString());
        containerPayload.addProperty("evaluationDatasetType", evaluationDatasetType.toString());
        JsonObject apiNodeLogsConfig = new JsonObject();
        apiNodeLogsConfig.addProperty("smvToFilterLogsOn", smvToFilterLogsOn != null ? smvToFilterLogsOn.toString() : "");
        apiNodeLogsConfig.addProperty("deploymentToFilterLogsOn", deploymentToFilterLogsOn != null ? deploymentToFilterLogsOn : "");
        containerPayload.addProperty("apiNodeLogsConfig", apiNodeLogsConfig.toString());
        PyPredictionScoringRecipeSubrunner.Evaluation runner = new PyPredictionScoringRecipeSubrunner.Evaluation(this.activity, fmi, activeModelFolder, evaluationStoreFolder, this.authCtx, this.executionParams.envName, this.desc, executionType, outputTmpDir, containerPayload, cmd, activeModelFolder.getAbsolutePath(), inputDatasetSmartName, StringUtils.defaultIfBlank((String)managedFolderSmartId, (String)""), StringUtils.defaultIfBlank((String)outputDatasetSmartName, (String)""), StringUtils.defaultIfBlank((String)metricsDatasetSmartName, (String)""), new File((File)outputTmpDir, "desc.json").getAbsolutePath(), new File((File)outputTmpDir, "script.json").getAbsolutePath(), new File((File)outputTmpDir, "preparation_output_schema.json").getAbsolutePath(), new File((File)outputTmpDir, "conditional_outputs.json").getAbsolutePath(), new File((File)outputTmpDir, "rpreprocessing_params.json").getAbsolutePath(), evaluationStoreFolder != null ? evaluationStoreFolder.getAbsolutePath() : "", evaluationDatasetType.toString(), apiNodeLogsConfig.toString(), outputTmpDir.getAbsolutePath(), fmi.toString(), proxy);
        this.startRunner(runner);
        File diagnosticsFile = DKUFileUtils.getWithin((File)outputTmpDir, (String[])new String[]{"ml_diagnostics.json"});
        if (diagnosticsFile.exists()) {
            MLDiagnostics mlDiagnostics = ModelLikeId.parseJsonFile(diagnosticsFile, MLDiagnostics.class);
            mlDiagnostics.mergeIntoWarnings(this.activity.warnContext);
            if (modelEvaluation != null) {
                FileUtils.copyFile((File)diagnosticsFile, (File)modelEvaluation.ref.getEvaluationFile("ml_diagnostics.json"));
            }
        }
    }

    @Override
    public void finalCommit() throws Exception {
        List<SerializedRecipe.RecipeOutput> evaluationStoreRole = this.recipe.getModel().getOutputsForRole("evaluationStore");
        if (!evaluationStoreRole.isEmpty()) {
            if (this.desc.backendType.isSparkBased()) {
                throw new NotImplementedException("Writing to model evaluation stores is only possible in python");
            }
            AnyLoc evaluationStoreLoc = DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.getProjectKey(), evaluationStoreRole.get((int)0).ref);
            String secret = this.ticketService.getSingleTicket().getSecret();
            try (TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);){
                tClient.postFormToJSON("/dip/api/tintercom/model-evaluation-stores/new-evaluation", Void.class, new Object[]{"projectKey", evaluationStoreLoc.getProjectKey(), "id", evaluationStoreLoc.getId(), "evaluationId", this.activity.getTargetStatus((String)evaluationStoreLoc.getFullName()).evaluationId});
            }
        }
    }

    private static /* synthetic */ IllegalArgumentException lambda$run$0() {
        return new IllegalArgumentException("The MLflow model version was not evaluated after import. This is required to compute drift. You should either evaluate this model using the python API or uncheck the 'Fail on warnings' option in Advanced > Drift");
    }
}

