/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.dip.analysis.ml.prediction.guess.ClassicalPredictionGuesser;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.datalayer.memimpl.MemTable;

public class ExplanatoryModelsGuesser
extends ClassicalPredictionGuesser {
    public ExplanatoryModelsGuesser(PredictionMLTask.ClassicalPredictionMLTask task, MemTable table) {
        super(task, table);
    }

    private PredictionModelingParams initAlgorithmsParams(PredictionMLTask.ClassicalPredictionMLTask task, boolean keepExistingParams) {
        PredictionModelingParams params;
        block10: {
            block8: {
                block11: {
                    block9: {
                        if (!keepExistingParams) break block8;
                        params = task.modeling;
                        if (task.backendType != MLTask.BackendType.PY_MEMORY) break block9;
                        switch (task.predictionType) {
                            case REGRESSION: {
                                params.ridge_regression = new PredictionModelingParams.RidgeRegressionHyperparametersSpace();
                                params.decision_tree_regression = new PredictionModelingParams.DecisionTreeHyperparametersSpace();
                                params.random_forest_regression = new PredictionModelingParams.RandomForestHyperparametersSpace();
                                params.gbt_regression = new PredictionModelingParams.GBTRegressionHyperparametersSpace();
                                break block10;
                            }
                            case MULTICLASS: 
                            case BINARY_CLASSIFICATION: {
                                params.logistic_regression = new PredictionModelingParams.LogisticRegressionHyperparametersSpace();
                                params.decision_tree_classification = new PredictionModelingParams.DecisionTreeHyperparametersSpace();
                                params.random_forest_classification = new PredictionModelingParams.RandomForestHyperparametersSpace();
                                params.gbt_classification = new PredictionModelingParams.GBTClassificationHyperparametersSpace();
                                break block10;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)task.predictionType));
                            }
                        }
                    }
                    if (task.backendType != MLTask.BackendType.MLLIB) break block11;
                    params.mllib_rf = new PredictionModelingParams.MLLibTreesEnsembleGridParams();
                    params.mllib_dt = new PredictionModelingParams.MLLibDecisionTreeGridParams();
                    switch (task.predictionType) {
                        case REGRESSION: {
                            params.mllib_linreg = new PredictionModelingParams.MLLibLinearRegressionGridParams();
                            break block10;
                        }
                        case MULTICLASS: 
                        case BINARY_CLASSIFICATION: {
                            params.mllib_logit = new PredictionModelingParams.MLLibLogisticRegressionGridParams();
                            break block10;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)task.predictionType));
                        }
                    }
                }
                throw new IllegalArgumentException("Backend " + String.valueOf((Object)task.backendType) + " not supported");
            }
            params = new PredictionModelingParams(task.predictionType, task.modeling);
        }
        return params;
    }

    @Override
    public PredictionModelingParams guessAlgorithms(MemTable table, PredictionMLTask.ClassicalPredictionMLTask task, boolean keepExistingParams) {
        PredictionModelingParams params;
        block9: {
            block10: {
                block8: {
                    params = this.initAlgorithmsParams(task, keepExistingParams);
                    if (task.backendType != MLTask.BackendType.PY_MEMORY) break block8;
                    switch (task.predictionType) {
                        case REGRESSION: {
                            params.ridge_regression.enabled = true;
                            params.decision_tree_regression.enabled = true;
                            params.random_forest_regression.enabled = true;
                            params.gbt_regression.enabled = true;
                            break block9;
                        }
                        case MULTICLASS: 
                        case BINARY_CLASSIFICATION: {
                            params.logistic_regression.enabled = true;
                            params.decision_tree_classification.enabled = true;
                            params.random_forest_classification.enabled = true;
                            params.gbt_classification.enabled = true;
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)task.predictionType));
                        }
                    }
                }
                if (task.backendType != MLTask.BackendType.MLLIB) break block10;
                params.mllib_rf.enabled = true;
                params.mllib_dt.enabled = true;
                switch (task.predictionType) {
                    case REGRESSION: {
                        params.mllib_linreg.enabled = true;
                        break block9;
                    }
                    case MULTICLASS: 
                    case BINARY_CLASSIFICATION: {
                        params.mllib_logit.enabled = true;
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)task.predictionType));
                    }
                }
            }
            throw new IllegalArgumentException("Backend " + String.valueOf((Object)task.backendType) + " not supported");
        }
        return params;
    }
}

