/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.split;

import com.dataiku.dip.analysis.ml.prediction.split.ForcedSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.prediction.split.SplitUtils;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.ShakerStreamService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;

public class EFDForcedSplitGenerator
implements ForcedSplitGenerator {
    @Autowired
    private ShakerStreamService shakerStreamService;
    private final AuthCtx authCtx;
    private Dataset train;
    private SplitParams.EFDSplit trainSplit;
    private Dataset test;
    private SplitParams.EFDSplit testSplit;
    private SplitParams params;
    private File targetFolder;
    private SerializedShakerScript script;
    private Schema preparationOutputSchema;

    public EFDForcedSplitGenerator(AuthCtx authCtx, Dataset train, Dataset test, SplitParams params, SerializedShakerScript script, Schema preparationOutputSchema, File targetFolder) {
        SpringUtils.getInstance().autowire((Object)this);
        assert (params.ttPolicy == SplitParams.TrainTestPolicy.EXPLICIT_FILTERING_TWO_DATASETS || params.ttPolicy == SplitParams.TrainTestPolicy.EXPLICIT_FILTERING_SINGLE_DATASET);
        this.authCtx = authCtx;
        this.preparationOutputSchema = preparationOutputSchema;
        this.train = train;
        this.test = test;
        this.params = params;
        this.script = script;
        this.targetFolder = targetFolder;
        switch (params.ttPolicy) {
            case EXPLICIT_FILTERING_SINGLE_DATASET: {
                this.trainSplit = params.efsdTrain;
                this.testSplit = params.efsdTest;
                break;
            }
            case EXPLICIT_FILTERING_TWO_DATASETS: {
                this.trainSplit = params.eftdTrain;
                this.testSplit = params.eftdTest;
            }
        }
    }

    @Override
    public SplitDesc compute() throws Exception {
        SplitDesc newDesc = new SplitDesc();
        newDesc.format = "csv1";
        newDesc.generationDate = System.currentTimeMillis();
        newDesc.params = (SplitParams)JSON.deepCopy((Object)this.params);
        switch (newDesc.params.ttPolicy) {
            case EXPLICIT_FILTERING_SINGLE_DATASET: {
                newDesc.params.efsdDatasetSmartName = this.train.getSmartName(this.script.contextProjectKey);
                break;
            }
            case EXPLICIT_FILTERING_TWO_DATASETS: {
                newDesc.params.eftdTrain.datasetSmartName = this.train.getSmartName(this.script.contextProjectKey);
                newDesc.params.eftdTest.datasetSmartName = this.test.getSmartName(this.script.contextProjectKey);
                break;
            }
            default: {
                throw new NotImplementedException("Unexpected train/test policy: " + String.valueOf((Object)newDesc.params.ttPolicy));
            }
        }
        newDesc.schema = this.preparationOutputSchema;
        File trainPath = SplitUtils.getSavedModelTrainSetFile(this.targetFolder);
        long trainRows = SplitUtils.pushEFD(this.authCtx, trainPath, this.trainSplit, this.train, newDesc.schema, this.script, this.shakerStreamService);
        newDesc.trainPath = trainPath.getName();
        newDesc.trainRows = trainRows;
        File testPath = SplitUtils.getSavedModelTestSetFile(this.targetFolder);
        long testRows = SplitUtils.pushEFD(this.authCtx, testPath, this.testSplit, this.test, newDesc.schema, this.script, this.shakerStreamService);
        newDesc.testPath = testPath.getName();
        newDesc.testRows = testRows;
        return newDesc;
    }
}

