/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.split;

import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.prediction.split.PredictionSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.prediction.split.SplitUtils;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.ShakerStreamService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EFSDSplitGenerator
extends PredictionSplitGenerator {
    @Autowired
    private ShakerStreamService shakerStreamService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private KernelsModelEvaluationStoresService kernelsModelEvaluationStoresService;
    @Autowired
    private VariablesService variablesService;

    public EFSDSplitGenerator(MLTaskLoc taskLoc, AnalysisCoreParams coreParams, SplitParams params, AuthCtx authCtx) {
        super(taskLoc, coreParams, params, authCtx);
        assert (params.ttPolicy == SplitParams.TrainTestPolicy.EXPLICIT_FILTERING_SINGLE_DATASET);
    }

    @Override
    public String getPolicyId() throws IOException {
        String policyId;
        try {
            policyId = "type=" + String.valueOf((Object)this.params.ttPolicy) + ",dataset=" + this.params.efsdDatasetSmartName + ",trainSel=" + this.params.efsdTrain.selection.getIdentifier() + ",trainFilter=" + FilterDescUtils.getFilterRepr(this.params.efsdTrain.filter) + ",testSel=" + this.params.efsdTest.selection.getIdentifier() + ",testFilter=" + FilterDescUtils.getFilterRepr(this.params.efsdTest.filter);
        }
        catch (Exception e) {
            throw new IOException("Cannot create policy id", e);
        }
        return policyId;
    }

    private DatasetLocUtils.DatasetLoc getDatasetLoc() {
        if (StringUtils.isBlank((String)this.params.efsdDatasetSmartName)) {
            return DatasetLocUtils.resolveSmart(this.coreParams.projectKey, this.coreParams.inputDatasetSmartName);
        }
        return DatasetLocUtils.resolveSmart(this.coreParams.projectKey, this.params.efsdDatasetSmartName);
    }

    @Override
    public String getExpectedInstanceId_NT() throws IOException {
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getMandatory(this.getDatasetLoc());
        }
        return DigestUtils.md5Hex((String)(this.getPolicyId() + "-" + dataset.getSerializedJSONForSemanticComparison() + "-" + this.scriptStepsStr + "-" + JSON.json(this.coreParams.script.analysisColumnData))) + "-" + this.params.instanceIdRefresher;
    }

    @Override
    protected void expandFilterParams() {
        VariablesContext vc = this.variablesService.getForProject(this.coreParams.projectKey);
        FilterDescUtils.expand(this.params.efsdTrain.filter, vc);
        FilterDescUtils.expand(this.params.efsdTest.filter, vc);
    }

    @Override
    public SplitDesc updateSplitAndSplitDesc(SplitDesc splitDesc, String expectedInstanceId) throws Exception {
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getMandatory(this.getDatasetLoc());
        }
        File trainPath = SplitUtils.getMlTaskTrainSetFile(this.taskLoc, expectedInstanceId);
        long trainRows = SplitUtils.pushEFD(this.authCtx, trainPath, this.params.efsdTrain, dataset, splitDesc.schema, this.coreParams.script, this.shakerStreamService);
        splitDesc.trainPath = trainPath.getName();
        File testPath = SplitUtils.getMlTaskTestSetFile(this.taskLoc, expectedInstanceId);
        long testRows = SplitUtils.pushEFD(this.authCtx, testPath, this.params.efsdTest, dataset, splitDesc.schema, this.coreParams.script, this.shakerStreamService);
        splitDesc.testPath = testPath.getName();
        splitDesc.trainRows = trainRows;
        splitDesc.testRows = testRows;
        return splitDesc;
    }
}

