/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.shared;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ResultsReaderBase {
    private static final Logger logger = Logger.getLogger((String)"dku.ml.results");

    public static void readTrainInfoUserMetaAndDiagnostics(FullModelId id, ModelDetailsBase ret) throws IOException {
        ret.trainInfo = id.hasReadableModelFile("train_info.json") ? id.parseModelFile("train_info.json", ModelTrainInfo.class) : new ModelTrainInfo();
        ret.fullModelId = id.toString();
        switch (id.type) {
            case ANALYSIS: {
                ret.sessionId = id.getSessionId();
                if (id.getSessionFile("done.txt").isFile()) {
                    ret.sessionDate = id.getSessionFile("done.txt").lastModified();
                    break;
                }
                ret.sessionDate = System.currentTimeMillis();
                break;
            }
            case SAVED: {
                if (!id.getSmOriginFile().isFile()) break;
                ret.smOrigin = id.getSmOrigin();
            }
        }
        ret.userMeta = id.hasReadableModelFile("user_meta.json") ? id.parseModelFile("user_meta.json", ModelUserMeta.class) : new ModelUserMeta();
        ret.mlDiagnostics = id.getMLDiagnostics();
    }

    public static void readSplitData(FullModelId fmi, ModelDetailsBase ret) {
        try {
            ret.splitDesc = ResultsReaderBase.readSplitDesc(fmi);
            if (ret.splitDesc == null) {
                logger.warn((Object)"Split desc is not ready");
                return;
            }
            if (ret.splitDesc.trainRows != 0L || ret.splitDesc.fullRows != 0L) {
                ret.trainInfo.trainRows = ret.splitDesc.trainRows;
                ret.trainInfo.testRows = ret.splitDesc.testRows;
                ret.trainInfo.fullRows = ret.splitDesc.fullRows;
                ret.trainInfo.kfold = ret.splitDesc.params != null && ret.splitDesc.params.kfold;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to parse split desc: " + e.getMessage()));
        }
    }

    public static SplitDesc readSplitDesc(FullModelId fmi) {
        SplitDesc splitDesc = null;
        try {
            switch (fmi.getType()) {
                case ANALYSIS: {
                    SplitDesc.SplitRef splitRef = fmi.getSplitRef();
                    if (splitRef == null) break;
                    File splitFile = new File(fmi.getTaskLoc().getSplitsFolder(), splitRef.splitInstanceId + ".json");
                    splitDesc = (SplitDesc)JSON.parseFile((File)splitFile, SplitDesc.class);
                    break;
                }
                case SAVED: {
                    if (!fmi.hasReadableSessionFile("split/split.json")) break;
                    splitDesc = fmi.parseSessionFile("split/split.json", SplitDesc.class);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read split desc", (Throwable)e);
        }
        return splitDesc;
    }
}

