/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.utils.ErrorContext;
import org.apache.commons.lang.StringUtils;

public class CatFeaturePreprocessingParams
extends FeaturePreprocessingParams {
    public String impute_constant_value;
    public CategoryHandlingMethod category_handling;
    public MissingHandlingMethod missing_handling;
    public CatImputationMethod missing_impute_with;
    public DummyClippingMethod dummy_clip = DummyClippingMethod.MAX_NB_CATEGORIES;
    public double cumulative_proportion = 0.95;
    public int min_samples = 10;
    public int max_nb_categories = 100;
    public int max_cat_safety = 200;
    public int nb_bins_hashing = 0x100000;
    public boolean hash_whole_categories = true;
    public DummyDroppingMethod dummy_drop = DummyDroppingMethod.NONE;
    public ImpactMethod impact_method = ImpactMethod.M_ESTIMATOR;
    public int impact_m = 10;
    public boolean impact_kfold = true;
    public int impact_kfold_k = 5;
    public int impact_kfold_seed = 1337;
    public OrdinalOrder ordinal_order = OrdinalOrder.COUNT;
    public boolean ordinal_ascending = false;
    public OrdinalDefault ordinal_default_mode = OrdinalDefault.HIGHEST;
    public Integer ordinal_default_value = 0;
    public FrequencyDefault frequency_default_mode = FrequencyDefault.EXPLICIT;
    public double frequency_default_value = 0.0;
    public boolean frequency_normalized = true;
    public NumFeaturePreprocessingParams.RescalingMethod categorical_rescaling;

    public CatFeaturePreprocessingParams() {
        this.type = FeaturePreprocessingParams.FeatureType.CATEGORY;
    }

    public static CatFeaturePreprocessingParams buildStdInput() {
        CatFeaturePreprocessingParams ret = new CatFeaturePreprocessingParams();
        ret.role = FeaturePreprocessingParams.Role.INPUT;
        ret.category_handling = CategoryHandlingMethod.DUMMIFY;
        ret.missing_handling = MissingHandlingMethod.NONE;
        ret.missing_impute_with = CatImputationMethod.MODE;
        return ret;
    }

    @Override
    public void check(String featureName, MLTask task) throws Exception {
        if (!this.role.isInput()) {
            return;
        }
        if (this.missing_handling == null) {
            throw ErrorContext.iaef((String)"Feature %s has no missing handling method", (Object)featureName, (Object[])new Object[0]);
        }
        if (this.missing_handling == MissingHandlingMethod.IMPUTE) {
            if (this.missing_impute_with == null) {
                throw ErrorContext.iaef((String)"Feature %s has no missing_impute_with parameter", (Object)featureName, (Object[])new Object[0]);
            }
            if (this.missing_impute_with == CatImputationMethod.CONSTANT && StringUtils.isBlank((String)this.impute_constant_value)) {
                throw ErrorContext.iaef((String)"Feature %s has no value for missing imputation", (Object)featureName, (Object[])new Object[0]);
            }
        }
        if (this.category_handling == CategoryHandlingMethod.DUMMIFY) {
            if (this.dummy_clip == null) {
                throw ErrorContext.iaef((String)"Dummies for %s have no dummy clipping method.", (Object)featureName, (Object[])new Object[0]);
            }
            if (this.dummy_drop == null) {
                throw ErrorContext.iaef((String)"Dummies for %s have no dropping method.", (Object)featureName, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public boolean usesCustomHandling() {
        if (!this.role.isInput()) {
            return false;
        }
        return !StringUtils.isBlank((String)this.customHandlingCode) && this.category_handling == CategoryHandlingMethod.CUSTOM;
    }

    public static enum DummyClippingMethod {
        MAX_NB_CATEGORIES,
        CUMULATIVE_PROPORTION,
        MIN_SAMPLES;

    }

    public static enum DummyDroppingMethod {
        NONE,
        DROP,
        AUTO;

    }

    public static enum ImpactMethod {
        M_ESTIMATOR,
        GLMM;

    }

    public static enum OrdinalOrder {
        COUNT,
        LEXICOGRAPHIC;

    }

    public static enum OrdinalDefault {
        HIGHEST,
        MEDIAN,
        EXPLICIT;

    }

    public static enum FrequencyDefault {
        MIN,
        MEDIAN,
        MAX,
        EXPLICIT;

    }

    public static enum CategoryHandlingMethod {
        FLAG_PRESENCE,
        IMPACT,
        DUMMIFY,
        HASHING,
        ORDINAL,
        FREQUENCY,
        CUSTOM,
        NONE;

    }

    public static enum MissingHandlingMethod {
        NONE,
        IMPUTE,
        DROP_ROW;

    }

    public static enum CatImputationMethod {
        MODE,
        CONSTANT;

    }
}

