/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.azureml;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractFullyManagedStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.AzureMLDeploymentSummary;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.comparator.AzureMLEnvironmentComparator;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.comparator.AzureMLModelComparator;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.comparator.AzureMLOnlineDeploymentComparator;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.comparator.AzureMLOnlineEndpointComparator;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.comparator.AzureMLResourceComparator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResource;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureMLDeploymentStatusReporter
extends AbstractFullyManagedStatusReporter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.azureml.status-reporter");

    public AzureMLDeploymentStatusReporter(String infraId, String deploymentId) {
        super(infraId, deploymentId);
    }

    public DeploymentStatusReport computeBasicCheck(@Nonnull AzureMLDeploymentSummary storedSummary, @Nullable AzureMLOnlineEndpoint deployedOnlineEndpoint, boolean isDeploymentEnabled) {
        DeploymentStatusReport basicStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        if (isDeploymentEnabled) {
            basicStatusReport.statusMessages.mergeFrom(this.checkResourceSync(storedSummary.onlineEndpoint, deployedOnlineEndpoint, new AzureMLOnlineEndpointComparator(storedSummary.onlineEndpoint)));
            if (!basicStatusReport.statusMessages.isEmpty()) {
                basicStatusReport.isOutOfSync = true;
                basicStatusReport.setHealthWithSeverity(DeploymentHealth.OUT_OF_SYNC);
            }
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> onlineEndpointStatusReport = this.checkOnlineEndpointHealth(storedSummary, deployedOnlineEndpoint, isDeploymentEnabled);
        basicStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)onlineEndpointStatusReport.second);
        basicStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)onlineEndpointStatusReport.first));
        return basicStatusReport;
    }

    public DeploymentStatusReport computeFullCheck(@Nonnull AzureMLDeploymentSummary storedSummary, @Nonnull AzureMLDeploymentSummary deployedSummary, boolean isDeploymentEnabled) {
        DeploymentStatusReport fullStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        fullStatusReport.statusMessages.mergeFrom(this.checkResourceSync(storedSummary.model, deployedSummary.model, new AzureMLModelComparator(storedSummary.model)));
        fullStatusReport.statusMessages.mergeFrom(this.checkResourceSync(storedSummary.environment, deployedSummary.environment, new AzureMLEnvironmentComparator(storedSummary.environment)));
        fullStatusReport.statusMessages.mergeFrom(this.checkResourceSync(storedSummary.onlineEndpoint, deployedSummary.onlineEndpoint, new AzureMLOnlineEndpointComparator(storedSummary.onlineEndpoint)));
        fullStatusReport.statusMessages.mergeFrom(this.checkResourceSync(storedSummary.onlineDeployment, deployedSummary.onlineDeployment, new AzureMLOnlineDeploymentComparator(storedSummary.onlineDeployment)));
        if (!fullStatusReport.statusMessages.isEmpty()) {
            fullStatusReport.isOutOfSync = true;
            fullStatusReport.setHealthWithSeverity(DeploymentHealth.OUT_OF_SYNC);
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> onlineEndpointStatusReport = this.checkOnlineEndpointHealth(storedSummary, deployedSummary.onlineEndpoint, isDeploymentEnabled);
        fullStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)onlineEndpointStatusReport.second);
        fullStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)onlineEndpointStatusReport.first));
        InfoMessage.InfoMessages onlineDeploymentStatusHealthMessages = this.checkOnlineDeploymentHealth(storedSummary.onlineDeployment, deployedSummary.onlineDeployment, isDeploymentEnabled);
        fullStatusReport.statusMessages.mergeFrom(onlineDeploymentStatusHealthMessages);
        return fullStatusReport;
    }

    private <T extends AzureMLResource> InfoMessage.InfoMessages checkResourceSync(@Nonnull T storedResource, @Nullable T deployedResource, @Nonnull AzureMLResourceComparator<T> comparator) {
        InfoMessage.InfoMessages resourceOutOfSyncMessages = new InfoMessage.InfoMessages();
        boolean resourceShouldExist = StringUtils.isNotBlank((CharSequence)storedResource.name);
        if (resourceShouldExist && deployedResource == null) {
            String message = "%s '%s' is not present in AzureML. Updating the deployment should create it.";
            logger.errorV(message, new Object[]{storedResource.getResourceTypeLabel(), storedResource.name});
            resourceOutOfSyncMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{storedResource.getResourceTypeLabel(), storedResource.name});
        } else if (deployedResource != null) {
            Set<String> outOfSyncReport = comparator.reportOutOfSyncFields(deployedResource);
            outOfSyncReport.addAll(comparator.reportOutOfSyncNonDSSTags(deployedResource.tags));
            if (!outOfSyncReport.isEmpty()) {
                for (String outOfSyncField : outOfSyncReport) {
                    logger.warnV("AzureML %s '%s' out of sync. %s", new Object[]{storedResource.getResourceTypeLabel(), deployedResource.name, outOfSyncField});
                    resourceOutOfSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
            } else {
                logger.debugV("AzureML %s '%s' is synchronized.", new Object[]{storedResource.getResourceTypeLabel(), storedResource.name});
            }
        }
        return resourceOutOfSyncMessages;
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> checkOnlineEndpointHealth(@Nonnull AzureMLDeploymentSummary storedSummary, @Nullable AzureMLOnlineEndpoint deployedOnlineEndpoint, boolean isDeploymentEnabled) {
        AzureMLResource.ResourceProvisioningState onlineEndpointProvisioningState;
        InfoMessage.InfoMessages endpointHealthMessages = new InfoMessage.InfoMessages();
        DeploymentHealth endpointHealth = DeploymentHealth.HEALTHY;
        String onlineEndpointName = deployedOnlineEndpoint != null ? deployedOnlineEndpoint.name : "";
        String onlineDeploymentName = storedSummary.onlineDeployment != null ? storedSummary.onlineDeployment.name : "";
        boolean exists = deployedOnlineEndpoint != null;
        boolean endpointShouldExist = StringUtils.isNotBlank((CharSequence)storedSummary.onlineEndpoint.name);
        HashMap traffic = deployedOnlineEndpoint != null ? deployedOnlineEndpoint.traffic : new HashMap();
        AzureMLResource.ResourceProvisioningState resourceProvisioningState = onlineEndpointProvisioningState = exists ? deployedOnlineEndpoint.provisioningState : null;
        if (isDeploymentEnabled) {
            if (exists) {
                DeploymentHealth trafficHealth = DeploymentHealth.HEALTHY;
                if (StringUtils.isNotBlank((CharSequence)onlineDeploymentName)) {
                    int trafficForDefinedOnlineDeployment = traffic.getOrDefault(onlineDeploymentName, 0);
                    if (traffic.isEmpty()) {
                        trafficHealth = DeploymentHealth.UNHEALTHY;
                        endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_ENDPOINT_HAS_NO_MODEL_DEPLOYED, "Online Deployment '%s' is missing in the Online Endpoint '%s'.", new Object[]{onlineDeploymentName, onlineEndpointName});
                    } else if (trafficForDefinedOnlineDeployment == 0) {
                        trafficHealth = DeploymentHealth.UNHEALTHY;
                        endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_ENDPOINT_TRAFFIC, "The traffic configured for Online Deployment '%s' associated to the Online Endpoint '%s' is set to %s%% instead of 100%%.", new Object[]{onlineDeploymentName, onlineEndpointName, trafficForDefinedOnlineDeployment});
                    } else if (trafficForDefinedOnlineDeployment != 100) {
                        trafficHealth = DeploymentHealth.WARNING;
                        endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_ENDPOINT_TRAFFIC, "The traffic configured for Online Deployment '%s' associated to the Online Endpoint '%s' is set to %s%% instead of 100%%.", new Object[]{onlineDeploymentName, onlineEndpointName, trafficForDefinedOnlineDeployment});
                    }
                    endpointHealth = endpointHealth.getSeverer(trafficHealth);
                }
                for (Map.Entry trafficEntry : traffic.entrySet()) {
                    if (StringUtils.equals((CharSequence)((CharSequence)trafficEntry.getKey()), (CharSequence)onlineDeploymentName)) continue;
                    trafficHealth = DeploymentHealth.WARNING;
                    endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_ENDPOINT_TRAFFIC, "Unexpected unmanaged Online Deployment '%s' associated to the Online Endpoint '%s'. Its traffic is set to %s%%. You might be incurring in unnecessary costs.", new Object[]{trafficEntry.getKey(), onlineEndpointName, trafficEntry.getValue()});
                }
                endpointHealth = endpointHealth.getSeverer(trafficHealth);
                AzureMLResource.ResourceProvisioningState endpointState = deployedOnlineEndpoint.provisioningState;
                Pair<DeploymentHealth, InfoMessage.InfoMessages> onlineEndpointHealth = AzureMLUtils.getEndpointHealthFromState(endpointState);
                endpointHealth = endpointHealth.getSeverer((DeploymentHealth)((Object)onlineEndpointHealth.first));
                endpointHealthMessages.mergeFrom((InfoMessage.InfoMessages)onlineEndpointHealth.second);
            } else if (!endpointShouldExist) {
                endpointHealth = DeploymentHealth.OUT_OF_SYNC;
                endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_DEPLOYMENT_INCOMPLETE, "The deployment is incomplete");
            } else {
                String message = "Online Endpoint '%s' is not present in AzureML. Updating the deployment should create it.";
                endpointHealth = DeploymentHealth.UNHEALTHY;
                endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{storedSummary.onlineEndpoint.name});
            }
        } else if (exists && !AzureMLResource.ResourceProvisioningState.DELETING.equals((Object)onlineEndpointProvisioningState)) {
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, String.format("The deployment is disabled but the AzureML Online Endpoint '%s' exists. Update your deployment to completely disable it.", onlineEndpointName));
            endpointHealth = DeploymentHealth.OUT_OF_SYNC;
        } else {
            endpointHealth = DeploymentHealth.DISABLED;
            endpointHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_FULLY_MANAGED_DISABLED_DEPLOYMENT, "Update the deployment settings in order to enable it again.");
        }
        return new Pair((Object)endpointHealth, (Object)endpointHealthMessages);
    }

    private InfoMessage.InfoMessages checkOnlineDeploymentHealth(@Nonnull AzureMLOnlineDeployment storedOnlineDeployment, @Nullable AzureMLOnlineDeployment deployedOnlineDeployment, boolean isDeploymentEnabled) {
        InfoMessage.InfoMessages deploymentHealthMessages = new InfoMessage.InfoMessages();
        String onlineDeploymentName = storedOnlineDeployment.name;
        boolean exists = deployedOnlineDeployment != null;
        boolean onlineDeploymentShouldExist = StringUtils.isNotBlank((CharSequence)onlineDeploymentName);
        if (isDeploymentEnabled) {
            if (exists) {
                AzureMLOnlineDeployment.DeploymentProvisioningState deploymentState = deployedOnlineDeployment.provisioningState;
                if (AzureMLOnlineDeployment.DeploymentProvisioningState.CREATING.equals((Object)deploymentState)) {
                    deploymentHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_CREATING_STATE, "");
                } else if (AzureMLOnlineDeployment.DeploymentProvisioningState.DELETING.equals((Object)deploymentState)) {
                    deploymentHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_DELETING_STATE, "");
                } else if (AzureMLOnlineDeployment.DeploymentProvisioningState.SCALING.equals((Object)deploymentState)) {
                    deploymentHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_SCALING_STATE, "");
                } else if (AzureMLOnlineDeployment.DeploymentProvisioningState.UPDATING.equals((Object)deploymentState)) {
                    deploymentHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_UPDATING_STATE, "");
                } else if (AzureMLOnlineDeployment.DeploymentProvisioningState.SUCCEEDED.equals((Object)deploymentState)) {
                    deploymentHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_SUCCEEDED_STATE, "");
                } else if (AzureMLOnlineDeployment.DeploymentProvisioningState.FAILED.equals((Object)deploymentState)) {
                    deploymentHealthMessages.withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_FAILED_STATE, "");
                } else if (AzureMLOnlineDeployment.DeploymentProvisioningState.CANCELED.equals((Object)deploymentState)) {
                    deploymentHealthMessages.withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_CANCELED_STATE, "");
                } else {
                    deploymentHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_UNKNOWN_STATE, "The AzureML Online Deployment is in status %s", new Object[]{deploymentState.getName()});
                }
            } else if (!onlineDeploymentShouldExist) {
                deploymentHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_DEPLOYMENT_INCOMPLETE, "The deployment is incomplete");
            } else {
                String message = "Online Deployment '%s' is not present in AzureML. Updating the deployment should create it.";
                logger.warnV(message, new Object[]{onlineDeploymentName});
                deploymentHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{onlineDeploymentName});
            }
        } else if (exists) {
            deploymentHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, String.format("The deployment is disabled but the AzureML Online Deployment '%s' exists. Update your deployment to completely disable it.", onlineDeploymentName));
        }
        return deploymentHealthMessages;
    }
}

