/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.sagemaker;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractFullyManagedStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerDeploymentSummary;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerEndpoint;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerEndpointConfig;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerModel;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.comparator.SageMakerEndpointComparator;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.comparator.SageMakerEndpointConfigComparator;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.comparator.SageMakerModelComparator;
import com.dataiku.dip.apideployer.deploymentinfo.SageMakerDeploymentInfo;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointSummary;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SageMakerDeploymentStatusReporter
extends AbstractFullyManagedStatusReporter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.sagemaker.status-reporter");

    public SageMakerDeploymentStatusReporter(String infraId, String deploymentId) {
        super(infraId, deploymentId);
    }

    public DeploymentStatusReport computeBasicCheck(SageMakerEndpoint endpoint, boolean isDeploymentEnabled) {
        DeploymentStatusReport basicStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        String endpointStatus = null;
        boolean exists = endpoint.resourceDescription.isPresent();
        String failureMessage = null;
        if (exists) {
            DescribeEndpointResponse deployedEndpointDescription = (DescribeEndpointResponse)endpoint.resourceDescription.get();
            endpointStatus = deployedEndpointDescription.endpointStatus().toString();
            failureMessage = deployedEndpointDescription.failureReason();
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> endpointStatusReport = this.checkEndpointHealth(endpoint.name, endpointStatus, exists, endpoint.resourceShouldExist, failureMessage, isDeploymentEnabled);
        basicStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)endpointStatusReport.second);
        basicStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)endpointStatusReport.first));
        return basicStatusReport;
    }

    public DeploymentStatusReport computeBasicCheck(@Nullable EndpointSummary endpointSummary, @Nullable SageMakerDeploymentInfo lastDeploymentInfo, boolean isDeploymentEnabled) {
        DeploymentStatusReport basicStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        String endpointName = !Objects.isNull(lastDeploymentInfo) ? lastDeploymentInfo.sageMakerEndpointName : "";
        boolean exists = endpointSummary != null;
        boolean endpointShouldExist = !Objects.isNull(lastDeploymentInfo) && StringUtils.isNotBlank((CharSequence)lastDeploymentInfo.sageMakerEndpointName);
        String endpointStatus = null;
        if (exists) {
            endpointStatus = endpointSummary.endpointStatus().toString();
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> endpointStatusReport = this.checkEndpointHealth(endpointName, endpointStatus, exists, endpointShouldExist, null, isDeploymentEnabled);
        basicStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)endpointStatusReport.second);
        basicStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)endpointStatusReport.first));
        return basicStatusReport;
    }

    public DeploymentStatusReport computeFullCheck(SageMakerDeploymentSummary storedSummary, SageMakerDeploymentSummary deployedSummary, boolean isDeploymentEnabled) {
        DeploymentStatusReport fullStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        fullStatusReport.statusMessages.mergeFrom(this.checkDeployedModelSync(storedSummary, deployedSummary));
        fullStatusReport.statusMessages.mergeFrom(this.checkDeployedEndpointConfigSync(storedSummary, deployedSummary));
        fullStatusReport.statusMessages.mergeFrom(this.checkDeployedEndpointSync(storedSummary, deployedSummary));
        if (!fullStatusReport.statusMessages.isEmpty()) {
            fullStatusReport.isOutOfSync = true;
            fullStatusReport.setHealthWithSeverity(DeploymentHealth.OUT_OF_SYNC);
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> endpointStatusReport = this.checkEndpointHealth(deployedSummary.endpoint, isDeploymentEnabled);
        fullStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)endpointStatusReport.second);
        fullStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)endpointStatusReport.first));
        return fullStatusReport;
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> checkEndpointHealth(SageMakerEndpoint endpoint, boolean isDeploymentEnabled) {
        String endpointStatus = null;
        boolean exists = endpoint.resourceDescription.isPresent();
        String failureMessage = null;
        if (exists) {
            DescribeEndpointResponse deployedEndpointDescription = (DescribeEndpointResponse)endpoint.resourceDescription.get();
            endpointStatus = deployedEndpointDescription.endpointStatus().toString();
            failureMessage = deployedEndpointDescription.failureReason();
        }
        return this.checkEndpointHealth(endpoint.name, endpointStatus, exists, endpoint.resourceShouldExist, failureMessage, isDeploymentEnabled);
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> checkEndpointHealth(String endpointName, @Nullable String endpointStatus, boolean exists, boolean endpointShouldExist, @Nullable String failureMessage, boolean isDeploymentEnabled) {
        DeploymentHealth endpointHealth;
        InfoMessage.InfoMessages endpointHealthMessages = new InfoMessage.InfoMessages();
        if (isDeploymentEnabled) {
            if (exists) {
                Pair<DeploymentHealth, InfoMessage.InfoMessages> sageMakerEndpointHealth = SageMakerUtils.getEndpointHealth(endpointStatus, failureMessage);
                endpointHealth = (DeploymentHealth)((Object)sageMakerEndpointHealth.first);
                endpointHealthMessages.mergeFrom((InfoMessage.InfoMessages)sageMakerEndpointHealth.second);
            } else if (!endpointShouldExist) {
                endpointHealth = DeploymentHealth.OUT_OF_SYNC;
                endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DEPLOYMENT_INCOMPLETE, "The deployment is incomplete.", new Object[0]);
            } else {
                String message = "Endpoint '%s' is not present in SageMaker. Updating the deployment should create it.";
                logger.warnV(message, new Object[]{endpointName});
                endpointHealth = DeploymentHealth.UNHEALTHY;
                endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{endpointName});
            }
        } else if (exists) {
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, String.format("The deployment is disabled but the SageMaker Endpoint '%s' exists. Update your deployment to completely disable it.", endpointName));
            endpointHealth = DeploymentHealth.OUT_OF_SYNC;
        } else {
            endpointHealth = DeploymentHealth.DISABLED;
            endpointHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_FULLY_MANAGED_DISABLED_DEPLOYMENT, "Update the deployment settings in order to enable it again.");
        }
        return new Pair((Object)endpointHealth, (Object)endpointHealthMessages);
    }

    private InfoMessage.InfoMessages checkDeployedModelSync(SageMakerDeploymentSummary storedSummary, SageMakerDeploymentSummary deployedSummary) {
        InfoMessage.InfoMessages modelOutOfSyncMessages = new InfoMessage.InfoMessages();
        SageMakerModel storedModel = storedSummary.model;
        SageMakerModel deployedModel = deployedSummary.model;
        String modelName = deployedModel.name;
        if (deployedModel.resourceShouldExist && !deployedModel.resourceDescription.isPresent()) {
            String missingMessage = "The latest deployed SageMaker Model %s is missing, so it is likely someone has deleted the SageMaker model manually.";
            logger.warnV(missingMessage, new Object[]{modelName});
            modelOutOfSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, missingMessage, new Object[]{modelName});
        } else if (deployedModel.resourceDescription.isPresent()) {
            SageMakerModelComparator modelComparator = new SageMakerModelComparator(storedModel);
            if (modelComparator.isOutOfSync(deployedModel) || modelComparator.areTagsOutOfSync(deployedModel.tags)) {
                for (String outOfSyncField : modelComparator.reportOutOfSyncFields(deployedModel)) {
                    logger.warnV("Deployment %s out of sync. %s", new Object[]{deployedSummary.deploymentId, outOfSyncField});
                    modelOutOfSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
            } else {
                logger.debugV("SageMaker model %s is synchronized.", new Object[]{modelName});
            }
        }
        return modelOutOfSyncMessages;
    }

    private InfoMessage.InfoMessages checkDeployedEndpointConfigSync(SageMakerDeploymentSummary storedSummary, SageMakerDeploymentSummary deployedSummary) {
        InfoMessage.InfoMessages endpointConfigOutOfSyncMessages = new InfoMessage.InfoMessages();
        SageMakerEndpointConfig storedEndpointConfig = storedSummary.endpointConfig;
        SageMakerEndpointConfig deployedEndpointConfig = deployedSummary.endpointConfig;
        String endpointConfigName = deployedEndpointConfig.name;
        if (deployedEndpointConfig.resourceShouldExist && !deployedEndpointConfig.resourceDescription.isPresent()) {
            String missingMessage = "The latest deployed SageMaker endpoint configuration %s is missing, so it is likely someone has deleted the SageMaker endpoint configuration manually.";
            logger.warnV(missingMessage, new Object[]{endpointConfigName});
            endpointConfigOutOfSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, missingMessage, new Object[]{endpointConfigName});
        } else if (deployedEndpointConfig.resourceDescription.isPresent()) {
            SageMakerEndpointConfigComparator endpointConfigComparator = new SageMakerEndpointConfigComparator(storedEndpointConfig);
            if (endpointConfigComparator.isOutOfSync(deployedEndpointConfig, deployedSummary.model) || endpointConfigComparator.areTagsOutOfSync(deployedEndpointConfig.tags)) {
                for (String outOfSyncField : endpointConfigComparator.reportOutOfSyncFields(deployedEndpointConfig)) {
                    logger.warnV("Deployment %s out of sync. %s", new Object[]{deployedSummary.deploymentId, outOfSyncField});
                    endpointConfigOutOfSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
            } else {
                logger.debugV("SageMaker endpoint config %s is synchronized.", new Object[]{endpointConfigName});
            }
        }
        return endpointConfigOutOfSyncMessages;
    }

    private InfoMessage.InfoMessages checkDeployedEndpointSync(SageMakerDeploymentSummary storedSummary, SageMakerDeploymentSummary deployedSummary) {
        InfoMessage.InfoMessages endpointHealthMessages = new InfoMessage.InfoMessages();
        SageMakerEndpoint storedEndpoint = storedSummary.endpoint;
        SageMakerEndpoint deployedEndpoint = deployedSummary.endpoint;
        String endpointName = deployedEndpoint.name;
        if (deployedEndpoint.resourceDescription.isPresent()) {
            SageMakerEndpointComparator endpointComparator = new SageMakerEndpointComparator(storedEndpoint);
            if (deployedEndpoint.isDescriptionTransient) {
                String message = "Unable to retrieve all the information for SageMaker endpoint %s since it is in a transient state. Refresh to retrieve again the information.";
                endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_TRANSIENT_STATE, message, new Object[]{endpointName});
            } else if (endpointComparator.isOutOfSync(deployedEndpoint, deployedSummary.endpointConfig) || endpointComparator.areTagsOutOfSync(deployedEndpoint.tags)) {
                for (String outOfSyncField : endpointComparator.reportOutOfSyncFields(deployedEndpoint)) {
                    logger.warnV("Deployment %s out of sync. %s", new Object[]{deployedSummary.deploymentId, outOfSyncField});
                    endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
                String failureMessage = ((DescribeEndpointResponse)deployedEndpoint.resourceDescription.get()).failureReason();
                if (StringUtils.isNotBlank((CharSequence)failureMessage)) {
                    String messageWithFailure = "The last update process has failed with the following message: %s";
                    endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, messageWithFailure, new Object[]{failureMessage});
                }
            } else {
                logger.debugV("SageMaker endpoint %s is synchronized.", new Object[]{endpointName});
            }
        }
        return endpointHealthMessages;
    }
}

