/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deploymentinfo;

import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.AbstractDeploymentInfo;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResource;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLVersionedResourceIdentifier;
import com.dataiku.dip.savedmodels.externalmodelidentifier.AzureMLEndpointIdentifier;
import javax.annotation.Nonnull;

public class AzureMLDeploymentInfo
extends AbstractDeploymentInfo {
    public String azSubscription;
    public String azResourceGroup;
    public String azWorkspace;
    public String azTenantId;
    public String azModelName;
    public String azModelVersion;
    public String azEnvironmentName;
    public String azEnvironmentVersion;
    public String azOnlineEndpointName;
    public String azOnlineDeploymentName;
    public AzureMLResource.ResourceProvisioningState modelProvisioningState;
    public AzureMLResource.ResourceProvisioningState environmentProvisioningState;
    public AzureMLResource.ResourceProvisioningState onlineEndpointProvisioningState;
    public AzureMLOnlineDeployment.DeploymentProvisioningState onlineDeploymentProvisioningState;
    public AzureMLResource.SystemData modelSystemData;
    public AzureMLResource.SystemData environmentSystemData;
    public AzureMLResource.SystemData onlineEndpointSystemData;
    public AzureMLResource.SystemData onlineDeploymentSystemData;

    private String formatAsResourceReference(@Nonnull String name, @Nonnull String version) {
        return String.format("azureml:%s:%s", name, version);
    }

    public String getModelRef() {
        return this.formatAsResourceReference(this.azModelName, this.azModelVersion);
    }

    public String getEnvironmentRef() {
        return this.formatAsResourceReference(this.azEnvironmentName, this.azEnvironmentVersion);
    }

    public AzureMLVersionedResourceIdentifier getModelIdentifier() {
        return new AzureMLVersionedResourceIdentifier(this.azModelName, this.azWorkspace, this.azResourceGroup, this.azSubscription, this.azModelVersion);
    }

    public AzureMLVersionedResourceIdentifier getEnvironmentIdentifier() {
        return new AzureMLVersionedResourceIdentifier(this.azEnvironmentName, this.azWorkspace, this.azResourceGroup, this.azSubscription, this.azEnvironmentVersion);
    }

    public AzureMLResourceIdentifier getOnlineEndpointIdentifier() {
        return new AzureMLResourceIdentifier(this.azOnlineEndpointName, this.azWorkspace, this.azResourceGroup, this.azSubscription);
    }

    public AzureMLResourceIdentifier getOnlineDeploymentIdentifier() {
        return new AzureMLResourceIdentifier(this.azOnlineDeploymentName, this.azOnlineEndpointName, this.azWorkspace, this.azResourceGroup, this.azSubscription);
    }

    public AzureMLDeploymentInfo() {
    }

    public AzureMLDeploymentInfo(@Nonnull String infraId, @Nonnull String deploymentId) {
        super(infraId, deploymentId, null);
    }

    public AzureMLDeploymentInfo(@Nonnull AzureMLAPIDeploymentInfra infra, @Nonnull String deploymentId) {
        super(infra.id, deploymentId, null);
        this.azSubscription = infra.azSubscription;
        this.azResourceGroup = infra.azResourceGroup;
        this.azWorkspace = infra.azWorkspace;
    }

    @Override
    public AzureMLEndpointIdentifier getExternalEndpointIdentifier() {
        return new AzureMLEndpointIdentifier(this.azOnlineEndpointName, this.azWorkspace, this.azResourceGroup, this.azSubscription);
    }
}

