/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dao.impl.FilesBasedUsersDAO;
import com.dataiku.dip.dao.impl.ManualDatasetsDAO;
import com.dataiku.dip.dao.impl.NoopProjectVersionTagsDAO;
import com.dataiku.dip.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKeyWithGroups;
import com.dataiku.dip.security.model.LegacyGlobalScopePublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.services.NoopProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class AddAdminPublicAPIKeyCommand
extends CLICommandWithInvalidateCommonFilesCache {
    @Override
    public String usageString() {
        return "add-admin-api-key";
    }

    @Override
    public String description() {
        return "Adds an administrator-level public API key to DSS";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        options.addOption("group", true, "[Optional] Admin group to add this key to");
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "add-admin-api-key", true);
        CLISetup.doSpringUtilsAndCoreServicesSetupForTestsAndCLI();
        SpringUtils.getInstance().registerAndAutowire(FilesBasedUsersDAO.class);
        SpringUtils.getInstance().registerAndAutowire(PubSubService.class);
        SpringUtils.getInstance().registerAndAutowire(NoopProjectVersionTagsDAO.class);
        SpringUtils.getInstance().registerAndAutowire(ManualDatasetsDAO.class);
        SpringUtils.getInstance().registerAndAutowire(NoopProjectsService.class);
        SpringUtils.getInstance().registerAndAutowire(PublicAPIKeysService.class);
        try (RWTransaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginWriteAsDSS();){
            AbstractGlobalScopePublicAPIKey key;
            PublicAPIKeysService keysService = (PublicAPIKeysService)SpringUtils.getBean(PublicAPIKeysService.class);
            keysService.standalone = true;
            if (cmdLine.hasOption("group")) {
                FilesBasedUsersDAO ud = new FilesBasedUsersDAO();
                String group = cmdLine.getOptionValue("group");
                UsersDAO.Group foundGroup = ud.getGroup(group);
                if (foundGroup == null) {
                    int n = this.usage(1, "Group " + group + " does not exist");
                    return n;
                }
                if (!foundGroup.isAdmin()) {
                    int n = this.usage(1, "Group " + group + " is not an administrator-level group");
                    return n;
                }
                GlobalScopePublicAPIKeyWithGroups groupedKey = new GlobalScopePublicAPIKeyWithGroups(List.of(group));
                key = groupedKey;
            } else {
                LegacyGlobalScopePublicAPIKey legacyKey = new LegacyGlobalScopePublicAPIKey();
                legacyKey.setGlobalPermissions(new UsersDAO.GroupPermissions().withAdmin(true));
                key = legacyKey;
            }
            key.label = "Added by dku command-line";
            key.createdBy = "CLI";
            key.createdOn = System.currentTimeMillis();
            System.out.println(keysService.createGlobalAPIKey((AbstractGlobalScopePublicAPIKey)key).key);
            t.commit("CLI: Added an admin API key");
            int n = 0;
            return n;
        }
    }
}

