/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.apideployer.monitoring.RrdUtils;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class UpgradeActivityRrdFilesCommand
extends CLICommand {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.migration.projects-version-tag");

    @Override
    public String usageString() {
        return "__upgrade_activity_rrd_files [--dry-run]";
    }

    @Override
    public String description() {
        return "Upgrade activity metric rrd files, e.g to take account new fields.";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        options.addOption("n", "dry-run", false, "Dry run. Only lists rrd files that will be updated.");
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "__upgrade_activity_rrd_files", true);
        boolean dryRun = cmdLine.hasOption("dry-run");
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        logger.info((Object)("Starting upgrading of activity rrd files to v3" + (dryRun ? " (dry run)" : "")));
        logger.info((Object)("Will consider files in " + String.valueOf(ApplicationConfigurator.getFile((String)"run/endpoint-activity-metrics/deployments")) + "/*/*.rrd and " + String.valueOf(ApplicationConfigurator.getFile((String)"run/endpoint-activity-metrics/scopes")) + "/*/*.rrd"));
        ArrayList activityRrds = new ArrayList();
        for (File deploymentFolder : DKUFileUtils.listFiles((File)ApplicationConfigurator.getFile((String)"run/endpoint-activity-metrics/deployments"))) {
            activityRrds.addAll(DKUFileUtils.listFiles((File)deploymentFolder, (dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".rrd")));
        }
        for (File deploymentFolder : DKUFileUtils.listFiles((File)ApplicationConfigurator.getFile((String)"run/endpoint-activity-metrics/scopes"))) {
            activityRrds.addAll(DKUFileUtils.listFiles((File)deploymentFolder, (dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".rrd")));
        }
        logger.info((Object)(activityRrds.size() + " files found. Processing, this might take some time."));
        int upgradedCount = 0;
        for (File rrdFile : activityRrds) {
            try {
                int rrdVersion = RrdUtils.getRrdActivityMetricsVersion_NT(rrdFile);
                if (rrdVersion < 3) {
                    if (dryRun) {
                        logger.info((Object)(rrdFile.getAbsolutePath() + " is v" + rrdVersion + ". Dry run, not updating it to v3"));
                    } else {
                        RrdUtils.updateActivityRrdFile_NT(rrdFile);
                    }
                    ++upgradedCount;
                    continue;
                }
                logger.info((Object)(rrdFile.getAbsolutePath() + " already up-to date, skipping"));
            }
            catch (Exception e) {
                logger.errorV("Can't upgrade " + rrdFile.getAbsolutePath(), new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
        }
        logger.info((Object)("End of rrd file upgrade. " + upgradedCount + " files " + (dryRun ? "would have been migrated (dry run)" : "migrated")));
        return 0;
    }
}

