/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.activity.DSSUsageStatsInternalDB;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.connections.SQLBaseConnectionService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.dao.PersistentNotificationsInternalDB;
import com.dataiku.dip.dao.impl.ExternalCatalogInternalDB;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.db.SingleH2DatabaseConnectionsFactory;
import com.dataiku.dip.discussions.DiscussionsInternalDB;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.model.NoopCredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.server.services.JobsDatabaseIntegrationTypesMigrationTool;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.timelines.ProjectTimelineInternalDB;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.BackendVariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.cli.Options;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class V23MigrationCommand
extends CLICommand {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.cli.migration");

    @Override
    public String usageString() {
        return "__migrate_v23";
    }

    @Override
    public String description() {
        return "Upgrade structure of dss_schema_info in H2 databases";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        this.parseAndMiniSetup(args, this.usageString(), true);
        AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext();
        appContext.register(new Class[]{SpringUtils.class});
        appContext.register(new Class[]{NoopCredentialsService.class});
        appContext.register(new Class[]{DKUTransactionService.class});
        appContext.register(new Class[]{GeneralSettingsDAO.class});
        appContext.register(new Class[]{ScenarioRunContext.class});
        appContext.register(new Class[]{BackendVariablesService.class});
        appContext.register(new Class[]{DSSDBConnectionsManagementService.class});
        appContext.register(new Class[]{SQLBaseConnectionService.class});
        appContext.refresh();
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        logger.debug((Object)"Migrating schema version for discussions");
        DiscussionsInternalDB didb = new DiscussionsInternalDB();
        new GenericH2DBSchemaStructureUpgradeHandler(didb, true).run();
        logger.debug((Object)"Done migrating schema version for discussions");
        SpringUtils.getInstance().registerAndAutowire(DiscussionsInternalDB.class, (Object)didb);
        logger.debug((Object)"Migrating timelines");
        List<String> projectKeys = CLISetup.listProjectKeys();
        for (String projectKey : projectKeys) {
            try {
                new GenericH2DBSchemaStructureUpgradeHandler(new ProjectTimelineInternalDB(projectKey), false).run();
            }
            catch (SQLException e) {
                logger.error((Object)("Failed to migrate timeline database for project " + projectKey), (Throwable)e);
                logger.error((Object)"Will try move this broken database out of the way");
                File h2File = ApplicationConfigurator.getFile((String[])new String[]{"timelines", projectKey + ".h2.db"});
                if (h2File.isFile()) {
                    FileUtils.moveFile((File)h2File, (File)ApplicationConfigurator.getFile((String[])new String[]{"timelines", projectKey + ".h2.db.BROKEN." + DKUDateUtils.isoFormatFileFriendlyLocalNow()}));
                    continue;
                }
                File mvFile = ApplicationConfigurator.getFile((String[])new String[]{"timelines", projectKey + ".mv.db"});
                if (!mvFile.isFile()) continue;
                FileUtils.moveFile((File)mvFile, (File)ApplicationConfigurator.getFile((String[])new String[]{"timelines", projectKey + ".mv.db.BROKEN." + DKUDateUtils.isoFormatFileFriendlyLocalNow()}));
            }
        }
        logger.debug((Object)"Timelines migrated");
        logger.debug((Object)"Migrating notifications");
        new NotificationsH2DBSchemaStructureUpgradeHandler(new PersistentNotificationsInternalDB("user_offline_queues", 1)).run();
        new NotificationsH2DBSchemaStructureUpgradeHandler(new PersistentNotificationsInternalDB("persistent_notifications", 1)).run();
        logger.debug((Object)"Notifications migrated");
        logger.debug((Object)"Migrating flow_state");
        new FlowStateH2DBSchemaStructureUpgradeHandler(new FlowStateInternalDB()).run();
        logger.debug((Object)"flow_state migrated");
        logger.debug((Object)"Migrating schema version for all remaining internal databases");
        new GenericH2DBSchemaStructureUpgradeHandler(new InterestsInternalDB(), false).run();
        new GenericH2DBSchemaStructureUpgradeHandler(new ExternalCatalogInternalDB(), false).run();
        new GenericH2DBSchemaStructureUpgradeHandler(new ReadWriteJobsInternalDB(), false).run();
        new GenericH2DBSchemaStructureUpgradeHandler(new DSSUsageStatsInternalDB(), false).run();
        logger.debug((Object)"Migration of schema version done for all remaining internal databases");
        logger.info((Object)"Starting migration of integration types in jobs database");
        ReadWriteJobsInternalDB rji = new ReadWriteJobsInternalDB();
        rji.create();
        new JobsDatabaseIntegrationTypesMigrationTool(rji).runMigration();
        logger.info((Object)"Done migration of integration types");
        appContext.close();
        return 0;
    }

    static class GenericH2DBSchemaStructureUpgradeHandler
    extends H2DBSchemaStructureUpgradeHandler {
        private final boolean alwaysCreate;

        GenericH2DBSchemaStructureUpgradeHandler(AbstractDSSDBService service, boolean alwaysCreate) {
            super(service);
            this.alwaysCreate = alwaysCreate;
        }

        public void run() throws Exception {
            if (this.dbFileExists()) {
                this.addInternalIdToDSSSchemaVersion();
                this.service.create();
            } else {
                logger.warn((Object)("DB File does not exist " + String.valueOf(this.service.getH2File())));
                if (this.alwaysCreate) {
                    this.service.create();
                }
            }
        }
    }

    static class NotificationsH2DBSchemaStructureUpgradeHandler
    extends H2DBSchemaStructureUpgradeHandler {
        NotificationsH2DBSchemaStructureUpgradeHandler(AbstractDSSDBService service) {
            super(service);
        }

        public void run() throws Exception {
            if (this.dbFileExists()) {
                this.addInternalIdToDSSSchemaVersion();
                try (DSSDBConnection h2DBConnection = this.pool.borrowObject();){
                    this.renameTable(h2DBConnection, "NOTIFICATIONS", this.service.getName());
                    h2DBConnection.commit();
                }
                this.service.create();
            } else {
                logger.warn((Object)("DB File does not exist " + String.valueOf(this.service.getH2File())));
            }
        }
    }

    static class FlowStateH2DBSchemaStructureUpgradeHandler
    extends H2DBSchemaStructureUpgradeHandler {
        FlowStateH2DBSchemaStructureUpgradeHandler(AbstractDSSDBService service) {
            super(service);
        }

        public void run() throws Exception {
            if (this.dbFileExists()) {
                try (DSSDBConnection h2DBConnection = this.pool.borrowObject();){
                    this.renameTable(h2DBConnection, "DKU_SCHEMA_INFO", "DSS_SCHEMA_INFO");
                    h2DBConnection.commit();
                }
                this.addInternalIdToDSSSchemaVersion();
                this.service.create();
            } else {
                logger.warn((Object)("DB File does not exist " + String.valueOf(this.service.getH2File())));
            }
        }
    }

    static class H2DBSchemaStructureUpgradeHandler {
        protected final AbstractDSSDBService service;
        protected final SingleH2DatabaseConnectionsFactory factory;
        protected final DSSDBConnectionsManagementService.ConnectionPool pool;
        private final H2SQLDialect h2Dialect = new H2SQLDialect();

        H2DBSchemaStructureUpgradeHandler(AbstractDSSDBService service) {
            this.service = service;
            String jdbcUrl = DSSDBConnectionsManagementService.buildH2JdbcUrl(service.getName(), false, service.getDBRef().h2File, service.getDBRef().lockTimeout, service.getDBRef().nameForConfigKey);
            this.factory = new SingleH2DatabaseConnectionsFactory("upgrade-" + service.getName(), "upgrade-" + service.getDBRef().nameForConfigKey, jdbcUrl);
            this.pool = new DSSDBConnectionsManagementService.ConnectionPool(this.factory);
            assert (service.getDialect() instanceof H2SQLDialect) : "Do not define an external database before the migration step is performed.";
        }

        boolean dbFileExists() {
            try {
                return SingleH2DatabaseConnectionsFactory.getDBFile(this.service.getH2File()).exists();
            }
            catch (CodedSQLException e) {
                logger.debug((Object)"H2 db file does not exist.", (Throwable)e);
                return false;
            }
        }

        void addInternalIdToDSSSchemaVersion() throws Exception {
            logger.info((Object)("Upgrading dss_schema_version on " + this.service.getName()));
            try (DSSDBConnection h2DBConnection = this.pool.borrowObject();){
                try (Statement st2 = h2DBConnection.createStatement();){
                    st2.execute("ALTER TABLE " + this.h2Dialect.quoteIdentifier("DSS_SCHEMA_INFO") + " ADD COLUMN " + this.h2Dialect.quoteIdentifier(AbstractDSSDBService.INTERNAL_ID_SCHEMA_COLUMN.getName()) + " varchar");
                    st2.execute("UPDATE " + this.h2Dialect.quoteIdentifier("DSS_SCHEMA_INFO") + " SET " + this.h2Dialect.quoteIdentifier(AbstractDSSDBService.INTERNAL_ID_SCHEMA_COLUMN.getName()) + "=" + this.h2Dialect.quoteString(AbstractDSSDBService.getInternalId(this.service.getName())));
                    st2.execute("ALTER TABLE " + this.h2Dialect.quoteIdentifier("DSS_SCHEMA_INFO") + " ALTER COLUMN " + this.h2Dialect.quoteIdentifier(AbstractDSSDBService.INTERNAL_ID_SCHEMA_COLUMN.getName()) + " SET NOT NULL");
                    st2.execute("ALTER TABLE " + this.h2Dialect.quoteIdentifier("DSS_SCHEMA_INFO") + "ADD CONSTRAINT primary_key PRIMARY KEY (" + this.h2Dialect.quoteIdentifier(AbstractDSSDBService.INTERNAL_ID_SCHEMA_COLUMN.getName()) + ")");
                }
                catch (Exception e) {
                    logger.errorV("Failed to upgrade the structure of dss_schema_info for " + this.service.getName(), new Object[0]);
                    h2DBConnection.rollback();
                    throw e;
                }
                h2DBConnection.commit();
            }
        }

        protected void renameTable(DSSDBConnection h2DBConnection, String tableNameBefore, String tableNameAfter) throws Exception {
            logger.infoV("Renaming table %s to %s on %s", new Object[]{tableNameBefore, tableNameAfter, this.service.getName()});
            try (PreparedStatement st2 = h2DBConnection.prepareNonPersistedStatement(String.format("ALTER TABLE %s RENAME TO %s", this.h2Dialect.quoteIdentifier(tableNameBefore), this.h2Dialect.quoteIdentifier(tableNameAfter)));){
                st2.execute();
            }
            catch (Exception e) {
                logger.errorV("Could not rename DB from %s to %s.", new Object[]{tableNameBefore, tableNameAfter});
                throw e;
            }
        }
    }
}

