/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.SecretString;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSQLConnection
extends DSSConnection {
    private static final String LOCAL_URL_PATTERN = "\\A\\s*(?>jdbc:h2:(?!ssl://|tcp://)|jdbc:hsqldb:(?!(?:hsql|http)s?://)|jdbc:sqlite:|jdbc:derby:(?!(?:net:)?//)).*\\z";
    private static final String URL_WITH_DRIVER_EXPANSION = "\\A(?!([^$:]+:){2}).*\\z";
    private static final String DEFAULT_UNSAFE_JDBC_URL_PATTERN = "(\\A\\s*(?>jdbc:h2:(?!ssl://|tcp://)|jdbc:hsqldb:(?!(?:hsql|http)s?://)|jdbc:sqlite:|jdbc:derby:(?!(?:net:)?//)).*\\z)|(\\A(?!([^$:]+:){2}).*\\z)";

    public abstract SQLDialect getDialect();

    public abstract AbstractSQLParams getParams();

    public String getDefaultCatalog() {
        return null;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.getParams().expandInPlaceAtDAOLevelUsingGlobalContextOnly(vc);
    }

    abstract String getDriver();

    String getJarsDirectory() {
        return this.getParams().jarsDirectory;
    }

    public List<String> getKnownDriverJars() {
        return Lists.newArrayList();
    }

    protected List<String> getKnownDriverJarsFromJarsDirectory() {
        if (!this.getParams().sendDriverJarsToSpark) {
            return Lists.newArrayList();
        }
        String jarsDirectory = this.getJarsDirectory();
        if (StringUtils.isBlank((String)jarsDirectory)) {
            jarsDirectory = ApplicationConfigurator.getFile((String[])new String[]{"lib", "jdbc"}).getAbsolutePath();
        }
        File jarsDir = new File(jarsDirectory);
        ArrayList ret = Lists.newArrayList();
        FilenameFilter jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return name.endsWith(".jar");
            }
        };
        for (File file : jarsDir.listFiles(jarFilter)) {
            ret.add(file.getAbsolutePath());
        }
        return ret;
    }

    abstract String getJdbcUrl();

    abstract String getDisplayableJdbcUrl();

    @Override
    public boolean isProperSQL() {
        return true;
    }

    public boolean shouldPreferTruncateTable() {
        return this.getParams().useTruncate;
    }

    public abstract SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx var1, String var2) throws DKUSecurityException, SQLException;

    void fillConnectionData(SQLConnectionProvider.SQLConnectionData cd) {
        cd.withSchemaSearchPath(this.getParams().schemaSearchPath);
        if (this.getParams().properties != null) {
            for (CustomDatabaseProperty property : this.getParams().properties) {
                cd.withProperty(property);
            }
        }
    }

    @Override
    public boolean mayBeSavedAsPersonalConnectionByNonAdmin() {
        return !AbstractSQLConnection.isUnsafeJdbcUrl(this.getJdbcUrl());
    }

    public static boolean isUnsafeJdbcUrl(String url) {
        if (url == null) {
            return false;
        }
        String regex = ApplicationConfigurator.getProperty((String)"dku.security.jdbc.unsafeUrlPattern", (String)DEFAULT_UNSAFE_JDBC_URL_PATTERN);
        Pattern pattern = Pattern.compile(regex, 34);
        return pattern.matcher(url).matches();
    }

    @Override
    public List<CustomDatabaseProperty> getDkuProperties() {
        return this.getParams().dkuProperties;
    }

    public Params getDkuPropertiesAsParams() {
        return CustomDatabaseProperty.toParams(this.getParams().dkuProperties);
    }

    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        ret.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "This connection cannot be used directly from Spark");
        return ret;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testSQL_NOTRANSACTION(null, this, authCtx);
    }

    public static abstract class AbstractSQLParams
    extends DSSConnection.DkuConnectionParams {
        public SQLManagedDatasetNamingRule namingRule = new SQLManagedDatasetNamingRule();
        public String schemaSearchPath;
        public boolean useTruncate;
        public boolean autocommitMode = false;
        public String jarsDirectory;
        public List<CustomDatabaseProperty> properties = new ArrayList<CustomDatabaseProperty>();
        public List<CustomDatabaseProperty> dkuProperties = new ArrayList<CustomDatabaseProperty>();
        public String postConnectStatements;
        public String jobOnlyPostConnectStatements;
        public boolean useAsMetastoreSource;
        public JDBCMetastoreSourceType metastoreSourceType = JDBCMetastoreSourceType.SPARKSQL_THRIFT;
        public boolean useConnectionLevelCatalogAndSchemaForJDBCMetadataTableCheck;
        public boolean sendDriverJarsToSpark;
        public String defaultAssumedTzForUnknownTz;
        public ConnectionPoolSettings connectionPoolSettings = new ConnectionPoolSettings();

        public void expandInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
            this.schemaSearchPath = vc.expandAllowUnresolved(this.schemaSearchPath);
        }

        public static enum JDBCMetastoreSourceType {
            SPARKSQL_THRIFT;

        }
    }

    public static class CustomDatabaseProperty {
        public String name;
        public String value;
        public boolean secret;

        public static Params toParams(List<CustomDatabaseProperty> list) {
            return new Params(CustomDatabaseProperty.toMap(list));
        }

        public static Map<String, String> toMap(List<CustomDatabaseProperty> list) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (CustomDatabaseProperty cdp : list) {
                map.put(cdp.name, cdp.value);
            }
            return map;
        }

        public static void encryptList(@Nullable List<CustomDatabaseProperty> list, PasswordEncryptionService encryptionService) {
            if (list == null) {
                return;
            }
            for (CustomDatabaseProperty cdp : list) {
                if (!cdp.secret) continue;
                cdp.value = encryptionService.encryptIfNotEncryptedOrEmpty(cdp.value);
            }
        }

        public static void decryptList(@Nullable List<CustomDatabaseProperty> list, PasswordEncryptionService encryptionService) {
            if (list == null) {
                return;
            }
            for (CustomDatabaseProperty cdp : list) {
                if (!cdp.secret) continue;
                cdp.value = encryptionService.decryptIfEncrypted(cdp.value);
            }
        }

        public static boolean hasNotBlankDkuProperty(List<CustomDatabaseProperty> properties, String name) {
            for (CustomDatabaseProperty property : properties) {
                if (!StringUtils.equals((String)name, (String)property.name) || !StringUtils.isNotBlank((String)property.value)) continue;
                return true;
            }
            return false;
        }

        public static String getDkuPropertyOrNull(List<CustomDatabaseProperty> properties, String name) {
            return CustomDatabaseProperty.getDkuPropertyOrDefault(properties, name, null);
        }

        public static String getDkuPropertyOrDefault(List<CustomDatabaseProperty> properties, String name, String defaultValue) {
            for (CustomDatabaseProperty property : properties) {
                if (!StringUtils.equals((String)name, (String)property.name)) continue;
                return property.value;
            }
            return defaultValue;
        }

        public CustomDatabaseProperty() {
        }

        public CustomDatabaseProperty(String name, String value, boolean secret) {
            this.name = name;
            this.value = value;
            this.secret = secret;
        }

        public CustomDatabaseProperty(String name, SecretString value) {
            this.name = name;
            this.value = value.secret;
            this.secret = true;
        }

        public SimpleKeyValue toSimpleKeyValue() {
            return new SimpleKeyValue(this.name, this.value);
        }

        public String toString() {
            String displayedValue = this.secret ? "*****" : this.value;
            return "CustomDatabaseProperty{name='" + this.name + "', value='" + displayedValue + "', secret=" + this.secret + "}";
        }
    }

    public static abstract class AbstractSQLParamsWithStdFields
    extends AbstractSQLParams {
        public String host;
        public String user;
        public String password;
        public String db;
        public boolean useURL;
        public String url;
        public String displayedUrl;
        public String fetchSize;

        @Override
        public void expandInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
            super.expandInPlaceAtDAOLevelUsingGlobalContextOnly(vc);
            this.fetchSize = vc.expand(this.fetchSize);
        }
    }

    public static class ConnectionPoolSettings {
        public boolean enabled = false;
        public boolean testOnBorrow = true;
        public long revalidateAfterMS = 0L;
        public boolean asynchronousGive;
        public long minEvictableIdleTimeSeconds = 600L;
        public long timeBetweenEvictionRunsSeconds = 180L;
        public int maxActive = -1;
        public int maxIdle = 8;
        public int validationTimeoutSeconds = 5;
    }

    public static class SQLManagedDatasetNamingRule {
        public String tableNameDatasetNamePrefix;
        public String tableNameDatasetNameSuffix;
        public String catalog;
        public boolean canOverrideCatalogInManagedDatasetCreation;
        public String schemaName;
        public boolean canOverrideSchemaInManagedDatasetCreation;
        public boolean writeDescriptionsAsSQLComment;
    }
}

