/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQLConnectionService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.sql.SQLDialect;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Properties;
import org.apache.log4j.Logger;

public interface AccessTokenInjectingConnection {
    public static final int MINUTES_TO_REFRESH_BEFORE_ACCESS_TOKEN_EXPIRES = 3;
    public static final int MINUTES_BEFORE_REFRESHING_FIRST_ACCESS_TOKEN = 1;
    public static final int NUMBER_MAX_REFRESH_TOKEN_RETRY = 3;
    public static final int SECONDS_BEFORE_NEXT_REFRESH_TOKEN_RETRY = 30;
    public static final Logger logger = Logger.getLogger((String)"dku.accesstoken.injecting.connection");

    public AccessTokenInjector buildAccessTokenInjector(Connection var1, Properties var2) throws SQLException;

    public boolean needsAccessTokenInjection();

    default public SQLConnectionProvider.GenericSQLConnectionData makeInjectingSQLConnectionData(ConnectionUtils.SQLConnectionType type, SQLDialect dialect, final AccessTokenInjectingConnection connection, String driver, String jdbcUrl, String jarsDirectory, final Class<? extends OAuth2Client.AccessTokenCredentialConvertible> clazz) {
        return new SQLConnectionProvider.GenericSQLConnectionData(type, dialect, (AbstractSQLConnection)((Object)connection), driver, jdbcUrl, jarsDirectory){

            @Override
            protected SQLConnectionProvider.SQLConnectionWrapper problemsAwareConnect(AuthCtx authCtx, SQLConnectionService.SQLConnectionKey connectionKey) throws SQLException {
                SQLConnectionProvider.SQLConnectionWrapper wrapper = super.problemsAwareConnect(authCtx, connectionKey);
                return new AccessTokenInjectingSQLConnectionWrapper(connection, this, wrapper.debugId, wrapper.verboseRollback, wrapper.getConnectionUnsafe(true), authCtx, wrapper.getConnectionCloser(), connectionKey.properties, clazz);
            }
        };
    }

    public static class RefreshTokenThread<T extends OAuth2Client.AccessTokenCredentialConvertible>
    extends Thread {
        private final AccessTokenInjectingConnection sqlConnection;
        private final AuthCtx authCtx;
        private final AccessTokenInjector injector;
        private final Class<T> clazz;

        public RefreshTokenThread(AccessTokenInjectingConnection sqlConnection, AuthCtx authCtx, Connection connection, Properties properties, Class<T> clazz) throws SQLException {
            this.sqlConnection = sqlConnection;
            this.authCtx = authCtx;
            this.injector = sqlConnection.buildAccessTokenInjector(connection, properties);
            this.clazz = clazz;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(Duration.ofMinutes(1L).toMillis());
            }
            catch (InterruptedException e) {
                logger.info((Object)"Refresh token thread has been interrupted before refreshing first access token", (Throwable)e);
                return;
            }
            int nbRefreshTokenFail = 0;
            do {
                try {
                    Thread.sleep(Duration.ofSeconds(30L).toMillis());
                    this.autoRefreshAccessToken();
                    nbRefreshTokenFail = 0;
                }
                catch (InterruptedException e) {
                    logger.info((Object)"Refresh token thread has been interrupted before refreshing next access token", (Throwable)e);
                    return;
                }
                catch (SQLClientInfoException e) {
                    logger.error((Object)"Refresh token thread couldn't inject refreshed access token into JDBC connection", (Throwable)e);
                    return;
                }
                catch (Exception e) {
                    logger.warn((Object)("Couldn't refresh token '" + ++nbRefreshTokenFail + "' time(s) in a row due to unknown reason."), (Throwable)e);
                }
            } while (nbRefreshTokenFail < 3);
            logger.info((Object)"Stopped token refresh in JDBC connection");
        }

        private void autoRefreshAccessToken() throws SQLException, InterruptedException, IOException, DKUSecurityException {
            logger.info((Object)"Refreshing token in JDBC connection");
            OAuth2Client.AccessTokenCredentialConvertible creds = (OAuth2Client.AccessTokenCredentialConvertible)((AbstractSQLConnection)((Object)this.sqlConnection)).getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), this.clazz);
            OAuth2Client.SerializableAccessTokenResult accessTokenResult = creds.toSerializableAccessTokenResult();
            long timeLeft = accessTokenResult.expiresOn - System.currentTimeMillis();
            logger.info((Object)("Successfully retrieved a new access token which expires in '" + timeLeft + "' ms"));
            this.injector.inject(accessTokenResult.accessToken);
            long sleepBeforeNext = timeLeft - Duration.ofMinutes(3L).toMillis();
            if (sleepBeforeNext <= 0L) {
                throw new IllegalStateException("Returned a token with a very short TTL (less than '3' mins), no need to retry as we would either otherwise swamp AAD or hit a token expired anyway.");
            }
            logger.info((Object)("Wait '" + sleepBeforeNext + "' ms before refreshing access token"));
            Thread.sleep(sleepBeforeNext);
        }
    }

    public static class AccessTokenInjectingSQLConnectionWrapper
    extends SQLConnectionProvider.SQLConnectionWrapper {
        private RefreshTokenThread refreshTokenThread;

        public AccessTokenInjectingSQLConnectionWrapper(AccessTokenInjectingConnection connection, SQLConnectionProvider.SQLConnectionData connData, String debugId, boolean verboseRollback, Connection conn, AuthCtx authCtx, SQLConnectionProvider.ConnectionCloser connectionCloser, Properties properties, Class<? extends OAuth2Client.AccessTokenCredentialConvertible> clazz) {
            super(connData, conn, debugId, verboseRollback, connectionCloser);
            if (connection.needsAccessTokenInjection()) {
                try {
                    this.refreshTokenThread = new RefreshTokenThread<OAuth2Client.AccessTokenCredentialConvertible>(connection, authCtx, conn, properties, clazz);
                    this.refreshTokenThread.start();
                }
                catch (SQLException e) {
                    logger.warn((Object)"Unable to inject access tokens. Query will fail when the token expires", (Throwable)e);
                }
            }
        }

        @Override
        public void close() throws SQLException {
            try {
                super.close();
            }
            finally {
                if (this.refreshTokenThread != null) {
                    this.refreshTokenThread.interrupt();
                }
            }
        }
    }

    public static interface AccessTokenInjector {
        public void inject(String var1) throws SQLException, InterruptedException, IOException, DKUSecurityException;
    }
}

