/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.common.krb.Krb5KeytabLoginContextCache;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.KerberizableConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;

public class OracleConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
KerberizableConnection {
    public static final String connectionType = "Oracle";
    public Params params = new Params();

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public OracleSQLDialect getDialect() {
        Boolean sqlDateAsDateonly = null;
        if (this.getDkuPropertiesAsParams().hasParam("sqlDate.as.dssDateonly")) {
            sqlDateAsDateonly = this.getDkuPropertiesAsParams().getBoolParam("sqlDate.as.dssDateonly", true);
        }
        return new OracleSQLDialect(this.params.maxIdentifierSize, sqlDateAsDateonly);
    }

    @Override
    String getDriver() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Oracle connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return "jdbc:oracle:thin:@" + this.params.host + ":" + this.params.port + ":" + this.params.db;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        return super.getFullyResolvedCredentials_internal(ctx, clazz);
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return !this.params.kerberosLoginEnabled;
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        ICredentialsService.BasicCredential creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
        SQLConnectionProvider.GenericSQLConnectionData cd = this.params.kerberosLoginEnabled ? new SQLConnectionProvider.GenericSQLConnectionData(ConnectionUtils.SQLConnectionType.ORACLE, this.getDialect(), this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory()){

            @Override
            public Subject getDoAs() throws Exception {
                return Krb5KeytabLoginContextCache.get(OracleConnection.this.params.dssPrincipal, OracleConnection.this.params.dssKeytabPath).getSubject();
            }
        } : new SQLConnectionProvider.GenericSQLConnectionData(ConnectionUtils.SQLConnectionType.ORACLE, (SQLDialect)this.getDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        if (this.actuallyHasBasicCredential() && creds != null) {
            if (creds.user != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.user, false));
            }
            if (creds.password != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", creds.password, true));
            }
        }
        if (StringUtils.isNotBlank((String)this.params.proxyUserName)) {
            cd.withProperty("oracle.jdbc.proxyClientName", this.params.proxyUserName);
        }
        return cd;
    }

    public boolean mayNeedAdditionalProperties() {
        if (this.params.kerberosLoginEnabled) {
            boolean someKerberosProperty = false;
            for (AbstractSQLConnection.CustomDatabaseProperty prop : this.params.properties) {
                if (prop.name != null && prop.name.toLowerCase().contains("kerberos")) {
                    someKerberosProperty = true;
                }
                if (prop.value == null || !prop.value.toLowerCase().contains("kerberos")) continue;
                someKerberosProperty = true;
            }
            return !someKerberosProperty;
        }
        return false;
    }

    @Override
    public boolean isKerberosLoginEnabled() {
        return this.params.kerberosLoginEnabled;
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (this.params.kerberosLoginEnabled) {
            ret.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Kerberos login isn't compatible with direct access from Spark");
        }
        return ret;
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port = 1521;
        public boolean kerberosLoginEnabled;
        public String dssPrincipal;
        public String dssKeytabPath;
        public String proxyUserName;
        public int maxIdentifierSize = 30;
    }
}

