/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.ConfValidators;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.sql.PostgreSQL14Dialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PostgreSQLConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public static final String connectionType = "PostgreSQL";
    protected Params params = new Params();

    @Override
    public AbstractSQLConnection.AbstractSQLParams getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void checkConfiguration() throws CodedException, DKUSecurityException {
        if (this.params.useURL) {
            ConfValidators.checkNotBlank(this.params.url, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Url");
        } else {
            ConfValidators.checkNotBlank(this.params.host, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Host");
            ConfValidators.checkNotBlank(this.params.db, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Database");
        }
    }

    @Override
    public SQLDialect getDialect() {
        return StringUtils.isBlank((String)this.params.version) || this.params.version.endsWith("14") ? new PostgreSQL14Dialect() : new PostgreSQLDialect();
    }

    @Override
    String getDriver() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.driver;
        }
        return "org.postgresql.Driver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Postgress connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return "jdbc:postgresql://" + this.params.host + ":" + this.params.port + "/" + this.params.db;
    }

    @Override
    String getJarsDirectory() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.jarsDirectory;
        }
        switch (this.params.driverMode) {
            case MANAGED: {
                return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-postgresql"}).getAbsolutePath();
            }
            case CUSTOM: {
                return this.params.jarsDirectory;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testPostgreSQL(authCtx, this);
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public PostgreSQLDriverMode driverMode = PostgreSQLDriverMode.MANAGED;
        public String driver;
        public int port = 5432;
        public boolean postGISenabled;
        public String version;
    }

    public static enum PostgreSQLDriverMode {
        MANAGED,
        CUSTOM;

    }
}

