/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithOAuth2ConfigDiscoverySupport;
import com.dataiku.dip.connections.ConnectionWithOAuth2DCRSupport;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.security.model.OAuth2ConfigDiscovery;
import com.dataiku.dip.security.model.OAuth2DCRHelper;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.util.SecretString;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.client.transport.HttpClientStreamableHttpTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;

public class RemoteMCPConnection
extends DSSConnection
implements ConnectionWithEncryptedFields,
ConnectionWithBasicCredential,
ConnectionWithPerUserOAuth2Credentials,
ConnectionWithOAuth2DCRSupport,
ConnectionWithOAuth2ConfigDiscoverySupport {
    public RemoteMCPConnectionParams params = new RemoteMCPConnectionParams();
    public static final String connectionType = "RemoteMCP";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.remotemcp");

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableRemoteMCPCredentials.class));
        SerializableRemoteMCPCredentials creds = new SerializableRemoteMCPCredentials();
        creds.authType = this.params.authType;
        switch (creds.authType) {
            case BASIC_AUTH: {
                ICredentialsService.BasicCredential basicCreds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
                creds.user = basicCreds.user;
                creds.password = SecretString.buildOrNull((String)basicCreds.password);
                break;
            }
            case BEARER: {
                if (this.credentialsMode == DSSConnection.CredentialsMode.GLOBAL) {
                    creds.bearerToken = this.params.bearerToken;
                    break;
                }
                ICredentialsService.Credential decryptedCreds = ConnectionCredentialUtils.getDecryptedCredential_autoTXN(this, ctx.authCtx);
                if (!(decryptedCreds instanceof ICredentialsService.SingleFieldCredential)) break;
                ICredentialsService.SingleFieldCredential dCreds = (ICredentialsService.SingleFieldCredential)decryptedCreds;
                creds.bearerToken = SecretString.buildOrNull((String)dCreds.value);
                break;
            }
            case OAUTH2: {
                creds.oauth2clientId = this.params.clientId;
                creds.oauth2clientSecret = this.params.clientSecret;
                creds.oauth2Scope = this.params.scope;
                creds.oauth2AppName = this.params.oauthAppName;
                creds.oauth2AuthMethod = this.params.oauthAuthMethod;
                creds.oauth2AuthorizationEndpoint = this.params.oauthServerMetadata.authorizationEndpoint;
                creds.oauth2TokenEndpoint = this.params.oauthServerMetadata.tokenEndpoint;
                creds.oauth2RegistrationEndpoint = this.params.oauthServerMetadata.registrationEndpoint;
                OAuth2Client.AccessTokenResult tokens = this.getAccessToken(ctx.authCtx, this.getProxySettings());
                if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                    creds.oauth2RefreshToken = SecretString.buildOrNull((String)tokens.getRefreshToken());
                }
                creds.oauth2AccessToken = SecretString.buildOrNull((String)tokens.getAccessToken());
            }
        }
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    private Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.getDkuProperties());
    }

    @Override
    public boolean isADataStoringConnection() {
        return false;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.bearerToken = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.bearerToken);
        this.params.clientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.clientSecret);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.bearerToken = cryptoService.decryptIfEncrypted(this.params.bearerToken);
        this.params.clientSecret = cryptoService.decryptIfEncrypted(this.params.clientSecret);
    }

    @Override
    public String getOAuth2ClientId() {
        return this.params.clientId;
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.authType == AuthType.BASIC_AUTH;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, SecretString.getSecretOrNull((SecretString)this.params.password));
    }

    public boolean actuallyHasPerUserBearerCredential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.BEARER;
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.OAUTH2;
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return this.params.refreshTokenRotation;
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = variablesService.getForConnectionAndUser(this, authCtx);
        String scope = vc.expand(this.params.scope);
        if (StringUtils.isBlank((String)scope)) {
            scope = null;
        }
        String clientId = vc.expand(this.params.clientId);
        String clientSecret = vc.expand(SecretString.getSecretOrNull((SecretString)this.params.clientSecret));
        String authorizationEndpoint = vc.expand(this.params.oauthServerMetadata.authorizationEndpoint);
        String tokenEndpoint = vc.expand(this.params.oauthServerMetadata.tokenEndpoint);
        ClientAuthenticationMethod clientAuthMethod = this.params.oauthAuthMethod.toNimbusType();
        logger.info((Object)("Using OAuth2 authorize endpoint: " + authorizationEndpoint));
        logger.info((Object)("Using OAuth2 token endpoint: " + tokenEndpoint));
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        return new OAuth2Client.Builder().authorizationEndpoint(authorizationEndpoint).tokenEndpoint(tokenEndpoint).clientId(clientId).clientSecret(clientSecret).clientAuthMethod(clientAuthMethod).scope(scope).usePkce(true).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getProxySettings()).getAccessToken());
    }

    private OAuth2Client.AccessTokenResult getAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        logger.info((Object)"Exchanging user's refresh token for an access token");
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
            }
            return oAuth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    public String getAuthToken(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.isFreelyUsableBy(authCtx)) {
            throw new UnauthorizedException("Access to connection " + this.name + " is not authorized.", "connection-access-denied");
        }
        try {
            SerializableRemoteMCPCredentials creds = this.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), SerializableRemoteMCPCredentials.class);
            switch (creds.authType) {
                case BASIC_AUTH: {
                    String password = SecretString.getSecretOrNull((SecretString)creds.password);
                    if (password == null) {
                        password = "";
                    }
                    return creds.user + ":" + password;
                }
                case OAUTH2: {
                    return SecretString.getSecretOrNull((SecretString)creds.oauth2AccessToken);
                }
                case BEARER: {
                    String token = SecretString.getSecretOrNull((SecretString)creds.bearerToken);
                    if (token == null) {
                        token = "";
                    }
                    return token;
                }
            }
            throw new Error("Unreachable");
        }
        catch (DKUSecurityException | IOException | SQLException e) {
            throw new UnauthorizedException("Unable to get credentials", "connection-access-denied", e);
        }
    }

    @Override
    public void discoverOAuthConfig(AuthCtx authCtx) throws URISyntaxException {
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = variablesService.getForConnectionAndUser(this, authCtx);
        String serverURL = vc.expand(this.params.serverURL);
        this.params.oauthServerMetadata = OAuth2ConfigDiscovery.discoverConfig(serverURL);
        if (this.params.oauthServerMetadata.tokenEndpointAuthMethodsSupported != null) {
            if (this.params.oauthServerMetadata.tokenEndpointAuthMethodsSupported.contains("client_secret_basic")) {
                this.params.oauthAuthMethod = OAuth2DCRHelper.AuthMethod.CLIENT_SECRET_BASIC;
            } else if (this.params.oauthServerMetadata.tokenEndpointAuthMethodsSupported.contains("client_secret_post")) {
                this.params.oauthAuthMethod = OAuth2DCRHelper.AuthMethod.CLIENT_SECRET_POST;
            } else if (this.params.oauthServerMetadata.tokenEndpointAuthMethodsSupported.contains("none")) {
                this.params.oauthAuthMethod = OAuth2DCRHelper.AuthMethod.NONE;
            }
        }
        this.params.scope = this.params.oauthServerMetadata.scopesSupported != null && !this.params.oauthServerMetadata.scopesSupported.isEmpty() ? StringUtils.join(this.params.oauthServerMetadata.scopesSupported, (String)" ") : null;
    }

    @Override
    public OAuth2DCRHelper.OAuth2DCRInfo registerOAuth2Client(AuthCtx authCtx, String redirectURL) throws DKUSecurityException {
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = variablesService.getForConnectionAndUser(this, authCtx);
        String registrationEndpoint = vc.expand(this.params.oauthServerMetadata.registrationEndpoint);
        logger.info((Object)("Using OAuth2 registration endpoint: " + registrationEndpoint));
        String appName = vc.expand(this.params.oauthAppName);
        String logoURL = vc.expand(this.params.oauthLogoURL);
        HashSet<OAuth2DCRHelper.DCRGrantType> grantTypes = new HashSet<OAuth2DCRHelper.DCRGrantType>();
        grantTypes.add(OAuth2DCRHelper.DCRGrantType.REFRESH_TOKEN);
        if (this.credentialsMode == DSSConnection.CredentialsMode.GLOBAL) {
            grantTypes.add(OAuth2DCRHelper.DCRGrantType.CLIENT_CREDENTIALS);
        } else {
            grantTypes.add(OAuth2DCRHelper.DCRGrantType.AUTHORIZATION_CODE);
        }
        return OAuth2DCRHelper.registerDynamicClient(registrationEndpoint, appName, logoURL, this.params.oauthAuthMethod, grantTypes, redirectURL, this.getProxySettings());
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testRemoteMCP(authCtx, this);
    }

    public RemoteMCPClient getMCPClient(AuthCtx authCtx) throws Exception {
        if (!this.isFreelyUsableBy(authCtx)) {
            throw new UnauthorizedException("Access to connection " + this.name + " is not authorized.", "connection-access-denied");
        }
        return new RemoteMCPClient(authCtx, this);
    }

    public static class RemoteMCPConnectionParams
    extends DSSConnection.DkuConnectionParams {
        public String serverURL;
        public boolean useSSETransport;
        public int initTimeout = 60;
        public int requestTimeout = 3600;
        public AuthType authType = AuthType.NONE;
        public String user;
        public SecretString password;
        public SecretString bearerToken;
        public OAuth2ConfigDiscovery.DSSOAuthServerMetadata oauthServerMetadata = new OAuth2ConfigDiscovery.DSSOAuthServerMetadata();
        public String clientId;
        public SecretString clientSecret;
        public String oauthAppName;
        public String oauthLogoURL;
        public OAuth2DCRHelper.AuthMethod oauthAuthMethod;
        public String scope;
        public boolean refreshTokenRotation;
        public List<AbstractSQLConnection.CustomDatabaseProperty> headers = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }

    public static class SerializableRemoteMCPCredentials
    implements ICredentialsService.BasicCredentialConvertible {
        public AuthType authType;
        public String user;
        public SecretString password;
        public SecretString bearerToken;
        public String oauth2clientId;
        public SecretString oauth2clientSecret;
        public String oauth2AuthorizationEndpoint;
        public String oauth2TokenEndpoint;
        public String oauth2RegistrationEndpoint;
        public String oauth2Scope;
        public SecretString oauth2RefreshToken;
        public SecretString oauth2AccessToken;
        public String oauth2AppName;
        public OAuth2DCRHelper.AuthMethod oauth2AuthMethod;

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential(this.user, SecretString.getSecretOrNull((SecretString)this.password));
        }

        public String toBearerToken() {
            return SecretString.getSecretOrNull((SecretString)this.bearerToken);
        }

        public ICredentialsService.OAuth2Credential toOAuth2Credential() {
            return new ICredentialsService.OAuth2Credential(SecretString.getSecretOrNull((SecretString)this.oauth2AccessToken));
        }
    }

    public static enum AuthType {
        NONE,
        BASIC_AUTH,
        BEARER,
        OAUTH2;

    }

    public static class RemoteMCPClient
    implements AutoCloseable {
        private final McpSyncClient mcpClient;

        public RemoteMCPClient(AuthCtx authCtx, RemoteMCPConnection connection) throws Exception {
            Object endpoint;
            String host;
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
            if (connection.params.authType == AuthType.BASIC_AUTH) {
                String userPassword = connection.getAuthToken(authCtx);
                if (StringUtils.isBlank((String)userPassword)) {
                    throw new IllegalArgumentException("A username and password are required for basic authentication");
                }
                requestBuilder = requestBuilder.header("Authorization", "Basic " + String.valueOf(Base64.encode((String)userPassword)));
            } else if (connection.params.authType == AuthType.BEARER) {
                token = connection.getAuthToken(authCtx);
                if (StringUtils.isBlank((String)token)) {
                    throw new IllegalArgumentException("A token value is required for bearer token authentication");
                }
                requestBuilder = requestBuilder.header("Authorization", "Bearer " + (String)token);
            } else if (connection.params.authType == AuthType.OAUTH2) {
                token = connection.getAuthToken(authCtx);
                if (StringUtils.isBlank((String)token)) {
                    throw new IllegalArgumentException("A token value is required for OAuth 2 authentication");
                }
                requestBuilder = requestBuilder.header("Authorization", "Bearer " + (String)token);
            }
            for (AbstractSQLConnection.CustomDatabaseProperty header : connection.params.headers) {
                if (StringUtils.equals((String)header.name, (String)"Authorization") && connection.params.authType != AuthType.NONE) continue;
                requestBuilder.header(header.name, header.value);
            }
            VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
            VariablesContext vc = variablesService.getForConnectionAndUser(connection, authCtx);
            String serverURL = vc.expand(connection.params.serverURL);
            if (StringUtils.isBlank((String)serverURL)) {
                throw new IllegalArgumentException("MCP server URL can't be empty");
            }
            try {
                URI serverURI = new URI(serverURL);
                host = new URI(serverURI.getScheme(), null, serverURI.getHost(), serverURI.getPort(), null, null, null).toString();
                endpoint = serverURI.getPath();
                if (StringUtils.isBlank((String)endpoint)) {
                    endpoint = "/";
                }
                if (!StringUtils.isBlank((String)serverURI.getQuery())) {
                    endpoint = (String)endpoint + "?" + serverURI.getQuery();
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid MCP server URL: " + serverURL, e);
            }
            Object transport = !connection.params.useSSETransport ? HttpClientStreamableHttpTransport.builder((String)host).endpoint((String)endpoint).requestBuilder(requestBuilder).build() : HttpClientSseClientTransport.builder((String)host).sseEndpoint((String)endpoint).requestBuilder(requestBuilder).build();
            Duration initTimeout = connection.params.initTimeout == 0 ? Duration.ofDays(7L) : Duration.ofSeconds(connection.params.initTimeout);
            Duration requestTimeout = connection.params.requestTimeout == 0 ? Duration.ofDays(7L) : Duration.ofSeconds(connection.params.requestTimeout);
            this.mcpClient = McpClient.sync((McpClientTransport)transport).initializationTimeout(initTimeout).requestTimeout(requestTimeout).build();
            logger.debug((Object)("Initializing MCP client for server " + host + (String)endpoint));
            try {
                this.mcpClient.initialize();
            }
            catch (Exception e) {
                Throwable closedChannelException;
                Throwable throwable = e.getCause();
                if (throwable instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)throwable;
                    throw new Exception("Client initialization timed out, consider raising 'Server initialization timeout' in the remote MCP connection settings", timeoutException);
                }
                throwable = e.getCause();
                if (throwable instanceof ConnectException) {
                    ConnectException connectException = (ConnectException)throwable;
                    Throwable throwable2 = connectException.getCause();
                    if (throwable2 instanceof UnresolvedAddressException) {
                        UnresolvedAddressException unresolvedAddressException = (UnresolvedAddressException)throwable2;
                        throw new IllegalArgumentException("Failed to resolve server URL '" + connection.params.serverURL + "', check 'Server URL' in the remote MCP connection settings", unresolvedAddressException);
                    }
                    throwable2 = connectException.getCause();
                    if (throwable2 instanceof ClosedChannelException) {
                        closedChannelException = (ClosedChannelException)throwable2;
                        throw new IllegalArgumentException("Failed to connect to '" + connection.params.serverURL + "', check 'Server URL' in the remote MCP connection settings", closedChannelException);
                    }
                }
                if ((closedChannelException = e.getCause()) instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)closedChannelException;
                    String errorMessage = runtimeException.getMessage();
                    if (errorMessage.startsWith("Failed to send message: DummyEvent")) {
                        throw new IllegalArgumentException("Failed to send MCP message to '" + connection.params.serverURL + "', make sure it is an MCP server" + (!connection.params.useSSETransport ? ", also check if it requires the legacy SSE transport" : ""), runtimeException);
                    }
                    if (errorMessage.startsWith("Failed to send message: AggregateResponseEvent")) {
                        int dataIndex = errorMessage.indexOf("data=");
                        int startIndex = errorMessage.indexOf("{", dataIndex);
                        int endIndex = errorMessage.lastIndexOf("}");
                        if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                            String jsonPayload = errorMessage.substring(startIndex, endIndex + 1);
                            throw new IllegalArgumentException("Failed to send MCP message, this can be caused by invalid credentials, error was: " + jsonPayload, runtimeException);
                        }
                    }
                }
                throw e;
            }
        }

        public void test() throws Exception {
            McpSchema.InitializeResult status = this.mcpClient.getCurrentInitializationResult();
            if (StringUtils.isBlank((String)status.serverInfo().name())) {
                throw new IllegalArgumentException("Server name not found");
            }
            logger.debug((Object)("Successfully reached remote MCP server " + status.serverInfo().name() + " (version " + status.serverInfo().version() + ") using protocol version " + status.protocolVersion()));
        }

        public McpSchema.ListToolsResult listTools() {
            return this.mcpClient.listTools();
        }

        public McpSchema.CallToolResult callTool(AgentToolRunner.AgentToolInput input) throws Exception {
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map json = (Map)new Gson().fromJson(input.input, mapType);
            McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest(input.subtoolName, json);
            try {
                return this.mcpClient.callTool(callToolRequest);
            }
            catch (Exception e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)throwable;
                    throw new Exception("Tool call timed out, consider raising 'Tool call timeout' in the remote MCP connection settings", timeoutException);
                }
                throw e;
            }
        }

        @Override
        public void close() throws Exception {
            this.mcpClient.close();
        }
    }
}

