/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.ContainerExecDockerFilePreparer;
import com.dataiku.dip.containers.exec.ContainerExecImagesDeleterService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.ECRUtils;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ContainerExecImagesBuilder
extends ContainerExecDockerFilePreparer {
    protected final String requestedBaseImageTag;
    protected final ContainerExecUtils.BaseImageType baseImageType;
    protected final String effectiveBaseImageTag;
    protected final ContainerExecUtils.ContainerBuildConfig containerConfig;
    protected final String imageNameToBuild;
    protected final Collection<ContainerExecUtils.ContainerImagePush> pushes;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.containers.imagebuilder");

    public static List<ContainerExecImagesBuilder> getBuilders(CodeEnvModel.AbstractEnvDesc envDesc, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings, CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData, String envName, String envVersion, InfoMessage.InfoMessages messages) throws IOException {
        List<ContainerExecUtils.ContainerBaseConfig> configurations = ContainerExecImagesBuilder.computeContainerBaseConfigs(envDesc, envName, messages);
        Map<ContainerExecUtils.ContainerBuildConfig, Collection<ContainerExecUtils.ContainerImagePush>> configMap = ContainerExecUtils.deduplicateContainerBuilds(configurations);
        ArrayList<ContainerExecImagesBuilder> builders = new ArrayList<ContainerExecImagesBuilder>(configMap.size());
        for (Map.Entry<ContainerExecUtils.ContainerBuildConfig, Collection<ContainerExecUtils.ContainerImagePush>> configEntry : configMap.entrySet()) {
            ArrayList<ContainerExecUtils.ContainerImagePush> toPush = new ArrayList<ContainerExecUtils.ContainerImagePush>();
            for (ContainerExecUtils.ContainerImagePush push : configEntry.getValue()) {
                if (!StringUtils.isNotBlank((String)push.repositoryURL)) continue;
                toPush.add(push);
            }
            builders.add(new ContainerExecImagesBuilder(envDesc, envSettings, specData, envName, envVersion, "code-env", configEntry.getKey(), toPush));
        }
        return builders;
    }

    public static List<ContainerExecUtils.ContainerBaseConfig> computeContainerBaseConfigs(CodeEnvModel.AbstractEnvDesc envDesc, String envName, InfoMessage.InfoMessages messages) throws IOException {
        ContainerSettings containerSettings = new ClusterSelector().selectGlobal().getContainerSettings();
        ArrayList<ContainerExecUtils.ContainerBaseConfig> configurations = new ArrayList<ContainerExecUtils.ContainerBaseConfig>();
        if (envDesc.allContainerConfs) {
            configurations.addAll(containerSettings.listConfigsForWorkloadType(WorkloadType.USER_CODE));
        } else {
            for (String confName : envDesc.containerConfs) {
                ContainerExecRuntimeConfig configuration = containerSettings.getByNameOrNull(confName);
                if (configuration == null) {
                    messages.withWarningV((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONTAINER_CONFIG_NOT_FOUND, "Code env %s references container configuration %s which does not exist", new Object[]{envName, confName});
                    continue;
                }
                configurations.add(configuration);
            }
        }
        SparkSettings sparkSettings = new ClusterSelector().selectGlobal().getSparkSettings();
        if (envDesc.allSparkKubernetesConfs) {
            for (SparkExecutionConfig conf : sparkSettings.executionConfigs) {
                if (!conf.kubernetesSettings.managedKubernetes || conf.hasConfKey("spark.kubernetes.container.image", "spark.kubernetes.executor.container.image", "spark.kubernetes.driver.container.image")) continue;
                configurations.add(conf.kubernetesSettings);
            }
        } else {
            for (String confName : envDesc.sparkKubernetesConfs) {
                SparkExecutionConfig configuration = sparkSettings.getByNameOrNull(confName);
                if (configuration == null) {
                    messages.withWarningV((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONTAINER_CONFIG_NOT_FOUND, "Code env %s references spark kubernetes configuration %s which does not exist", new Object[]{envName, confName});
                    continue;
                }
                if (!configuration.kubernetesSettings.managedKubernetes) {
                    messages.withWarningV((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONTAINER_CONFIG_NOT_FOUND, "Code env %s references spark kubernetes configuration %s which does is not a managed kubernetes", new Object[]{envName, confName});
                    continue;
                }
                if (configuration.hasConfKey("spark.kubernetes.container.image", "spark.kubernetes.executor.container.image", "spark.kubernetes.driver.container.image")) {
                    messages.withWarningV((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONTAINER_CONFIG_NOT_FOUND, "Code env %s references spark kubernetes configuration %s which fixes the image", new Object[]{envName, confName});
                    continue;
                }
                configurations.add(configuration.kubernetesSettings);
            }
        }
        return configurations;
    }

    public static List<String> getContainerConfs(CodeEnvModel.AbstractEnvDesc envDesc, String envName) throws IOException {
        ContainerSettings containerSettings = new ClusterSelector().selectGlobal().getContainerSettings();
        HashSet<String> configurations = new HashSet<String>();
        if (envDesc.allContainerConfs) {
            for (ContainerExecRuntimeConfig executionConfig : containerSettings.listConfigsForWorkloadType(WorkloadType.USER_CODE)) {
                configurations.add(executionConfig.name);
            }
        } else {
            for (String confName : envDesc.containerConfs) {
                ContainerExecRuntimeConfig configuration = containerSettings.getByNameOrNull(confName);
                if (configuration == null) {
                    logger.warnV("Code env %s references container configuration %s which does not exist", new Object[]{envName, confName});
                    continue;
                }
                configurations.add(confName);
            }
        }
        return Lists.newArrayList(configurations);
    }

    public ContainerExecImagesBuilder(CodeEnvModel.AbstractEnvDesc envDesc, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings, CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData, String envName, String envVersion, String envDir, ContainerExecUtils.ContainerBuildConfig containerConfig, Collection<ContainerExecUtils.ContainerImagePush> pushes) throws IOException {
        super(envDesc, envSettings, specData, envName, envVersion, envDir);
        this.requestedBaseImageTag = containerConfig.baseImage;
        this.baseImageType = containerConfig.baseImageType;
        this.effectiveBaseImageTag = ContainerExecImagesHelper.getBaseImageTag(containerConfig.baseImage, containerConfig.baseImageType);
        this.containerConfig = containerConfig;
        this.pushes = pushes;
        this.imageNameToBuild = ContainerExecImagesHelper.getImageTag((boolean)true, null, (String)this.requestedBaseImageTag, (ContainerExecUtils.BaseImageType)this.baseImageType, (CodeEnvModel.EnvLang)this.envLang, (String)envName, (String)envVersion).baseImage;
        logger.infoV("Init Docker image builder envLang=%s envName=%s envVersion=%s requestedBaseImageTag=%s", new Object[]{this.envLang, envName, envVersion, this.requestedBaseImageTag});
    }

    public void prepareForPythonEnv(File buildDir) throws IOException {
        String build = this.preparePythonDockerFileFragment(buildDir);
        this.prepareCodeEnvDockerFile(buildDir, build);
    }

    public void prepareForREnv(File buildDir) throws IOException {
        String build = this.prepareRDockerFileFragment(buildDir);
        this.prepareCodeEnvDockerFile(buildDir, build);
    }

    private void prepareCodeEnvDockerFile(File buildDir, String codeEnvBuildDockerfileFragment) throws IOException {
        logger.infoV("Will build from base image: %s", new Object[]{this.effectiveBaseImageTag});
        String dockerfile = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "env-image", "CodeEnv.Dockerfile"}));
        dockerfile = dockerfile.replace("__DKU_BASE_IMAGE_ID__", this.effectiveBaseImageTag).replace("# __DKU_CODE_ENV_BUILD__", codeEnvBuildDockerfileFragment).replace("__DKU_UID__", DKUApp.getContainerUIDGID());
        DKUFileUtils.writeFileUTF8((File)new File(buildDir, "Dockerfile"), (String)dockerfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String build(File buildDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log, File dockerfileDump) throws IOException, InterruptedException {
        ProcessBuilder pb;
        ContainerExecImagesHelper.ImageTagRef imageTagToBuild;
        block17: {
            logTailBuilder.appendLine("Building docker image");
            imageTagToBuild = ContainerExecImagesHelper.getImageTag(true, null, this.requestedBaseImageTag, this.baseImageType, this.envLang, this.envName, this.envVersion);
            logger.infoV("Will build image " + String.valueOf(imageTagToBuild), new Object[0]);
            pb = new ProcessBuilder("docker", "build", "-t", imageTagToBuild.getFullTag(), "--force-rm", buildDir.getAbsolutePath());
            for (ContainerExecUtils.ContainerImagePush push : this.pushes) {
                pb.command().add("-t");
                pb.command().add(push.repositoryURL + "/" + String.valueOf(imageTagToBuild));
            }
            if (dockerfileDump != null) {
                try {
                    FileUtils.copyFile((File)new File(buildDir, "Dockerfile"), (File)dockerfileDump);
                }
                catch (IOException e) {
                    logTailBuilder.appendLine("ERROR Could not dump Dockerfile: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            ContainerExecImagesBuilder.execDockerCommand(this.containerConfig, pb, buildDir, logTailBuilder, log);
            try {
                String oldImageTag = ContainerExecImagesHelper.getImageTagToUse(this.containerConfig.dockerHost, this.requestedBaseImageTag, this.baseImageType, this.envLang, this.envName, this.envVersion);
                Set<String> repositoryUrls = this.pushes.stream().map(p -> p.repositoryURL).collect(Collectors.toSet());
                ContainerExecImagesBuilder.deleteOldImages(this.containerConfig, oldImageTag, repositoryUrls, buildDir, logTailBuilder, log);
            }
            catch (Exception e) {
                if (e instanceof CodedIOException && ((CodedIOException)e).getCode() == CodeEnvCodes.ERR_CODEENV_CONTAINER_IMAGE_TAG_NOT_FOUND) break block17;
                logger.info((Object)"Could not delete old Docker images", (Throwable)e);
            }
        }
        ContainerExecImagesHelper.setLastBuiltImageForEnv(this.envLang, this.envName, this.envVersion, this.containerConfig.dockerHost, imageTagToBuild.baseImage, imageTagToBuild.tag);
        try {
            for (ContainerExecUtils.ContainerImagePush push : this.pushes) {
                logTailBuilder.appendLine("Pushing docker image to " + push.repositoryURL + ", prePushMode=" + String.valueOf((Object)push.prePushMode));
                switch (push.prePushMode) {
                    case NONE: {
                        break;
                    }
                    case ECR: {
                        String region = ECRUtils.getRegionFromRepositoryURL(push.repositoryURL);
                        logTailBuilder.appendLine("EKS Pre-push script. Detected region: " + region);
                        pb = new ProcessBuilder(new String[0]);
                        pb.command().add(DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "aws-ecr-prepush.sh"}).getAbsolutePath());
                        pb.command().add(push.repositoryURL);
                        pb.command().add(region);
                        pb.command().add(imageTagToBuild.baseImage);
                        pb.command().add(imageTagToBuild.tag);
                        ContainerExecImagesBuilder.execDockerCommand(this.containerConfig, pb, buildDir, logTailBuilder, log);
                        break;
                    }
                    case ACR: {
                        logTailBuilder.appendLine("ACR Pre-push script");
                        pb = new ProcessBuilder(new String[0]);
                        pb.command().add(0, DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "azure-acr-prepush.sh"}).getAbsolutePath());
                        pb.command().add(1, push.repositoryURL);
                        pb.command().add(imageTagToBuild.baseImage);
                        pb.command().add(imageTagToBuild.tag);
                        ContainerExecImagesBuilder.execDockerCommand(this.containerConfig, pb, buildDir, logTailBuilder, log);
                        break;
                    }
                    case GCR: {
                        logTailBuilder.appendLine("GAR Pre-push script");
                        pb = new ProcessBuilder(new String[0]);
                        pb.command().add(0, DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "gcloud-gcr-prepush.sh"}).getAbsolutePath());
                        pb.command().add(1, push.repositoryURL);
                        ContainerExecImagesBuilder.execDockerCommand(this.containerConfig, pb, buildDir, logTailBuilder, log);
                        break;
                    }
                    case CUSTOM: {
                        if (!StringUtils.isNotBlank((String)push.prePushScript)) break;
                        logTailBuilder.appendLine("Custom Pre-push script, mode=" + String.valueOf((Object)push.prePushMode));
                        pb = new ProcessBuilder(new String[0]);
                        pb.command().add(0, push.prePushScript);
                        pb.command().add(1, push.repositoryURL);
                        pb.command().add(imageTagToBuild.baseImage);
                        pb.command().add(imageTagToBuild.tag);
                        ContainerExecImagesBuilder.execDockerCommand(this.containerConfig, pb, buildDir, logTailBuilder, log);
                    }
                }
                pb = new ProcessBuilder("docker", "push", push.repositoryURL + "/" + String.valueOf(imageTagToBuild));
                ContainerExecImagesBuilder.execDockerCommand(this.containerConfig, pb, buildDir, logTailBuilder, log);
            }
        }
        finally {
            ContainerExecImagesHelper.setLastBuiltImageForEnv(this.envLang, this.envName, this.envVersion, this.containerConfig.dockerHost, imageTagToBuild.baseImage, imageTagToBuild.tag);
        }
        return imageTagToBuild.getFullTag();
    }

    public static void deleteOldImages(ContainerExecUtils.ContainerBuildConfig containerConfig, String oldImageTag, Set<String> repositoryUrls, File buildDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log) {
        if (StringUtils.isBlank((String)oldImageTag)) {
            return;
        }
        Set<String> repositoriesWithImageToDelete = ContainerExecImagesBuilder.getImagesToDelete(oldImageTag, repositoryUrls);
        ContainerExecImagesDeleterService deleter = (ContainerExecImagesDeleterService)SpringUtils.getBean(ContainerExecImagesDeleterService.class);
        try {
            deleter.addImagesToDelete(repositoriesWithImageToDelete, containerConfig);
        }
        catch (IOException e) {
            logger.error((Object)"Fail to register old images for deletion", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Set<String> getImagesToDelete(String oldImageTag, Set<String> repositoryUrls) {
        HashSet<String> repositoriesWithImageToDelete = new HashSet<String>();
        repositoriesWithImageToDelete.add(oldImageTag);
        for (String string : repositoryUrls) {
            void var4_4;
            if (StringUtils.isBlank((String)string)) continue;
            if (!string.endsWith("/")) {
                String string2 = string + "/";
            }
            repositoriesWithImageToDelete.add((String)var4_4 + oldImageTag);
        }
        return repositoriesWithImageToDelete;
    }

    public static void execDockerCommand(@Nullable ContainerExecUtils.ContainerBuildConfig containerConfig, ProcessBuilder pb, File buildDir, DKUtils.SmartLogTailBuilder logTailBuilder, @Nullable File log) throws IOException, InterruptedException {
        logTailBuilder.appendLine("$ " + StringUtils.join(pb.command(), (char)' '));
        pb.directory(buildDir);
        if (containerConfig != null && !ContainerExecUtils.ContainerBuildConfig.isImageBuiltLocally(containerConfig)) {
            ContainerExecUtils.enrichDockerEnv(containerConfig, pb.environment());
        }
        if (log != null) {
            DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log);
        } else {
            DKUtils.execAndLogThrows((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder);
        }
    }

    @Override
    protected boolean shouldDisablePipCache() {
        return true;
    }
}

