/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec.kubernetes;

import com.dataiku.dip.utils.ImmutableValueObject;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class KubernetesMetricQuantityBase
extends ImmutableValueObject {
    private static final Map<String, BigDecimal> MAGNITUDE_COEFFICIENT = ImmutableMap.builder().put((Object)"", (Object)BigDecimal.ONE).put((Object)"n", (Object)BigDecimal.ONE.divide(BigDecimal.TEN.pow(9))).put((Object)"u", (Object)BigDecimal.ONE.divide(BigDecimal.TEN.pow(6))).put((Object)"m", (Object)BigDecimal.ONE.divide(BigDecimal.TEN.pow(3))).put((Object)"k", (Object)BigDecimal.TEN.pow(3)).put((Object)"M", (Object)BigDecimal.TEN.pow(6)).put((Object)"G", (Object)BigDecimal.TEN.pow(9)).put((Object)"T", (Object)BigDecimal.TEN.pow(12)).put((Object)"P", (Object)BigDecimal.TEN.pow(15)).put((Object)"E", (Object)BigDecimal.TEN.pow(18)).put((Object)"Ki", (Object)BigDecimal.valueOf(2L).pow(10)).put((Object)"Mi", (Object)BigDecimal.valueOf(2L).pow(20)).put((Object)"Gi", (Object)BigDecimal.valueOf(2L).pow(30)).put((Object)"Ti", (Object)BigDecimal.valueOf(2L).pow(40)).put((Object)"Pi", (Object)BigDecimal.valueOf(2L).pow(50)).put((Object)"Ei", (Object)BigDecimal.valueOf(2L).pow(60)).build();
    private static final Pattern VALID_VALUE_PATTERN = Pattern.compile("^([0-9]*(?:\\.[0-9]+)?(?:e(?:-?[1-9]+[0-9]*))?)(|n|u|m|k|M|G|T|P|E|Ki|Mi|Gi|Ti|Pi|Ei)$");
    protected final BigDecimal number;

    public float getAsFloat() {
        return this.getAsFloat(2, RoundingMode.HALF_UP);
    }

    public float getAsFloat(int decimalPlacesCount, RoundingMode roundingMode) {
        return this.number.setScale(decimalPlacesCount, roundingMode).floatValue();
    }

    public KubernetesMetricQuantityBase(String value) {
        Matcher matcher = VALID_VALUE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad value format: " + value);
        }
        String quantityWithoutUnit = matcher.group(1).toUpperCase();
        String unit = matcher.group(2);
        BigDecimal parsedNumberWithoutUnit = new BigDecimal(quantityWithoutUnit);
        BigDecimal coef = MAGNITUDE_COEFFICIENT.get(unit);
        if (coef == null) {
            throw new RuntimeException("Unreachable code");
        }
        this.number = parsedNumberWithoutUnit.multiply(coef);
    }
}

