/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class JobDef {
    public JobType type;
    public String projectKey;
    public String id;
    public String name;
    public String initiator;
    public JobTriggerType triggeredFrom;
    public String recipe;
    public boolean isFindOutputMode = false;
    public long initiationTimestamp;
    public boolean mailNotification;
    public List<JobOutput> outputs = new ArrayList<JobOutput>();
    public List<ReverseJobStartingPoint> reverseStartingPoints = new ArrayList<ReverseJobStartingPoint>();
    public boolean refreshHiveMetastore = false;
    public boolean autoUpdateSchemaBeforeEachRecipeRun;
    public boolean stopAtFlowZoneBoundary;
    public List<String> stopAtComputableRefs;
    public transient ScenarioRun scenarioRun;
    public transient StepRun stepRun;

    public void assignIdFromNameAndTimestamp() {
        this.id = this.name.replaceAll("[^A-Za-z0-9_]", "_") + "_" + DKUtils.isoFormatPretty((long)this.initiationTimestamp).replace(':', '-');
    }

    public void expandInPlaceOutputsTargetPartition(VariablesContext vc) {
        for (JobOutput output : this.outputs) {
            output.expandInPlaceTargetPartition(vc);
        }
    }

    public String toHumanReadableString() {
        Object ret;
        if (this.type == JobType.REVERSE_FORCED_BUILD) {
            Object ret2 = this.reverseStartingPoints.size() > 0 ? "Build from " + this.reverseStartingPoints.get((int)0).id : "<Empty job: nothing to build>";
            return ret2;
        }
        ArrayList<JobOutput> outputsWithoutPartition = new ArrayList<JobOutput>();
        HashSet<CallSite> outputsFullNames = new HashSet<CallSite>();
        for (JobOutput output : this.outputs) {
            String outputName = output.targetDatasetProjectKey + "." + output.targetDataset;
            if (outputsFullNames.contains(outputName)) continue;
            outputsFullNames.add((CallSite)((Object)outputName));
            JobOutput outputWithoutPartition = new JobOutput(output.targetDatasetProjectKey, output.targetDataset, null);
            outputWithoutPartition.type = output.type;
            outputsWithoutPartition.add(outputWithoutPartition);
        }
        if (outputsWithoutPartition.size() > 0) {
            ret = "Build " + ((JobOutput)outputsWithoutPartition.get((int)0)).targetDataset;
            if (outputsWithoutPartition.size() > 1) {
                ret = (String)ret + " (+" + (outputsWithoutPartition.size() - 1) + " other)";
            }
        } else {
            ret = "<Empty job: nothing to build>";
        }
        return ret;
    }

    public static class JobOutput
    implements EnrichmentService.Enrichable {
        public FlowComputable.FCType type;
        public String targetDatasetProjectKey;
        public String targetDataset;
        public String targetPartition;
        public JsonObject details;

        public JobOutput() {
        }

        public JobOutput(String projectKey, String ds, String p) {
            this.targetDatasetProjectKey = projectKey;
            this.targetDataset = ds;
            if (p != null && p.equals("")) {
                p = null;
            }
            this.targetPartition = p;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return this.type != null ? this.type.toTaggableType() : null;
        }

        @Override
        public String getProjectKey() {
            return this.targetDatasetProjectKey;
        }

        @Override
        public String getObjectId() {
            return this.targetDataset;
        }

        @Override
        public String getUserLogin() {
            return null;
        }

        @Override
        public String getWorkspaceKey() {
            return null;
        }

        @Override
        public JsonObject getDetails() {
            if (this.details == null) {
                this.details = new JsonObject();
            }
            return this.details;
        }

        public void expandInPlaceTargetPartition(VariablesContext vc) {
            this.targetPartition = this.targetPartition != null ? vc.expandAllowUnresolved(this.targetPartition) : "NP";
        }
    }

    public static enum JobType {
        RECURSIVE_BUILD,
        NON_RECURSIVE_FORCED_BUILD,
        RECURSIVE_FORCED_BUILD,
        RECURSIVE_MISSING_ONLY_BUILD,
        REVERSE_FORCED_BUILD,
        FIND_OUTPUTS_RECURSIVE_BUILD,
        FIND_OUTPUTS_RECURSIVE_FORCED_BUILD;

    }

    public static class ReverseJobStartingPoint {
        public GraphNodeSupertype graphNodeSupertype;
        public FlowComputable.FCType computableType;
        public String projectKey;
        public String id;
    }

    public static enum GraphNodeSupertype {
        RUNNABLE,
        COMPUTABLE;

    }

    public static enum JobTriggerType {
        API,
        RECIPE,
        SCHEDULER;

    }
}

