/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.ObjectCustomMetadata;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalineage.ManualDataLineage;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.SerializedDatasetAdapter;
import com.dataiku.dip.input.DatasetOrdering;
import com.dataiku.dip.labeling.ImageViewSettings;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.SelectableCodeEnvContainer;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.OverrideTable;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SerializedDataset
extends TaggableObjectsService.TaggableObject
implements Serializable,
SelectableCodeEnvContainer {
    private static final long serialVersionUID = -1L;
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String name;
    @JSON.FileTransient
    public String smartName;
    public String type;
    public boolean managed;
    public String formatType;
    private FormatParams formatParams;
    public String autodetectedFormatId;
    private Schema schema;
    public TypeSystemVersion typeSystemVersion = TypeSystemVersion.V2;
    public PartitioningScheme partitioning;
    public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    public ImageViewSettings imageViewSettings;
    public RemoteFiles remoteFiles;
    public FlowOptions flowOptions = new FlowOptions();
    public OverrideTable overrideTable;
    public ObjectCustomMetadata customMeta = new ObjectCustomMetadata();
    private JsonElement metricsRaw = null;
    private ProbesSet metrics = null;
    private JsonElement metricsChecksRaw = null;
    private DataQualityRuleSet metricsChecks = null;
    private transient JsonDeserializationContext deserializationContext;
    private DatasetHandler.DatasetParams params;
    public List<SerializedCheck> checks = new ArrayList<SerializedCheck>();
    public ReadWriteOptions readWriteOptions = new ReadWriteOptions();
    public boolean featureGroup;
    public String dataSteward;
    public ManualDataLineage manualDataLineage;

    public SerializedDataset() {
    }

    public SerializedDataset(String type) {
        this.type = type;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.DATASET;
    }

    @Override
    public String getSubtype() {
        return this.type;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.name = id;
    }

    public String getFullName() {
        Preconditions.checkNotNull((Object)this.projectKey, (Object)"Empty project key");
        Preconditions.checkNotNull((Object)this.name, (Object)"Empty name");
        return this.projectKey + "." + this.name;
    }

    public <T extends DatasetHandler.DatasetParams> T getParamsAs(Class<T> clazz) {
        return (T)((DatasetHandler.DatasetParams)clazz.cast(this.getParams()));
    }

    private void ensureMetrics() {
        if (this.metrics == null) {
            if (this.metricsRaw != null && this.deserializationContext != null) {
                this.metrics = (ProbesSet)this.deserializationContext.deserialize(this.metricsRaw, ProbesSet.class);
                this.metricsRaw = null;
            } else {
                this.metrics = new ProbesSet();
            }
        }
    }

    public ProbesSet getMetrics() {
        this.ensureMetrics();
        return this.metrics;
    }

    public void setMetrics(ProbesSet metrics) {
        this.metricsRaw = null;
        this.metrics = metrics;
    }

    public void setMetricsRaw(JsonElement elm, JsonDeserializationContext ctx) {
        this.metricsRaw = elm;
        this.deserializationContext = ctx;
    }

    private void ensureDataQualityRuleSet() {
        if (this.metricsChecks == null) {
            if (this.metricsChecksRaw != null && this.deserializationContext != null) {
                this.metricsChecks = (DataQualityRuleSet)this.deserializationContext.deserialize(this.metricsChecksRaw, DataQualityRuleSet.class);
                this.metricsChecks.ensureRulesIdsUsingCheckLegacyIds(false);
                this.metricsChecks.getRules().forEach(DataQualityRule::updateDisplayName);
                this.metricsChecksRaw = null;
            } else {
                this.metricsChecks = new DataQualityRuleSet();
            }
        }
    }

    @Nonnull
    public DataQualityRuleSet getDataQualityRuleSet() {
        this.ensureDataQualityRuleSet();
        return this.metricsChecks;
    }

    public void setDataQualityRuleSet(DataQualityRuleSet ruleSet) {
        this.metricsChecksRaw = null;
        this.metricsChecks = ruleSet;
    }

    public void setDataQualityRuleSetRaw(JsonElement elm, JsonDeserializationContext ctx) {
        this.metricsChecksRaw = elm;
        this.deserializationContext = ctx;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public DatasetHandler.DatasetParams getParams() {
        return this.params;
    }

    public void setParams(DatasetHandler.DatasetParams params) {
        this.params = params;
    }

    public FormatParams getFormatParams() {
        return this.formatParams;
    }

    public void setFormatParams(FormatParams formatParams) {
        this.formatParams = formatParams;
    }

    public boolean isPartitioned() {
        return this.partitioning != null && !this.partitioning.getDimensionNames().isEmpty();
    }

    public void setAllFieldsToNonRawMode() {
        this.getMetrics();
        this.getDataQualityRuleSet();
    }

    @Override
    public List<ParamsWithSelectableCodeEnv> collectCodeEnvUsers() {
        ArrayList codeEnvUsers = Lists.newArrayList();
        for (Probe probe : this.getMetrics().probes) {
            if (!(probe.getConfiguration() instanceof ParamsWithSelectableCodeEnv)) continue;
            codeEnvUsers.add((ParamsWithSelectableCodeEnv)((Object)probe.getConfiguration()));
        }
        for (DataQualityRule rule : this.getDataQualityRuleSet().getRules()) {
            if (!(rule instanceof ParamsWithSelectableCodeEnv)) continue;
            codeEnvUsers.add((ParamsWithSelectableCodeEnv)((Object)rule));
        }
        return codeEnvUsers;
    }

    public String getDataSteward() {
        return this.dataSteward;
    }

    public void setDataSteward(String dataSteward) {
        this.dataSteward = dataSteward;
    }

    @Nullable
    public ManualDataLineage getManualDataLineage() {
        return this.manualDataLineage == null ? null : this.manualDataLineage.withSmartNames(this.getProjectKey());
    }

    public void setManualDataLineage(@Nullable ManualDataLineage manualDataLineage) {
        this.manualDataLineage = manualDataLineage == null ? null : manualDataLineage.withSmartNames(this.getProjectKey());
    }

    public String toJSONAndFixupForDataQuality(boolean usePretty) {
        String result = usePretty ? JSON.pretty((Object)this) : JSON.json((Object)this);
        String newMetricChecksPretty = "  \"metricsChecks\": {\n    \"monitor\": false,\n    \"checks\": [],\n    \"displayedState\": {\n      \"checks\": []\n    }\n  }";
        String oldMetricChecksPretty = "  \"metricsChecks\": {\n    \"runOnBuild\": false,\n    \"checks\": [],\n    \"displayedState\": {\n      \"checks\": []\n    }\n  }";
        String newMetricChecks = "\"metricsChecks\":{\"monitor\":false,\"checks\":[],\"displayedState\":{\"checks\":[]}}";
        String oldMetricChecks = "\"metricsChecks\":{\"runOnBuild\":false,\"checks\":[],\"displayedState\":{\"checks\":[]}}";
        result = result.replace(newMetricChecksPretty, oldMetricChecksPretty);
        result = result.replace(newMetricChecks, oldMetricChecks);
        return result;
    }

    static {
        JSON.registerFactory((TypeAdapterFactory)SerializedDatasetAdapter.INSTANCE);
    }

    public static enum TypeSystemVersion {
        V1,
        V2;

    }

    public static class FlowOptions
    implements Serializable {
        private static final long serialVersionUID = -1L;
        public String flowEpoch;
        public String dateBlacklist;
        public boolean virtualizable;
        public RebuildBehavior rebuildBehavior = RebuildBehavior.NORMAL;
        public CrossProjectBuildBehaviour crossProjectBuildBehavior = CrossProjectBuildBehaviour.DEFAULT;
        public boolean ignoreErrorStatusOnBuild = false;
    }

    public static class ReadWriteOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean preserveOrder;
        public int writeBuckets = 1;
        public boolean forceSingleOutputFile;
        public String singleOutputFileBaseName;
        public DatasetOrdering defaultReadOrdering = new DatasetOrdering();
    }

    public static class RemoteFiles {
        public List<RemoteFilesSource> sources = new ArrayList<RemoteFilesSource>();
        public boolean alwaysCheckSync;
    }

    public static class RemoteFilesSource {
        public boolean useConnection;
        public boolean useGlobalProxy;
        public String url;
        public String connection;
        public String protocol;
        public String path;

        public void expandVariables(VariablesContext vc) {
            this.url = vc.expand(this.url);
            this.path = vc.expand(this.path);
        }
    }

    public static class SerializedCheck {
        public String type;
        public Map<String, String> params = new HashMap<String, String>();
    }

    public static enum CrossProjectBuildBehaviour {
        DEFAULT,
        STOP,
        TRAVERSE;

    }

    public static enum RebuildBehavior {
        NORMAL,
        EXPLICIT,
        WRITE_PROTECT;

    }
}

