/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.custom;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class PluginComponentDescValidator {
    protected String componentId;
    protected InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();

    public PluginComponentDescValidator(String componentId) {
        this.componentId = componentId;
    }

    public abstract InfoMessage.InfoMessages validate();

    protected void genericValidateMeta(DkuComponentMetadata meta) {
        if (meta == null) {
            this.withWarning("It is advised to fill metadata for display purposes");
        } else if (StringUtils.isBlank((String)meta.label)) {
            this.withWarning("No human-readable label");
        }
    }

    protected void genericValidateParams(List<? extends ParamDesc> params, String componentType) {
        this.genericValidateParams(params, componentType, false);
    }

    protected void genericValidateParams(List<? extends ParamDesc> params, String componentType, boolean arePluginParams) {
        ArrayList<String> usedNames = new ArrayList<String>(params.size());
        HashMap<String, ParamDesc> paramsByName = new HashMap<String, ParamDesc>();
        for (ParamDesc paramDesc : params) {
            if (paramDesc == null || !StringUtils.isNotBlank((String)paramDesc.name)) continue;
            paramsByName.put(paramDesc.name, paramDesc);
        }
        for (ParamDesc paramDesc : params) {
            if (paramDesc == null) {
                this.withFatal("Null param, make sure there is no trailing comma");
                continue;
            }
            if (StringUtils.isNotBlank((String)paramDesc.name) && usedNames.contains(paramDesc.name)) {
                this.withFatal("Duplicate param name: " + paramDesc.name);
                continue;
            }
            usedNames.add(paramDesc.name);
            this.validateParam(paramDesc, paramsByName, componentType, arePluginParams);
        }
    }

    protected void validateParam(ParamDesc p, Map<String, ParamDesc> paramsByName, String componentType, boolean isPluginParam) {
        if (StringUtils.isBlank((String)p.name) && p.type != ParamDesc.Type.SEPARATOR) {
            this.withFatal("Params must have names");
            return;
        }
        if (p.type == null) {
            this.withFatal("Param '" + p.name + "' has an invalid type field.");
            return;
        }
        if (!(p.type != ParamDesc.Type.DATASET_COLUMN && p.type != ParamDesc.Type.DATASET_COLUMNS || this.isJSONPath(p.datasetParamName))) {
            if (StringUtils.isBlank((String)p.datasetParamName)) {
                if (!Sets.newHashSet((Object[])new String[]{"check", "probe"}).contains(componentType)) {
                    this.withFatal("Param '" + p.name + "' of type COLUMN(S) requires a field datasetParamName.");
                }
            } else if (!paramsByName.containsKey(p.datasetParamName)) {
                this.withFatal("datasetParamName specified for '" + p.name + "', '" + p.datasetParamName + "', does not exist in the param list");
            } else if (paramsByName.get((Object)p.datasetParamName).type != ParamDesc.Type.DATASET) {
                this.withFatal("datasetParamName specified for '" + p.name + "', '" + p.datasetParamName + "', is not of type DATASET");
            }
        }
        if (p.type == ParamDesc.Type.API_SERVICE_VERSION && !this.isJSONPath(p.apiServiceParamName)) {
            if (StringUtils.isBlank((String)p.apiServiceParamName)) {
                this.withFatal("Param '" + p.name + "' of type API_SERVICE_VERSION requires a field apiServiceParamName.");
            } else if (!paramsByName.containsKey(p.apiServiceParamName)) {
                this.withFatal("apiServiceParamName specified for '" + p.name + "', '" + p.apiServiceParamName + "', does not exist in the param list");
            } else if (paramsByName.get((Object)p.apiServiceParamName).type != ParamDesc.Type.API_SERVICE) {
                this.withFatal("apiServiceParamName specified for '" + p.name + "', '" + p.apiServiceParamName + "', is not of type API_SERVICE");
            }
        }
        if (p.type == ParamDesc.Type.ML_TASK && !this.isJSONPath(p.visualAnalysisParamName)) {
            if (StringUtils.isBlank((String)p.visualAnalysisParamName)) {
                this.withFatal("Param '" + p.name + "' of type ML_TASK requires a field visualAnalysisParamName.");
            } else if (!paramsByName.containsKey(p.visualAnalysisParamName)) {
                this.withFatal("visualAnalysisParamName specified for '" + p.name + "', '" + p.visualAnalysisParamName + "', does not exist in the param list");
            } else if (paramsByName.get((Object)p.visualAnalysisParamName).type != ParamDesc.Type.VISUAL_ANALYSIS) {
                this.withFatal("visualAnalysisParamName specified for '" + p.name + "', '" + p.visualAnalysisParamName + "', is not of type VISUAL_ANALYSIS");
            }
        }
        if ((p.type == ParamDesc.Type.PRESET || p.type == ParamDesc.Type.PRESETS) && StringUtils.isBlank((String)p.parameterSetId)) {
            this.withFatal("Param '" + p.name + "' of type PRESET(S) requires a field parameterSetId.");
        }
        if (!(p.type != ParamDesc.Type.SELECT && p.type != ParamDesc.Type.MULTISELECT || p.getChoicesFromPython != null && p.getChoicesFromPython.booleanValue())) {
            if (p.selectChoices == null || p.selectChoices.isEmpty()) {
                this.withFatal("Param '" + p.name + "' of type " + String.valueOf((Object)p.type) + " has no selectChoices.");
            } else {
                for (ParamDesc.SelectChoice c2 : p.selectChoices) {
                    if (c2 == null) {
                        this.withFatal("Param '" + p.name + "' has an empty choice, make sure there is no trailing comma.");
                        continue;
                    }
                    if (!StringUtils.isBlank((String)c2.value) && !StringUtils.isBlank((String)c2.label)) continue;
                    this.withFatal("Select choice of param '" + p.name + "' are invalid. They should be of the form {\"value\": 1, \"label\": \"one\"}.");
                }
            }
        }
        if (p.type == ParamDesc.Type.OBJECT_LIST && (p.subParams == null || p.subParams.isEmpty())) {
            this.withFatal("Param '" + p.name + "' of type OBJECT_LIST requires a non-empty field subParams.");
        }
        if (StringUtils.isBlank((String)p.label)) {
            this.withWarning("Param '" + p.name + "' has no label.");
        }
        if (p.type == ParamDesc.Type.DOUBLE && p.minD != null && p.maxD != null && p.minD > p.maxD) {
            this.withWarning("minD > maxD for parameter '" + p.name + "'.");
        }
        if (p.type != ParamDesc.Type.DOUBLE && (p.minD != null || p.maxD != null)) {
            this.withWarning("Param '" + p.name + "' is not a DOUBLE and define minD/maxD.");
        }
        if (p.type == ParamDesc.Type.INT && p.minI != null && p.maxI != null && p.minI > p.maxI) {
            this.withWarning("minI > maxI for parameter '" + p.name + "'.");
        }
        if (p.type != ParamDesc.Type.INT && (p.minI != null || p.maxI != null)) {
            this.withWarning("Param '" + p.name + "' is not a INT and define minI/maxI.");
        }
        if (p.type == ParamDesc.Type.CREDENTIAL_REQUEST && isPluginParam) {
            this.withFatal("Params of type CREDENTIAL_REQUEST are not allowed in 'pluginParams' (param '" + p.name + "')");
        } else if (p.type == ParamDesc.Type.CREDENTIAL_REQUEST) {
            if (p.credentialRequestSettings == null) {
                this.withFatal("Param '" + p.name + "' of type CREDENTIAL_REQUEST requires a 'credentialRequestSettings' object");
            } else if (p.credentialRequestSettings.type == null) {
                this.withFatal("Param '" + p.name + "' of type CREDENTIAL_REQUEST requires a 'type' field in its 'credentialRequestSettings' object");
            } else if (p.credentialRequestSettings.type == ParamDesc.CredentialRequestType.OAUTH2) {
                if (StringUtils.isBlank((String)p.credentialRequestSettings.authorizationEndpoint)) {
                    this.withFatal("Param '" + p.name + "' of type CREDENTIAL_REQUEST requires an 'authorizationEndpoint' field in its 'credentialRequestSettings' object");
                }
                if (StringUtils.isBlank((String)p.credentialRequestSettings.tokenEndpoint)) {
                    this.withFatal("Param '" + p.name + "' of type CREDENTIAL_REQUEST requires a 'tokenEndpoint' field in its 'credentialRequestSettings' object");
                }
            }
        }
    }

    private boolean isJSONPath(String paramName) {
        if (StringUtils.isBlank((String)paramName)) {
            return false;
        }
        return paramName.contains("[") || paramName.contains("]") || paramName.contains(".");
    }

    protected void withFatal(String msg) {
        this.messages.withFatal((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_DEFINITION, "[" + this.componentId + "] " + msg);
    }

    protected void withWarning(String msg) {
        this.messages.withWarning((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_DEFINITION, "[" + this.componentId + "] " + msg);
    }
}

