/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.prediction.PartitionedModelExtract;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SavedModelHandler
implements PartitionableHandler {
    private final SavedModel sm;

    public SavedModelHandler(SavedModel sm) {
        this.sm = sm;
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        ArrayList<Partition> result = new ArrayList<Partition>();
        if (this.sm.isPartitioned()) {
            for (String partition : this.getExtract().summaries.keySet()) {
                result.add(PartitionFactory.fromIdentifier(this.sm.getPartitioningSchema(), partition));
            }
        } else {
            result.add(Partition.newNP());
        }
        return result;
    }

    private PartitionedModelExtract getExtract() throws IOException {
        return new FullModelId(this.sm.projectKey, this.sm.id, this.sm.activeVersion).getPartitionedModelExtract();
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return this.listPartitions().contains(p);
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        throw new UnsupportedOperationException("Partitioned models do not support clearing partitions");
    }

    @Override
    public void close() throws Exception {
    }
}

