/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractHDFSableDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.server.SpringUtils;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultActivityLifecycleHook {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private JobAuthCtxService authCtxService;
    private final JobActivity activity;

    public DefaultActivityLifecycleHook(JobActivity activity) {
        this.activity = activity;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private void handleSourceDatasetPre(Dataset dataset) throws Exception {
        if (DatasetInspector.canHDFS(dataset)) {
            try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), dataset);){
                HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(handler);
                permHandler.setGatewayACLNoCreate(this.authCtxService.getAuthCtx());
                permHandler.setDataUsabilityAndDeletabilityACL(this.authCtxService.getAuthCtx());
            }
        }
        if (DatasetInspector.isHDFSInsideUploaded(this.authCtxService.getAuthCtx(), dataset, this.connectionsDAO)) {
            try (UploadedFilesDatasetHandler udh = (UploadedFilesDatasetHandler)DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), dataset);){
                this.handleSourceDatasetPre(udh.getRealDataset());
            }
        }
    }

    private boolean isFilesystemFolderWithLocalACLManagementEnabled(ManagedFolder folder) throws Exception {
        FsConnection fsConn;
        return "Filesystem".equals(folder.getType()) && (fsConn = (FsConnection)ConnectionsDAO.get().getConnection(this.authCtxService.getAuthCtx(), folder.getParams().connection)) != null && fsConn.params.manageLocalACLsForManagedFolders;
    }

    private void handleSourceFolderPre(ManagedFolder folder) throws Exception {
        try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(this.authCtxService.getAuthCtx());){
            if (this.isFilesystemFolderWithLocalACLManagementEnabled(folder)) {
                handler.grantReadACLs();
            }
            if ("HDFS".equals(folder.getType())) {
                HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(handler);
                permHandler.setGatewayACLNoCreate(this.authCtxService.getAuthCtx());
                permHandler.setDataUsabilityAndDeletabilityACL(this.authCtxService.getAuthCtx());
            }
        }
    }

    private void handleTargetDatasetPre(Dataset dataset, Partition partition) throws Exception {
        AbstractFSDatasetHandler handler;
        if ("Filesystem".equals(dataset.getType())) {
            handler = (FilesystemDatasetHandler)DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), dataset);
            try {
                ((FilesystemDatasetHandler)handler).prepareConnectionForWrite();
            }
            finally {
                if (handler != null) {
                    handler.close();
                }
            }
        }
        if (DatasetInspector.canHDFS(dataset)) {
            handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), dataset);
            try {
                HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler((HDFSDatasetHandler)handler);
                permHandler.setGatewayACLCreate(this.authCtxService.getAuthCtx());
                if (dataset.getPartitioningSchema().isPartitioned()) {
                    permHandler.setDataWritabilityACL(this.authCtxService.getAuthCtx(), partition);
                }
            }
            finally {
                if (handler != null) {
                    ((AbstractHDFSableDatasetHandler)handler).close();
                }
            }
        }
    }

    private void handleTargetFolderPre(ManagedFolder folder, Partition partition) throws Exception {
        try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(this.authCtxService.getAuthCtx());){
            handler.ensurePartitionFolder(partition);
            if (this.isFilesystemFolderWithLocalACLManagementEnabled(folder)) {
                handler.grantFullACLs();
            }
            if ("HDFS".equals(folder.getType())) {
                HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(handler);
                permHandler.setGatewayACLCreate(this.authCtxService.getAuthCtx());
                if (folder.getPartitioningSchema().isPartitioned()) {
                    permHandler.setDataWritabilityACL(this.authCtxService.getAuthCtx(), partition);
                }
            }
        }
    }

    private void handleSourceDatasetPost(Dataset dataset) throws IOException, InterruptedException, DKUSecurityException {
    }

    private void handleSourceFolderPost(ManagedFolder folder) throws IOException, InterruptedException, DKUSecurityException {
    }

    private void handleTargetDatasetPost(Dataset dataset, Partition partition) throws Exception {
        if (DatasetInspector.canHDFS(dataset)) {
            try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), dataset);){
                HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(handler);
                if (dataset.getPartitioningSchema().isPartitioned()) {
                    permHandler.setDataUsabilityAndDeletabilityACL(this.authCtxService.getAuthCtx(), partition);
                } else {
                    permHandler.setDataUsabilityAndDeletabilityACL(this.authCtxService.getAuthCtx());
                }
            }
        }
    }

    private void handleTargetFolderPost(ManagedFolder folder, Partition partition) throws Exception {
        if ("HDFS".equals(folder.getType())) {
            try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(this.authCtxService.getAuthCtx());){
                HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(handler);
                if (folder.getPartitioningSchema().isPartitioned()) {
                    permHandler.setDataUsabilityAndDeletabilityACL(this.authCtxService.getAuthCtx(), partition);
                } else {
                    permHandler.setDataUsabilityAndDeletabilityACL(this.authCtxService.getAuthCtx());
                }
            }
        }
    }

    public void onPreActivity() throws Exception {
        for (FlowComputable flowComputable : this.activity.getSubgraph().getSources()) {
            if (flowComputable.getType() == FlowComputable.FCType.DATASET) {
                this.handleSourceDatasetPre(((FlowDataset)flowComputable).getMandatory(this.datasetsDAO));
                continue;
            }
            if (flowComputable.getType() != FlowComputable.FCType.MANAGED_FOLDER) continue;
            this.handleSourceFolderPre(((FlowManagedFolder)flowComputable).getManagedFolder());
        }
        for (FlowComputable flowComputable : this.activity.getSubgraph().getTargets()) {
            if (flowComputable.getType() == FlowComputable.FCType.DATASET) {
                Dataset dataset = ((FlowDataset)flowComputable).getMandatory(this.datasetsDAO);
                this.handleTargetDatasetPre(dataset, this.activity.getSubgraph().getTargetPartition(flowComputable));
                continue;
            }
            if (flowComputable.getType() != FlowComputable.FCType.MANAGED_FOLDER) continue;
            this.handleTargetFolderPre(((FlowManagedFolder)flowComputable).getManagedFolder(), this.activity.getSubgraph().getTargetPartition(flowComputable));
        }
    }

    public void onPostActivity() throws Exception {
        for (FlowComputable flowComputable : this.activity.getSubgraph().getSources()) {
            if (flowComputable.getType() == FlowComputable.FCType.DATASET) {
                this.handleSourceDatasetPost(((FlowDataset)flowComputable).getMandatory(this.datasetsDAO));
                continue;
            }
            if (flowComputable.getType() != FlowComputable.FCType.MANAGED_FOLDER) continue;
            this.handleSourceFolderPost(((FlowManagedFolder)flowComputable).getManagedFolder());
        }
        for (FlowComputable flowComputable : this.activity.getSubgraph().getTargets()) {
            if (flowComputable.getType() == FlowComputable.FCType.DATASET) {
                Dataset dataset = ((FlowDataset)flowComputable).getMandatory(this.datasetsDAO);
                this.handleTargetDatasetPost(dataset, this.activity.getSubgraph().getTargetPartition(flowComputable));
                continue;
            }
            if (flowComputable.getType() != FlowComputable.FCType.MANAGED_FOLDER) continue;
            this.handleTargetFolderPost(((FlowManagedFolder)flowComputable).getManagedFolder(), this.activity.getSubgraph().getTargetPartition(flowComputable));
        }
    }
}

