/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractInitializedRunner
implements InitializableAbortableRecipeRunner,
FlowRunnable {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected JobAuthCtxService authCtxService;
    protected JobActivity activity;
    protected FlowRecipe recipe;
    protected Map<String, List<Input>> inputs;
    protected Map<String, List<Output>> outputs;

    public AbstractInitializedRunner(JobActivity activity) {
        this.activity = activity;
    }

    @Override
    public synchronized void init() throws Exception {
        this.recipe = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getRecipe();
        this.inputs = Maps.newHashMap();
        this.initInputs();
        this.outputs = Maps.newHashMap();
        this.initOutputs();
    }

    protected void initInputs() throws IOException {
        for (Map.Entry<String, SerializedRecipe.InputRole> e : this.recipe.getModel().getInputsUnsafe().entrySet()) {
            String role = e.getKey();
            for (SerializedRecipe.RecipeInput recipeInput : e.getValue().items) {
                Dataset inputDS = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(recipeInput.getLoc(this.recipe.getProjectKey())));
                FlowDataset inputFD = this.activity.getSubgraph().getSourceDataset(inputDS.getFullName());
                Schema schema = inputDS.getSchema();
                if (schema == null) continue;
                StreamableDatasetSelection ds = StreamableDatasetSelection.full();
                if (inputDS.getPartitioningSchema().isPartitioned()) {
                    ds.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
                    ds.selectedPartitions = Lists.newArrayList();
                    for (Partition p : this.activity.getSubgraph().getSourcePartitions(inputFD)) {
                        ds.selectedPartitions.add(p.id());
                    }
                }
                Input input = this.initializeInput(inputDS, schema, ds, role);
                if (!this.inputs.containsKey(role)) {
                    this.inputs.put(role, new ArrayList());
                }
                this.inputs.get(role).add(input);
            }
        }
    }

    protected Input initializeInput(Dataset inputDS, Schema schema, StreamableDatasetSelection ds, String role) {
        Input input = new Input();
        input.fullId = inputDS.getFullName();
        input.schema = schema;
        input.cf = new StreamColumnFactory(input.schema);
        input.is = UniversalSingleThreadPuller.pull(this.authCtxService.getAuthCtx(), inputDS, ds, (ColumnFactory)input.cf, this.activity.warnContext);
        return input;
    }

    protected void initOutputs() throws Exception {
        for (Map.Entry<String, SerializedRecipe.OutputRole> e : this.recipe.getModel().getOutputsUnsafe().entrySet()) {
            String role = e.getKey();
            for (SerializedRecipe.RecipeOutput recipeOutput : e.getValue().items) {
                Output output = new Output();
                Dataset outputDS = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(recipeOutput.getLoc(this.recipe.getProjectKey())));
                FlowDataset outputFD = this.activity.getSubgraph().getTargetDataset(outputDS.getFullName());
                Output.WriteMode writeMode = recipeOutput.getWriteMode();
                DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDS);
                try {
                    if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                        if (outputDatasetHandler instanceof AbstractFSDatasetHandler) {
                            outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{this.activity.getSubgraph().getTargetPartition(outputFD)}));
                        }
                        writeMode = Output.WriteMode.APPEND;
                    }
                    output.cf = new StreamColumnFactory();
                    output.rf = new StreamRowFactory();
                    output.name = outputDS.getFullName();
                    ToDatasetStreamer outputStreamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtxService.getAuthCtx(), outputDS, this.activity.getSubgraph().getTargetPartition(outputFD), (ColumnFactory)output.cf, this.activity.warnContext, writeMode);
                    output.out = outputStreamer.getAsProcessor();
                    if (!this.outputs.containsKey(role)) {
                        this.outputs.put(role, new ArrayList());
                    }
                    this.outputs.get(role).add(output);
                }
                finally {
                    if (outputDatasetHandler == null) continue;
                    outputDatasetHandler.close();
                }
            }
        }
    }

    public static class Input {
        public String fullId;
        public Schema schema;
        public StreamColumnFactory cf;
        public RowInputStream is;
    }

    public static class Output {
        public String name;
        public StreamColumnFactory cf;
        public StreamRowFactory rf;
        public SingleInputRowProcessor out;
    }
}

