/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HdfsPathSubstitution;
import com.dataiku.dip.pig.PigLogParser;
import com.dataiku.dip.pig.PigProgressListener;
import com.dataiku.dip.pig.PigScriptPreprocessor;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPigRecipeRunner
implements AbortableRecipeRunner {
    public static final String PIG_BIN_PARAM = "hadoop.pig.pigBinary";
    @Autowired
    protected RecipesDAO dao;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private ImpersonationResolverService impersonationService;
    protected final FlowRecipe recipe;
    protected final JobActivity activity;
    protected final RecipeRunnableSubgraph subgraph;
    static int cleanup_count = 0;
    private PigScriptPreprocessor preproc;
    protected boolean abortNotified;
    private String preprocessedScript;
    private DKUtils.ExecKiller pigProcess;
    private static Logger logger = Logger.getLogger((String)"dku.flow.pig");

    public AbstractPigRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
    }

    protected void doInit(String pigScript) throws Exception {
        this.preproc = new PigScriptPreprocessor(this.authCtxService.getAuthCtx(), this.datasetsDAO, this.variablesService.getForProject(this.recipe.getProjectKey()), this.recipe.getProjectKey(), this.subgraph, pigScript, false);
        this.preproc.preprocess();
        this.preprocessedScript = this.preproc.getPreprocessed();
        logger.info((Object)"Pig script preprocessed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws Exception {
        File preprocessedFile = FlowJobUtils.getJobFile("pig-recipe", "preprocessed.pig");
        FileUtils.write((File)preprocessedFile, (CharSequence)this.preprocessedScript, (String)"utf8");
        logger.info((Object)("Dumping preprocessed Pig script to " + String.valueOf(preprocessedFile)));
        logger.info((Object)"Removing stale temporary entries");
        for (HdfsPathSubstitution hdfsPath : this.preproc.getHDFSPathSubstitutions()) {
            FileSystem fs = hdfsPath.fs;
            Path tmpPath = new Path(hdfsPath.src);
            if (!fs.exists(tmpPath)) continue;
            if (!fs.delete(tmpPath, true)) {
                logger.warn((Object)("Failed to remove " + String.valueOf(tmpPath)));
                continue;
            }
            logger.info((Object)("Removed" + String.valueOf(tmpPath)));
        }
        logger.info((Object)"Starting up Pig");
        ArrayList<Object> cmd = new ArrayList<Object>();
        Params appParams = ApplicationConfigurator.getParams();
        if (appParams.hasParam(PIG_BIN_PARAM)) {
            cmd.add(appParams.getNonEmptyMandParam(PIG_BIN_PARAM));
        } else {
            cmd.add("pig");
        }
        cmd.add("-x");
        cmd.add("mapreduce");
        cmd.add("-param");
        cmd.add("job_name=" + this.recipe.getName() + ".pig-" + this.subgraph.id());
        cmd.add("-stop_on_failure");
        cmd.add(preprocessedFile.getPath());
        Map env = DKUtils.getEnvironment();
        env.put("JAVA_HOME", System.getProperty("java.home"));
        if (this.impersonationService.isEnabled()) {
            UserImpersonationTarget impersonated = this.impersonationService.getTargetUser(this.recipe.getProjectKey(), this.authCtxService.getAuthCtx());
            env.put("HADOOP_PROXY_USER", impersonated.hadoopUser);
        } else if (HadoopLoader.isKerberosLoginEnabled()) {
            HadoopLoader.addTicketCacheEnvVar(env);
        }
        if (this.activity != null) {
            this.activity.setStatusMessage("Starting Pig");
        }
        PigLogParser pigLogParser = new PigLogParser(new PigProgressListener(){

            @Override
            public void progressChanged(double p) {
                if (AbstractPigRecipeRunner.this.activity != null) {
                    AbstractPigRecipeRunner.this.activity.setStatusMessage("Pig (" + (int)(p * 100.0) + "%)");
                }
            }
        });
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("pig-recipe", "pig-out");){
            DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withArgs(cmd).withEnv(env).withCwd((File)outputTmpDir).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)pigLogParser).withCompletionHandler((DKUtils.ExecCompletionHandler)new DKUtils.SimpleExceptionExecCompletionHandler("Failed to execute Pig script, please check job logs"));
            AbstractPigRecipeRunner abstractPigRecipeRunner = this;
            synchronized (abstractPigRecipeRunner) {
                if (this.abortNotified) {
                    throw new Exception("Job killed : Pig not started");
                }
                this.pigProcess = execBuilder.makeNiceThenEvilKiller();
            }
            execBuilder.exec();
        }
        if (this.activity != null) {
            this.activity.setStatusMessage("Pig script executed successfully");
        }
        logger.info((Object)"Pig script execution successful");
        logger.info((Object)"Moving HDFS data to final location");
        for (HdfsPathSubstitution hdfsPath : this.preproc.getHDFSPathSubstitutions()) {
            Path tmpPath = new Path(hdfsPath.src);
            Path finalPath = new Path(hdfsPath.dst);
            Path backupPath = finalPath.suffix("__dkubck");
            boolean hasBackup = false;
            FileSystem fs = hdfsPath.fs;
            if (!fs.exists(tmpPath)) {
                throw new IOException("Recipe did not produce output data for " + String.valueOf(finalPath));
            }
            if (fs.exists(backupPath)) {
                logger.info((Object)("Remove old backup (move " + String.valueOf(finalPath) + " to " + String.valueOf(backupPath) + ")"));
                if (!fs.delete(backupPath, true)) {
                    logger.warn((Object)"Wasn't able to remove old backup !");
                }
            }
            if (fs.exists(finalPath)) {
                logger.info((Object)("Backup old dataset (move " + String.valueOf(finalPath) + " to " + String.valueOf(backupPath) + ")"));
                if (!fs.rename(finalPath, backupPath)) {
                    logger.warn((Object)"Wasn't able to backup the old output dataset !");
                }
                hasBackup = true;
            }
            logger.info((Object)("Moving " + String.valueOf(tmpPath) + " to " + String.valueOf(finalPath)));
            if (!fs.mkdirs(finalPath.getParent())) {
                throw new IOException("Mkdirs fail, but I don't know why");
            }
            if (!fs.rename(tmpPath, finalPath)) {
                throw new IOException("Renaming fail, but I don't know why");
            }
            if (!hasBackup) continue;
            fs.delete(backupPath, true);
        }
        this.cleanupTempDir();
    }

    protected void cleanupTempDir() {
        if (++cleanup_count % 5 != 0) {
            return;
        }
        String dir = System.getProperty("java.io.tmpdir");
        File file = new File(dir);
        long now = System.currentTimeMillis();
        for (File f : file.listFiles()) {
            if (!f.getName().startsWith("Job") || !f.getName().endsWith(".jar") || f.lastModified() + 600000L >= now) continue;
            try {
                DKUFileUtils.forceDelete((File)f);
            }
            catch (Throwable t) {
                logger.warn((Object)("Unable to cleanup file " + String.valueOf(f)), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        DKUtils.ExecKiller pigProcessCopy;
        AbstractPigRecipeRunner abstractPigRecipeRunner = this;
        synchronized (abstractPigRecipeRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            pigProcessCopy = this.pigProcess;
        }
        if (pigProcessCopy != null) {
            pigProcessCopy.kill();
        }
    }
}

