/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeHelper;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.common.creation.VirtualInputsRecipeCreationSettings;
import com.dataiku.dip.dataflow.exec.joinlike.VirtualInputBasedRecipeCreationService;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.VirtualInputsSingleOutputRecipeCreatorBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoFeatureGenerationRecipeCreator
extends VirtualInputsSingleOutputRecipeCreatorBase {
    @Autowired
    VirtualInputBasedRecipeCreationService creationService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    private final List<List<AutoFeatureGenerationRecipePayloadParams.Column>> virtualInputInferredColumns = new ArrayList<List<AutoFeatureGenerationRecipePayloadParams.Column>>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.afg.creator");

    public AutoFeatureGenerationRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        FlowRecipe fr = new FlowRecipe(recipe);
        JobActivity activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(fr));
        AutoFeatureGenerationRecipeSchemaComputer schemaComputer = (AutoFeatureGenerationRecipeSchemaComputer)this.meta.buildSchemaComputer(this.authCtx, activity);
        schemaComputer.setPayload(payload);
        outputDataset.setSchema(schemaComputer.getSchema());
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, StreamingEndpoint outputStreamingEndpoint) throws Exception {
        throw new Error("Unreachable");
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        Dataset[] inputDatasets;
        VirtualInputsRecipeCreationSettings settings = (VirtualInputsRecipeCreationSettings)JSON.parse((JsonElement)creationData, VirtualInputsRecipeCreationSettings.class);
        AutoFeatureGenerationRecipePayloadParams params = new AutoFeatureGenerationRecipePayloadParams();
        try (Transaction ignored = this.transactionService.beginRead();){
            inputDatasets = this.creationService.initializeVirtualInputs(params, settings, this.authCtx, recipe);
            boolean sparkEnabled = this.generalSettingsService.read().sparkSettings.sparkEnabled;
            this.checkIOSettings(recipe, inputDatasets, sparkEnabled);
        }
        AutoFeatureGenerationRecipeHelper helper = new AutoFeatureGenerationRecipeHelper();
        for (int virtualInputIndex = 0; virtualInputIndex < params.virtualInputs.size(); ++virtualInputIndex) {
            this.virtualInputInferredColumns.add(helper.getDefaultColumns_NT(this.authCtx, recipe.getProjectKey(), inputDatasets[virtualInputIndex]));
        }
        return super.create_NT(recipe, creationData);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, Dataset outputDataset) throws Exception {
        VirtualInputsRecipeCreationSettings settings = (VirtualInputsRecipeCreationSettings)JSON.parse((JsonElement)data, VirtualInputsRecipeCreationSettings.class);
        AutoFeatureGenerationRecipePayloadParams params = new AutoFeatureGenerationRecipePayloadParams();
        this.creationService.initializeVirtualInputs(params, settings, this.authCtx, recipe);
        HashSet excludedFromInput = Sets.newHashSet();
        if (outputDataset.getPartitioningSchema() != null && outputDataset.getPartitioningSchema().isPartitioned() && DatasetInspector.arePartitioningColumnsForbiddenInSchema(outputDataset)) {
            excludedFromInput.addAll(outputDataset.getPartitioningSchema().getDimensionNames());
        }
        for (int virtualInputIndex = 0; virtualInputIndex < params.virtualInputs.size(); ++virtualInputIndex) {
            List<AutoFeatureGenerationRecipePayloadParams.Column> selectedColumns = this.virtualInputInferredColumns.get(virtualInputIndex);
            excludedFromInput.forEach(excludedColumnName -> selectedColumns.removeIf(column -> excludedColumnName.equals(column.name)));
            ((AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get(virtualInputIndex)).setColumns(selectedColumns);
        }
        params.initializeFeatures();
        if (params.virtualInputs.size() >= 2) {
            params.initializeRelationshipDesc();
        }
        return JSON.json((Object)params);
    }

    @Override
    public RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData) throws Exception {
        return super.copy_NT(projectKey, source, copyData, AutoFeatureGenerationRecipePayloadParams.class);
    }

    private void checkIOSettings(SerializedRecipe recipe, Dataset[] inputDatasets, boolean sparkEnabled) throws Exception {
        HashSet<String> inputConnections = new HashSet<String>();
        for (Dataset inputDataset : inputDatasets) {
            if (inputDataset == null) {
                throw new IllegalArgumentException("Input dataset does not exist.");
            }
            if (inputDataset.getSchema() == null) {
                throw new IllegalArgumentException("Input dataset " + inputDataset.getName() + " does not have a valid schema.");
            }
            if (inputDataset.getParams() != null && inputDataset.getParams().getConnection() != null) {
                inputConnections.add(inputDataset.getParams().getConnection());
            }
            if (!sparkEnabled && !DatasetInspector.isSQL(inputDataset)) {
                throw new IllegalArgumentException("Input dataset " + inputDataset.getName() + " must be an SQL dataset, or Spark must be enabled on the DSS instance.");
            }
            if (inputDataset.getModel() == null || !inputDataset.getModel().isPartitioned()) continue;
            throw new IllegalArgumentException("Input dataset " + inputDataset.getName() + " is partitioned.");
        }
        if (inputConnections.size() > 1) {
            throw new IllegalArgumentException("At least two input datasets have different connections.");
        }
        for (SerializedRecipe.RecipeOutput output : recipe.getFlatOutputs()) {
            AnyLoc loc;
            Dataset outputDataset;
            if (StringUtils.isBlank((String)output.ref) || (outputDataset = this.datasetAccessService.getOrNull(loc = AnyLoc.resolveSmart(recipe.getProjectKey(), output.ref))) == null || outputDataset.getSchema() == null) continue;
            if (!sparkEnabled && !DatasetInspector.isSQL(outputDataset)) {
                throw new IllegalArgumentException("Output dataset " + outputDataset.getName() + " must be an SQL dataset, or Spark must be enabled on the DSS instance.");
            }
            if (outputDataset.getModel() == null || !outputDataset.getModel().isPartitioned()) continue;
            throw new IllegalArgumentException("Dataset " + outputDataset.getName() + " is partitioned.");
        }
    }
}

