/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.dataflow.common.VirtualInputBasedRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipType;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.TimeWindow;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.VariableType;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class AutoFeatureGenerationRecipePayloadParams
extends VirtualInputBasedRecipePayloadParams<InputDesc> {
    public List<RelationshipDesc> relationships = new ArrayList<RelationshipDesc>();
    public List<Feature> features = new ArrayList<Feature>();
    public CutoffTime cutoffTime = new CutoffTime();

    @Override
    public InputDesc newInputDesc() {
        return new InputDesc();
    }

    public InputDesc getPrimaryDataset() {
        if (this.virtualInputs.isEmpty()) {
            throw ErrorContext.iae((String)"The primary dataset is missing");
        }
        return (InputDesc)this.virtualInputs.get(0);
    }

    public List<InputDesc> getSecondaryDatasets() {
        int secondaryDatasetsCount = this.virtualInputs.size();
        if (secondaryDatasetsCount > 1) {
            return this.virtualInputs.subList(1, secondaryDatasetsCount);
        }
        return new ArrayList<InputDesc>();
    }

    @Override
    public void validate() {
        this.validateInputDatasets();
        this.validateRelationShips();
        this.validateTimeWindows();
    }

    private void validateInputDatasets() {
        this.validateTableDefinition();
        for (InputDesc virtualInput : this.virtualInputs) {
            if (virtualInput.originLabel != null) continue;
            throw ErrorContext.iae((String)"Invalid input definition. The origin label is missing");
        }
    }

    public void validateRelationShips() {
        for (RelationshipDesc relationship : this.relationships) {
            if (relationship.table1 >= this.virtualInputs.size() || relationship.table2 >= this.virtualInputs.size()) {
                throw ErrorContext.iae((String)"A relationship contains invalid input datasets");
            }
            String table1Name = ((InputDesc)this.virtualInputs.get((int)relationship.table1)).originLabel;
            String table2Name = ((InputDesc)this.virtualInputs.get((int)relationship.table2)).originLabel;
            if (relationship.type == null) {
                throw ErrorContext.iaef((String)"Please specify a type for the relationship between the input datasets '%s' and '%s'", (Object)table1Name, (Object[])new Object[]{table2Name});
            }
            if (relationship.getJoinConditions() == null || relationship.getJoinConditions().isEmpty()) {
                throw ErrorContext.iaef((String)"Please specify at least one join condition between the input datasets '%s' and '%s'", (Object)table1Name, (Object[])new Object[]{table2Name});
            }
            for (JoinRecipePayloadParams.MatchingCondition joinCondition : relationship.getJoinConditions()) {
                this.validateJoinConditions(joinCondition);
            }
        }
    }

    public void validateTimeWindows() {
        if (this.cutoffTime.mode == CutoffTime.CutoffTimeMode.COLUMN) {
            if (StringUtils.isBlank((String)this.getPrimaryDataset().timeIndexColumn)) {
                throw ErrorContext.iae((String)"Primary dataset must have a time index column when cutoff time mode is 'column'");
            }
        } else {
            if (this.cutoffTime.mode == null && this.virtualInputs.size() > 1) {
                throw ErrorContext.iae((String)"The cutoff time mode is missing");
            }
            if (this.cutoffTime.mode == CutoffTime.CutoffTimeMode.NONE && !this.virtualInputs.isEmpty()) {
                for (InputDesc virtualInput : this.virtualInputs) {
                    if (virtualInput.timeIndexColumn == null || virtualInput.timeIndexColumn.isEmpty()) continue;
                    throw ErrorContext.iaef((String)"Dataset %s cannot have a time index column if the cutoff time mode is none", (Object)virtualInput.name, (Object[])new Object[0]);
                }
            } else if (this.virtualInputs.size() > 1 && (((InputDesc)this.virtualInputs.get((int)0)).timeIndexColumn.isEmpty() || ((InputDesc)this.virtualInputs.get((int)0)).timeIndexColumn == null)) {
                for (int i = 1; i < this.virtualInputs.size(); ++i) {
                    if (((InputDesc)this.virtualInputs.get((int)i)).timeIndexColumn == null || ((InputDesc)this.virtualInputs.get((int)i)).timeIndexColumn.isEmpty()) continue;
                    throw ErrorContext.iaef((String)"Enrichment dataset %s cannot have a time index column if the primary dataset does not have a cutoff time column", (Object)((InputDesc)this.virtualInputs.get((int)i)).name, (Object[])new Object[0]);
                }
            }
        }
        for (InputDesc virtualInput : this.virtualInputs) {
            if (!virtualInput.timeWindows.isEmpty() && virtualInput.timeIndexColumn == null) {
                throw ErrorContext.iaef((String)"Dataset %s cannot have a time window without a time index", (Object)virtualInput.name, (Object[])new Object[0]);
            }
            for (TimeWindow timeWindow : virtualInput.timeWindows) {
                if (timeWindow.to >= 0 && timeWindow.to < timeWindow.from) continue;
                throw ErrorContext.iaef((String)"Invalid time window, must be 0 <= to < from (invalid values from: %d, to: %d", (Object)timeWindow.from, (Object[])new Object[]{timeWindow.to});
            }
        }
    }

    public void initializeFeatures() {
        this.features.addAll(Arrays.asList(Feature.COUNT, Feature.AVG, Feature.MAX, Feature.MIN, Feature.SUM, Feature.DISTINCT, Feature.DAY_OF_MONTH, Feature.DAY_OF_WEEK, Feature.MONTH_OF_YEAR, Feature.HOUR_OF_DAY, Feature.WEEK_OF_YEAR, Feature.YEAR, Feature.CHARACTER_COUNT, Feature.WORD_COUNT));
    }

    public void initializeRelationshipDesc() {
        RelationshipDesc relationship = new RelationshipDesc();
        relationship.table1 = 0;
        relationship.table2 = 1;
        this.relationships = Lists.newArrayList((Object[])new RelationshipDesc[]{relationship});
    }

    public void validateJoinConditions(JoinRecipePayloadParams.MatchingCondition joinCondition) {
        if (joinCondition.type == null) {
            throw ErrorContext.iae((String)"Invalid matching condition.");
        }
        if (!this.isValidColumnDesc(joinCondition.column1) || !this.isValidColumnDesc(joinCondition.column2)) {
            throw ErrorContext.iae((String)"Invalid column in matching conditions.");
        }
        if (joinCondition.type != JoinRecipePayloadParams.MatchingType.EQ) {
            throw ErrorContext.iae((String)"Only equality join types are allowed");
        }
    }

    protected boolean isValidColumnDesc(ColumnDesc cd) {
        return cd != null && !StringUtils.isBlank((String)cd.name) && this.isValidTableIndex(cd.table);
    }

    public List<Feature> getRelationalFeaturesForType(VariableType variableType) {
        return this.getFeaturesForType(variableType, FeatureType.RELATIONAL);
    }

    public List<Feature> getEntityFeaturesForType(VariableType variableType) {
        return this.getFeaturesForType(variableType, FeatureType.ENTITY);
    }

    public List<Feature> getAllFeaturesForVariableType(@Nullable VariableType variableType) {
        return this.features.stream().filter(feature -> Objects.equals((Object)variableType, (Object)feature.inputVariableType)).collect(Collectors.toList());
    }

    public List<Feature> getFeaturesForType(VariableType variableType, FeatureType featureType) {
        return this.features.stream().filter(feature -> featureType.equals((Object)feature.featureType) && variableType.equals((Object)feature.inputVariableType)).collect(Collectors.toList());
    }

    public static class CutoffTime {
        public CutoffTimeMode mode = null;

        public static enum CutoffTimeMode {
            NONE,
            COLUMN;

        }
    }

    public static class InputDesc
    extends JoinInputDescBase {
        public String timeIndexColumn;
        public List<Column> selectedColumns = new ArrayList<Column>();
        public List<TimeWindow> timeWindows = new ArrayList<TimeWindow>();

        public List<Column> getSelectedColumns() {
            return this.selectedColumns;
        }

        public void setColumns(List<Column> columnsForComputations) {
            this.selectedColumns = columnsForComputations;
        }
    }

    public static class RelationshipDesc {
        public int table1;
        public int table2;
        @Nullable
        public RelationshipType type;
        public List<JoinRecipePayloadParams.MatchingCondition> on = new ArrayList<JoinRecipePayloadParams.MatchingCondition>();

        public List<JoinRecipePayloadParams.MatchingCondition> getJoinConditions() {
            return this.on;
        }

        public List<JoinRecipePayloadParams.MatchingCondition> reverseConditions() {
            ArrayList<JoinRecipePayloadParams.MatchingCondition> reversedConditions = new ArrayList<JoinRecipePayloadParams.MatchingCondition>();
            for (JoinRecipePayloadParams.MatchingCondition condition : this.on) {
                JoinRecipePayloadParams.MatchingCondition reversedCondition = new JoinRecipePayloadParams.MatchingCondition();
                reversedCondition.column1 = condition.column2;
                reversedCondition.column2 = condition.column1;
                reversedCondition.type = condition.type;
                reversedConditions.add(reversedCondition);
            }
            return reversedConditions;
        }
    }

    public static enum Feature {
        DAY_OF_MONTH(FeatureType.ENTITY, false, "day", "day of the month", VariableType.DATE),
        MONTH_OF_YEAR(FeatureType.ENTITY, false, "month", "month of the year", VariableType.DATE),
        YEAR(FeatureType.ENTITY, false, "year", "year", VariableType.DATE),
        DAY_OF_WEEK(FeatureType.ENTITY, false, "dow", "day of the week", VariableType.DATE),
        HOUR_OF_DAY(FeatureType.ENTITY, false, "hour", "hour of the day", VariableType.DATE),
        WEEK_OF_YEAR(FeatureType.ENTITY, false, "week", "week of the year", VariableType.DATE),
        CHARACTER_COUNT(FeatureType.ENTITY, true, "char_count", "character count", VariableType.TEXT),
        WORD_COUNT(FeatureType.ENTITY, true, "word_count", "word count", VariableType.TEXT),
        MIN(FeatureType.RELATIONAL, true, "min", "minimum value", VariableType.NUMERIC),
        MAX(FeatureType.RELATIONAL, true, "max", "maximum value", VariableType.NUMERIC),
        COUNT(FeatureType.GLOBAL, true, "count", "count", null),
        DISTINCT(FeatureType.RELATIONAL, true, "distinct", "count of distinct values", VariableType.CATEGORY),
        SUM(FeatureType.RELATIONAL, true, "sum", "sum", VariableType.NUMERIC),
        AVG(FeatureType.RELATIONAL, true, "avg", "average", VariableType.NUMERIC);

        final FeatureType featureType;
        final boolean returnsNumericalValue;
        final String shortName;
        public final String description;
        public final VariableType inputVariableType;

        private Feature(FeatureType featureType, boolean returnsNumericalValue, String shortName, String description, VariableType inputVariableType) {
            this.featureType = featureType;
            this.returnsNumericalValue = returnsNumericalValue;
            this.shortName = shortName;
            this.description = description;
            this.inputVariableType = inputVariableType;
        }

        Type getSchemaTypeForFeature(Type inputColumnType) {
            switch (this) {
                case MIN: 
                case MAX: {
                    return inputColumnType;
                }
                case SUM: {
                    if (inputColumnType.isInteger() || inputColumnType == Type.BOOLEAN) {
                        return Type.BIGINT;
                    }
                    return inputColumnType;
                }
                case AVG: {
                    return Type.DOUBLE;
                }
                case DAY_OF_MONTH: 
                case MONTH_OF_YEAR: 
                case YEAR: 
                case DAY_OF_WEEK: 
                case HOUR_OF_DAY: 
                case WEEK_OF_YEAR: 
                case CHARACTER_COUNT: 
                case WORD_COUNT: 
                case COUNT: 
                case DISTINCT: {
                    return Type.BIGINT;
                }
            }
            throw new IllegalArgumentException("Unknown feature " + String.valueOf((Object)this));
        }
    }

    public static enum FeatureType {
        ENTITY,
        RELATIONAL,
        GLOBAL;

    }

    public static class Column {
        public String name;
        public VariableType variableType;

        public Column(String name, VariableType variableType) {
            this.name = name;
            this.variableType = variableType;
        }
    }
}

