/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.PivotRecipeService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class PivotRecipeCreator
extends SISORecipeCreator {
    private final PivotRecipeService service = new PivotRecipeService();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.pivot.creator");

    public PivotRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
        SpringUtils.getInstance().autowire((Object)this.service);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        outputDataset.setSchema(new Schema());
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        PivotRecipeCreationSettings settings = (PivotRecipeCreationSettings)JSON.parse((JsonElement)data, PivotRecipeCreationSettings.class);
        PivotRecipePayloadParams params = new PivotRecipePayloadParams();
        PivotElement pivotElement = new PivotElement();
        pivotElement.keyColumns.add(settings.key);
        params.pivots.add(pivotElement);
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        if ("BigQuery".equals(outputDataset.getType())) {
            params.modalitySlugification = PivotRecipePayloadParams.ModalitySlugification.HARD_SLUGIFY;
        }
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        return JSON.json((Object)params);
    }

    public static class PivotRecipeCreationSettings
    extends SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings {
        public String key;
    }
}

