/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.split.AbstractSplitRecipeExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeHelper;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeHelperBuilder;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.ErrorContext;

public abstract class AbstractSplitRecipeSQLlikeExecutor
extends AbstractSplitRecipeExecutor {
    SplitRecipeHelper splitHelper;
    SQLDialect dialect;
    private AbortableRecipeRunner runner;
    private volatile boolean abortNotified;

    AbstractSplitRecipeSQLlikeExecutor(JobActivity activity, SplitRecipePayloadParams params, boolean lowerCaseColumns, SQLDialect dialect) {
        super(activity, params, lowerCaseColumns);
        this.dialect = dialect;
    }

    private void setSplitHelper() throws Exception {
        SplitRecipeHelperBuilder helper = new SplitRecipeHelperBuilder(this.activity, this.params, this.lowerCaseColumns, this.dialect);
        if (this.params.mode == SplitRecipePayloadParams.Mode.CENTILE) {
            helper.setTotalRecordsWithFilters(this.getTotalRecordsWithFilters());
        }
        this.splitHelper = helper.build();
    }

    @Override
    public void run() throws Exception {
        this.setSplitHelper();
        if (this.params.mode == SplitRecipePayloadParams.Mode.RANDOM) {
            this.assertSupportRandom();
        }
        this.runAllSplits();
    }

    protected void run(AbortableRecipeRunner runner) throws Exception {
        this.runner = runner;
        if (this.abortNotified) {
            logger.info((Object)"Abort already notified, skipping run");
            return;
        }
        runner.run();
    }

    protected void assertSupportRandom() {
        throw ErrorContext.iae((String)"Random split is not supported by this engine");
    }

    protected void runAllSplits() throws Exception {
        for (String outputDatasetFullId : this.splitHelper.effectiveConditions.keySet()) {
            this.runSplit(outputDatasetFullId);
        }
    }

    protected abstract void runSplit(String var1) throws Exception;

    protected String generateSQL(SQLDialect dialect, String outputDatasetFullId) throws Exception {
        return this.splitHelper.generateSql(dialect, outputDatasetFullId);
    }

    String generateSqlForCentileForMysql(SQLDialect dialect, String outputDatasetFullId) throws Exception {
        return this.splitHelper.generateSqlForCentileForMysql(dialect, outputDatasetFullId);
    }

    String generateSqlForHive(SQLDialect dialect) throws Exception {
        return this.splitHelper.generateSqlForHive(dialect);
    }

    @Override
    public void notifyBeforeAborting() {
        this.abortNotified = true;
        AbortableRecipeRunner runner = this.runner;
        if (runner != null) {
            runner.notifyBeforeAborting();
        }
    }
}

