/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.dataflow.exec.split.AbstractSplitProcessorOutput;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.expressions.Expression;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FilterBasedSplitProcessorOutput
extends AbstractSplitProcessorOutput {
    protected List<FilteredOutput> outputs = new ArrayList<FilteredOutput>();
    static Logger logger = Logger.getLogger((String)"dku.recipes.split.filterbased");

    public FilterBasedSplitProcessorOutput(SplitRecipePayloadParams params) {
        this.params = params;
    }

    public void addOutput(Expression expr, ProcessorOutput output) {
        this.outputs.add(new FilteredOutput(expr, output));
    }

    public void emitRow(Row row) throws Exception {
        this.enrichRowWithComputedColumns(row);
        for (FilteredOutput fo : this.outputs) {
            if (!fo.expr.isTrueish(this.rowCopy)) continue;
            if (fo.output != null) {
                fo.output.emitRow(row);
            }
            return;
        }
        if (this.defaultOutput != null) {
            this.defaultOutput.emitRow(row);
        }
    }

    public void cancel() throws Exception {
        for (FilteredOutput fo : this.outputs) {
            if (fo.output == null) continue;
            fo.output.cancel();
        }
        if (this.defaultOutput != null) {
            this.defaultOutput.cancel();
        }
    }

    public void setMaxMemoryUsed(long size) {
        for (FilteredOutput fo : this.outputs) {
            if (fo.output == null) continue;
            fo.output.setMaxMemoryUsed(size);
        }
        if (this.defaultOutput != null) {
            this.defaultOutput.setMaxMemoryUsed(size);
        }
    }

    private static class FilteredOutput {
        public Expression expr;
        public ProcessorOutput output;

        public FilteredOutput(Expression e, ProcessorOutput o) {
            this.expr = e;
            this.output = o;
        }
    }
}

