/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.topn;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datalayer.topn.TopNer;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.server.recipes.TopNRecipeService;
import com.dataiku.dip.shaker.processors.transform.ColumnRenamer;
import com.dataiku.dip.shaker.processors.transform.FindReplace;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TopNRecipeBuiltinRunner
extends AbstractStagedThreadedBuiltinRunner {
    @Autowired
    private TopNRecipeService service;
    private TopNRecipePayloadParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.topn");

    public TopNRecipeBuiltinRunner(JobActivity activity, TopNRecipePayloadParams params) {
        super(activity, false);
        this.params = params;
    }

    @Override
    public List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
        AbstractInitializedRunner.Output outputRejects;
        assert (this.inputs.containsKey("main"));
        assert (!((List)this.inputs.get("main")).isEmpty());
        assert (this.outputs.containsKey("main"));
        assert (!((List)this.outputs.get("main")).isEmpty());
        ArrayList<AbstractInitializedRunner.Output> usedOutputs = new ArrayList<AbstractInitializedRunner.Output>();
        AbstractInitializedRunner.Input input = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
        AbstractInitializedRunner.Output outputMain = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
        usedOutputs.add(outputMain);
        AbstractInitializedRunner.Output output = outputRejects = this.service.hasRejectsOutput(this.recipe.getModel()) ? (AbstractInitializedRunner.Output)((List)this.outputs.get("rejects")).get(0) : null;
        if (outputRejects != null) {
            usedOutputs.add(outputRejects);
        }
        StreamColumnFactory currentCf = input.cf;
        StreamRowFactory currentRf = null;
        RowInputStream currentInput = input.is;
        if (FilterDescUtils.willFilter(this.params.preFilter)) {
            GrelExpression preFilterExpression = FilterDescUtils.getGrelFilterExpression(this.params.preFilter);
            AbstractStagedThreadedBuiltinRunner.FilteringThread filteringStage = new AbstractStagedThreadedBuiltinRunner.FilteringThread(preFilterExpression);
            ((AbstractStagedThreadedBuiltinRunner.ComputationStage)filteringStage).setInputFactories((ColumnFactory)currentCf, (RowFactory)currentRf, currentInput);
            currentCf = new StreamColumnFactory();
            currentRf = new StreamRowFactory();
            currentInput = new UniversalSingleThreadPuller.Stream();
            ((AbstractStagedThreadedBuiltinRunner.ComputationStage)filteringStage).setOutputFactories((ColumnFactory)currentCf, (RowFactory)currentRf, (UniversalSingleThreadPuller.Stream)currentInput);
            this.stages.add(filteringStage);
        }
        Schema schemaAfterComputedCols = new Schema(input.schema);
        if (this.params.computedColumns != null && !this.params.computedColumns.isEmpty()) {
            AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread computedColumnsStage = new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(this.params.computedColumns);
            ((AbstractStagedThreadedBuiltinRunner.ComputationStage)computedColumnsStage).setInputFactories((ColumnFactory)currentCf, (RowFactory)currentRf, currentInput);
            currentCf = new StreamColumnFactory();
            currentRf = new StreamRowFactory();
            currentInput = new UniversalSingleThreadPuller.Stream();
            ((AbstractStagedThreadedBuiltinRunner.ComputationStage)computedColumnsStage).setOutputFactories((ColumnFactory)currentCf, (RowFactory)currentRf, (UniversalSingleThreadPuller.Stream)currentInput);
            this.stages.add(computedColumnsStage);
            for (ComputedColumn cc : this.params.computedColumns) {
                ComputedColumnUtils.addToSchema(schemaAfterComputedCols, cc);
            }
        }
        TopNer topner = new TopNer(this.params, new File(tempDirectory, "topn"), this.mergeSortParams);
        Schema schemaAfterTopn = topner.getOutputSchema(schemaAfterComputedCols);
        TopNerThread topnerStage = new TopNerThread(topner, schemaAfterComputedCols);
        topnerStage.setInputFactories((ColumnFactory)currentCf, (RowFactory)currentRf, currentInput);
        this.stages.add(topnerStage);
        if (this.params.outputColumnNameOverrides != null && !this.params.outputColumnNameOverrides.keySet().isEmpty()) {
            StreamColumnFactory currentCfMain = new StreamColumnFactory();
            StreamRowFactory currentRfMain = new StreamRowFactory();
            UniversalSingleThreadPuller.Stream currentInputMain = new UniversalSingleThreadPuller.Stream();
            StreamColumnFactory currentCfRejects = null;
            StreamRowFactory currentRfRejects = null;
            UniversalSingleThreadPuller.Stream currentInputRejects = null;
            if (outputRejects != null) {
                currentCfRejects = new StreamColumnFactory();
                currentRfRejects = new StreamRowFactory();
                currentInputRejects = new UniversalSingleThreadPuller.Stream();
            }
            topnerStage.setOutputFactories((ColumnFactory)currentCfMain, (RowFactory)currentRfMain, currentInputMain);
            topnerStage.setRejectsOutput(currentInputRejects);
            ColumnRenamer.Parameter rp = new ColumnRenamer.Parameter();
            for (String from : this.params.outputColumnNameOverrides.keySet()) {
                String to = this.params.outputColumnNameOverrides.get(from);
                if (!StringUtils.isNotBlank((String)from) || !StringUtils.isNotBlank((String)to)) continue;
                rp.renamings.add(new FindReplace.Substitution(from, to));
            }
            ColumnRenamer columnRenamerMain = new ColumnRenamer(rp);
            columnRenamerMain.setColumnFactory((ColumnFactory)outputMain.cf);
            columnRenamerMain.init();
            AbstractStagedThreadedBuiltinRunner.RenamingThread columnRenamerMainStage = new AbstractStagedThreadedBuiltinRunner.RenamingThread(columnRenamerMain, schemaAfterTopn);
            columnRenamerMainStage.setInputFactories((ColumnFactory)currentCfMain, (RowFactory)currentRfMain, currentInputMain);
            columnRenamerMainStage.setOutputFactories((ColumnFactory)outputMain.cf, (RowFactory)outputMain.rf, (ProcessorOutput)new ProcessorOutputToSIP(outputMain.out));
            this.stages.add(columnRenamerMainStage);
            if (outputRejects != null) {
                ColumnRenamer columnRenamerRejects = new ColumnRenamer(rp);
                columnRenamerRejects.setColumnFactory((ColumnFactory)outputRejects.cf);
                columnRenamerRejects.init();
                AbstractStagedThreadedBuiltinRunner.RenamingThread columnRenamerRejectsStage = new AbstractStagedThreadedBuiltinRunner.RenamingThread(columnRenamerRejects, schemaAfterTopn);
                columnRenamerRejectsStage.setInputFactories((ColumnFactory)currentCfRejects, (RowFactory)currentRfRejects, currentInputRejects);
                columnRenamerRejectsStage.setOutputFactories((ColumnFactory)outputRejects.cf, (RowFactory)outputRejects.rf, (ProcessorOutput)new ProcessorOutputToSIP(outputRejects.out));
                this.stages.add(columnRenamerRejectsStage);
            }
        } else {
            topnerStage.setOutputFactories((ColumnFactory)outputMain.cf, (RowFactory)outputMain.rf, (ProcessorOutput)new ProcessorOutputToSIP(outputMain.out));
            if (outputRejects != null) {
                topnerStage.setRejectsOutput((ProcessorOutput)new ProcessorOutputToSIP(outputRejects.out));
            }
        }
        return usedOutputs;
    }

    private class TopNerThread
    extends AbstractStagedThreadedBuiltinRunner.ComputationStage {
        private final TopNer topner;
        private final Schema inputSchema;
        private ProcessorOutput outputMain;
        private ProcessorOutput outputRejects;
        private RowInputStream input;
        private RowFactory outputRfMain;
        private ColumnFactory outputCfMain;
        private ColumnFactory inputCf;
        private Throwable exception;

        public TopNerThread(TopNer topner, Schema inputSchema) {
            this.topner = topner;
            this.inputSchema = inputSchema;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.inputCf = cf;
            this.input = input;
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.outputCfMain = cf;
            this.outputRfMain = rf;
            this.outputMain = output;
        }

        protected void setRejectsOutput(ProcessorOutput outputRejects) {
            this.outputRejects = outputRejects;
        }

        @Override
        public void run() {
            try {
                this.topner.compute(this.input, this.inputCf, this.inputSchema, this.outputMain, this.outputCfMain, this.outputRfMain, this.outputRejects);
                this.outputMain.lastRowEmitted();
                if (this.outputRejects != null) {
                    this.outputRejects.lastRowEmitted();
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Interrupted TopN computer");
                try {
                    this.topner.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"TopN computer failed", (Throwable)e);
                TopNRecipeBuiltinRunner.this.interruptStages();
                try {
                    this.outputMain.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                try {
                    if (this.outputRejects != null) {
                        this.outputRejects.cancel();
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }
    }
}

