/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.vstack;

import com.dataiku.dip.coremodel.ComplexType;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.vstack.VStackQueryGenerator;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VStackRecipeService {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;

    public String generateSQL(JobActivity activity, SQLDialect dialect, VStackRecipePayloadParams params, boolean ignorePartitioning) throws IOException {
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        HashMap<String, Dataset> sources = new HashMap<String, Dataset>();
        for (FlowDataset fdSource : subgraph.getSourceDatasets()) {
            Dataset source = fdSource.getMandatory(this.datasetsDAO);
            sources.put(source.getFullName(), source);
        }
        Schema outputSchema = this.getOutputSchema(activity, params, false);
        HashMap<String, List<Partition>> sourcePartitions = new HashMap<String, List<Partition>>();
        HashMap<String, PartitioningScheme> sourcePartitionSchemes = new HashMap<String, PartitioningScheme>();
        PartitioningScheme targetPartitionScheme = null;
        Dataset outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO);
        if (!ignorePartitioning) {
            if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams)) {
                for (FlowDataset fdSource : activity.getSubgraph().getSourceDatasets()) {
                    Dataset source = fdSource.getMandatory(this.datasetsDAO);
                    List<Partition> parts = activity.getSubgraph().getSourcePartitions(fdSource);
                    if (parts == null || parts.size() <= 0 || parts.get(0).isAll() || parts.get(0).isNP() || !source.getPartitioningSchema().isPartitioned()) continue;
                    sourcePartitionSchemes.put(source.getFullName(), source.getPartitioningSchema());
                    sourcePartitions.put(source.getFullName(), parts);
                }
            }
            if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDS)) {
                targetPartitionScheme = outputDS.getPartitioningSchema();
            }
        }
        Dataset outputDSWithSchema = ((Dataset)JSON.deepCopy((Object)outputDS)).withSchema(outputSchema);
        return this.generateSQL(sources, outputDSWithSchema, params, dialect, sourcePartitionSchemes, sourcePartitions, targetPartitionScheme);
    }

    public String generateSQL(Map<String, Dataset> sources, Dataset outputDataset, VStackRecipePayloadParams params, SQLDialect dialect, Map<String, PartitioningScheme> sourcePartitionSchemes, Map<String, List<Partition>> sourcePartitions, PartitioningScheme targetPartitionScheme) throws IOException {
        VStackQueryGenerator sqlGenerator = new VStackQueryGenerator(params, sources, outputDataset);
        sqlGenerator.setPartitioning(sourcePartitionSchemes, sourcePartitions, targetPartitionScheme);
        return sqlGenerator.generateSQL(dialect);
    }

    public String generateSQLIgnorePartitioning(Map<String, Dataset> sources, Dataset outputDataset, VStackRecipePayloadParams params, SQLDialect dialect) throws IOException {
        return this.generateSQL(sources, outputDataset, params, dialect, null, null, null);
    }

    public Schema getOutputSchema(JobActivity activity, VStackRecipePayloadParams params, boolean lowerCaseColumnsNames) throws IOException {
        if (params.mode == null) {
            throw ErrorContext.iae((String)"Merge 'mode' parameter must be set");
        }
        List<FlowDataset> sources = activity.getSubgraph().getSourceDatasets();
        FlowDataset fdTarget = activity.getSubgraph().getTargetsDatasets().get(0);
        Schema outputSchema = null;
        switch (params.mode) {
            case UNION: {
                for (FlowDataset fdSource : sources) {
                    Schema s = fdSource.getMandatory(this.datasetsDAO).getSchema();
                    if (s == null) {
                        throw ErrorContext.iaef((String)"Cannont compute schema union with empty-schema dataset '%s'", (Object)fdSource.getFullName(), (Object[])new Object[0]);
                    }
                    if (outputSchema == null) {
                        outputSchema = s;
                        continue;
                    }
                    outputSchema = SchemaUtils.union(outputSchema, s);
                }
                break;
            }
            case INTERSECT: {
                for (FlowDataset fdSource : sources) {
                    Schema s = fdSource.getMandatory(this.datasetsDAO).getSchema();
                    if (s == null) {
                        throw ErrorContext.iaef((String)"Cannont compute schema intersection with empty-schema dataset '%s'", (Object)fdSource.getFullName(), (Object[])new Object[0]);
                    }
                    if (outputSchema == null) {
                        outputSchema = s;
                        continue;
                    }
                    outputSchema = SchemaUtils.intersect(outputSchema, s);
                }
                break;
            }
            case FROM_DATASET: {
                String projectKey = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getProjectKey();
                DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(projectKey, params.copySchemaFromDatasetWithName);
                SerializedDataset refDataset = (SerializedDataset)this.datasetsDAO.getMandatory(datasetLoc);
                outputSchema = refDataset.getSchema();
                break;
            }
            case FROM_INDEX: {
                outputSchema = new Schema();
                List currentColumns = outputSchema.getColumns();
                int index = 0;
                for (String columnName : params.selectedColumns) {
                    if (index >= outputSchema.getColumns().size()) {
                        outputSchema.addColumn(this.commonTypeIndex(params.virtualInputs, sources, index).newColumn(columnName));
                    }
                    ((SchemaColumn)currentColumns.get(index)).setName(columnName);
                    ++index;
                }
                break;
            }
            case REMAP: {
                outputSchema = new Schema();
                List currentColumns = outputSchema.getColumns();
                int index = 0;
                for (String columnName : params.selectedColumns) {
                    if (index >= outputSchema.getColumns().size()) {
                        outputSchema.addColumn(this.commonTypeRemap(params.virtualInputs, sources, index).newColumn(columnName));
                    }
                    ((SchemaColumn)currentColumns.get(index)).setName(columnName);
                    ++index;
                }
                break;
            }
            case CUSTOM: {
                outputSchema = new Schema();
                if (params.selectedColumns == null || params.selectedColumns.size() == 0) {
                    throw ErrorContext.iae((String)"Empty list of selected columns");
                }
                HashMap<String, Type> types = new HashMap<String, Type>();
                for (FlowDataset fdSource : sources) {
                    Schema s = fdSource.getMandatory(this.datasetsDAO).getSchema();
                    for (SchemaColumn column : s.columns) {
                        types.put(column.getName(), column.getType());
                    }
                }
                for (String columnName : params.selectedColumns) {
                    Type type = (Type)types.get(columnName);
                    if (type == null) {
                        throw ErrorContext.iaef((String)"Unknown column name: '%s'", (Object)columnName, (Object[])new Object[0]);
                    }
                    outputSchema.addColumn(columnName, (Type)types.get(columnName));
                }
                break;
            }
        }
        if (outputSchema == null) {
            throw ErrorContext.iae((String)"Output schema is null");
        }
        if (params.addOriginColumn) {
            if (StringUtils.isBlank((String)params.originColumnName)) {
                throw ErrorContext.iae((String)"Origin column name is empty");
            }
            outputSchema.addColumn(params.originColumnName, Type.STRING);
        }
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(outputSchema);
        }
        Dataset targetDataset = fdTarget.getMandatory(this.datasetsDAO);
        ManagedDatasetsHelper.doTheUglyPartitioningDance(targetDataset, outputSchema, targetDataset.getSchema());
        return outputSchema;
    }

    private ComplexType commonTypeIndex(List<VStackRecipePayloadParams.InputDesc> virtualInputs, List<FlowDataset> sources, int index) throws IOException {
        ComplexType commonType = null;
        for (VStackRecipePayloadParams.InputDesc virtualInput : virtualInputs) {
            Schema schema = sources.get(virtualInput.index).getMandatory(this.datasetsDAO).getSchema();
            List columns = schema.getColumns();
            if (index >= columns.size()) continue;
            ComplexType thisType = ComplexType.fromColumn((SchemaColumn)((SchemaColumn)columns.get(index)));
            if (commonType == null) {
                commonType = thisType;
                continue;
            }
            commonType = commonType.commonSuperType(thisType);
        }
        if (commonType == null) {
            return new ComplexType(Type.STRING);
        }
        return commonType;
    }

    private ComplexType commonTypeRemap(List<VStackRecipePayloadParams.InputDesc> virtualInputs, List<FlowDataset> sources, int index) throws IOException {
        ComplexType commonType = null;
        block0: for (VStackRecipePayloadParams.InputDesc virtualInput : virtualInputs) {
            Schema schema = sources.get(virtualInput.index).getMandatory(this.datasetsDAO).getSchema();
            List columns = schema.getColumns();
            if (index >= virtualInput.columnsMatch.size()) continue;
            String targetName = virtualInput.columnsMatch.get(index);
            for (SchemaColumn column : columns) {
                if (!column.getName().equals(targetName)) continue;
                ComplexType thisType = ComplexType.fromColumn((SchemaColumn)column);
                if (commonType == null) {
                    commonType = thisType;
                    continue block0;
                }
                commonType = commonType.commonSuperType(thisType);
                continue block0;
            }
        }
        if (commonType == null) {
            return new ComplexType(Type.STRING);
        }
        return commonType;
    }

    private VStackRecipePayloadParams resolveDatasetsName(VStackRecipePayloadParams params, SerializedRecipe sr) {
        ArrayList<String> datasets = new ArrayList<String>(sr.getFlatInputs().size());
        for (SerializedRecipe.RecipeInput in : sr.getFlatInputs()) {
            AnyLoc loc = AnyLoc.resolveSmart(sr.projectKey, in.ref);
            datasets.add(loc.getFullName());
        }
        if (params.virtualInputs != null) {
            for (VStackRecipePayloadParams.InputDesc vi : params.virtualInputs) {
                if (vi.index < 0 || vi.index >= datasets.size()) {
                    throw ErrorContext.iae((String)("Recipes inputs are incorrect. Input index: " + vi.index));
                }
                vi.name = (String)datasets.get(vi.index);
            }
        }
        return params;
    }

    public VStackRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        VStackRecipePayloadParams params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty params");
        this.expandParams(params, sr.getProjectKey());
        return this.resolveDatasetsName(params, sr);
    }

    private void expandParams(VStackRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        for (VStackRecipePayloadParams.InputDesc vi : params.virtualInputs) {
            FilterDescUtils.expand(vi.preFilter, vc);
        }
        FilterDescUtils.expand(params.postFilter, vc);
    }
}

