/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.ImplicitDependencyRunnableSubgraph;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunner;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.slave.JobKernelAPIClient;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineRunnableSubgraph;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ShortTaskExecutor;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class JobRunner {
    private final Job job;
    private final Set<String> skippedActivityIds;
    @Autowired
    private ScenarioRunContext scenarioRunContext;
    @Autowired
    private JobAuthCtxService authCtxService;
    private final JobKernelAPIClient apiClient;
    private final JobKernelAPIClient apiWaitClient;
    private final GeneralSettingsDAO.GeneralSettings settings;
    private List<ActivityRunner> activeActivityRunners = new ArrayList<ActivityRunner>();
    private volatile boolean abortNotified;
    private APITicketService apiTicketService;
    private static Logger logger = Logger.getLogger((String)"dku.flow.jobrunner");

    public JobRunner(Job job, Set<String> skippedActivityIds, GeneralSettingsDAO.GeneralSettings settings, APITicketService apiTicketService) {
        SpringUtils.getInstance().autowire((Object)this);
        this.apiTicketService = apiTicketService;
        this.job = (Job)Preconditions.checkNotNull((Object)job);
        this.settings = (GeneralSettingsDAO.GeneralSettings)Preconditions.checkNotNull((Object)settings);
        this.skippedActivityIds = (Set)Preconditions.checkNotNull(skippedActivityIds);
        this.apiClient = new JobKernelAPIClient(apiTicketService);
        this.apiWaitClient = new JobKernelAPIClient(apiTicketService);
    }

    private JobActivity getNextActivityRec(JobActivity root) {
        return this.getNextActivityRec(root, new HashSet<String>());
    }

    private JobActivity getNextActivityRec(JobActivity root, Set<String> alreadyVisited) {
        if (alreadyVisited.contains(root.id())) {
            return null;
        }
        alreadyVisited.add(root.id());
        int doneDependencies = 0;
        int prunedDependencies = 0;
        for (JobActivity dependent : root.dependencies) {
            if (dependent.state == ActivityState.DONE || dependent.state == ActivityState.SKIPPED) {
                ++doneDependencies;
            }
            if (!dependent.pruned) continue;
            ++prunedDependencies;
        }
        if (doneDependencies + prunedDependencies == root.dependencies.size()) {
            if (root.state == ActivityState.NOT_STARTED) {
                return root;
            }
        } else {
            for (JobActivity dependent : root.dependencies) {
                JobActivity child;
                if (dependent.state != ActivityState.NOT_STARTED || dependent.pruned || (child = this.getNextActivityRec(dependent, alreadyVisited)) == null) continue;
                return child;
            }
        }
        return null;
    }

    JobActivity getNextActivityToRun() {
        JobActivity ja = this.getNextActivityRec(this.job.topLevelActivity);
        if (ja == null) {
            return null;
        }
        if (ja.getSubgraph() == null) {
            return null;
        }
        return ja;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runActivity(TransactionRef transaction, ActivityRunner arunner) {
        JobActivity activity = arunner.getActivity();
        assert (activity.state == ActivityState.RUNNING);
        activity.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.PREPARING, null, null);
        logger.info((Object)"Run activity");
        SpringUtils.getInstance().autowire((Object)arunner);
        try {
            this.apiClient.onActivityStarted(this.job.def, activity.getStatus());
            FutureAborter.init();
            ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forJobActivity((AuthCtx)this.authCtxService.getAuthCtx(), (String)JobContext.getCurrentJobContext().projectKey, (String)JobContext.getCurrentJobContext().jobId, (String)activity.id());
            JobActivity.ActivityRunSummary currentActivitySummary = JobContext.getCurrentActivitySummary();
            if (activity.getSubgraph() instanceof RecipeRunnableSubgraph) {
                cruContext.activityType = "recipe";
                cruContext.recipeType = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel().type;
                cruContext.recipeName = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel().name;
                currentActivitySummary.activityType = cruContext.recipeType;
            } else if (activity.getSubgraph() instanceof SparkPipelineRunnableSubgraph) {
                currentActivitySummary.activityType = "spark-pipeline";
                cruContext.activityType = "spark-pipeline";
            } else if (activity.getSubgraph() instanceof ImplicitDependencyRunnableSubgraph) {
                currentActivitySummary.activityType = "implicit-link";
                cruContext.activityType = "implicit-link";
            } else if (activity.getSubgraph() instanceof SqlPipelineRunnableSubgraph) {
                currentActivitySummary.activityType = "sql-pipeline";
                cruContext.activityType = "sql-pipeline";
            }
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
            boolean bl = arunner.runActivity(transaction);
            return bl;
        }
        catch (Throwable t) {
            assert (activity.state == ActivityState.RUNNING);
            logger.error((Object)"Activity unexpectedly failed", t);
            activity.firstFailure = t;
            activity.stopTimers();
            activity.endTime = System.currentTimeMillis();
            activity.runSummary.totalTime = activity.endTime - activity.startTime;
            boolean bl = false;
            return bl;
        }
        finally {
            FutureAborter.deinit();
            CurrentComputeResourceUsageContext.clear();
        }
    }

    public synchronized ActivityRunner getActivityRunner(String activityId) {
        for (ActivityRunner runner : this.activeActivityRunners) {
            if (!runner.getActivity().id().equals(activityId)) continue;
            return runner;
        }
        throw new IllegalArgumentException("Activity " + activityId + " is not running currently");
    }

    public boolean isAborted() {
        return this.abortNotified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAbort(final RWTransaction sessionTransaction) {
        ArrayList<ActivityRunner> copiedActivityRunners;
        JobRunner jobRunner = this;
        synchronized (jobRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            copiedActivityRunners = new ArrayList<ActivityRunner>(this.activeActivityRunners);
        }
        logger.info((Object)("Notify abort to " + copiedActivityRunners.size() + " activity runner(s)"));
        try {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (final ActivityRunner activityRunner : copiedActivityRunners) {
                futures.add(ShortTaskExecutor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        TransactionContext.attach((TransactionRef)sessionTransaction);
                        JobContext.setJob(JobRunner.this.job.def.projectKey, JobRunner.this.job.def.id, JobRunner.this.job);
                        JobContext.setCurrentActivityInThread(activityRunner.getActivity());
                        try {
                            activityRunner.notifyAbort();
                            activityRunner.getActivity().state = ActivityState.ABORTED;
                        }
                        finally {
                            TransactionContext.detach((TransactionRef)sessionTransaction);
                        }
                        return null;
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    logger.error((Object)"Unable to abort activity", e.getCause());
                }
                catch (Throwable e) {
                    logger.error((Object)"Unable to abort activity", e);
                }
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Problem during abort of sub-tasks", t);
        }
        try {
            this.apiClient.statusUpdate(this.job.def.projectKey, this.job.def.id, this.job.getStatus());
        }
        catch (IOException e) {
            logger.error((Object)"Unable to send status to master", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String acquireBuildPermit(JobActivity jobActivity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void runJob(TransactionRef transaction) throws Exception {
        TransactionContext.attach((TransactionRef)transaction);
        ArrayList<ActivityExecutorThread> threads = new ArrayList<ActivityExecutorThread>();
        int nThreads = Math.max(this.settings.maxRunningActivitiesPerJob, 3);
        logger.info((Object)("Creating " + nThreads + " activity runner thread(s)."));
        for (int i = 0; i < nThreads; ++i) {
            ActivityExecutorThread activityExecutorThread = new ActivityExecutorThread();
            activityExecutorThread.transaction = transaction;
            threads.add(activityExecutorThread);
        }
        logger.info((Object)"Starting activity executor threads");
        for (Thread thread : threads) {
            thread.start();
        }
        logger.info((Object)"Waiting for activity executor threads");
        for (Thread thread : threads) {
            thread.join();
        }
        logger.info((Object)"All activity executor threads joined, end of job");
        logger.info((Object)"JOB IS COMPLETE");
        assert (this.activeActivityRunners.size() == 0);
    }

    class ActivityExecutorThread
    extends Thread {
        TransactionRef transaction;

        ActivityExecutorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransactionContext.attach((TransactionRef)this.transaction);
            Thread.currentThread().setName("ActivityExecutor-" + Thread.currentThread().getId());
            while (true) {
                JobActivity activity;
                ActivityRunner arunner = null;
                JobRunner jobRunner = JobRunner.this;
                synchronized (jobRunner) {
                    activity = JobRunner.this.getNextActivityToRun();
                    if (activity == null) {
                        if (JobRunner.this.activeActivityRunners.size() == 0) {
                            logger.debug((Object)"No activity is running, and none is available --> End of ActivityExecutorThread");
                            return;
                        }
                    } else {
                        assert (activity.state == ActivityState.NOT_STARTED);
                        arunner = new ActivityRunner(JobRunner.this.job.def, activity, JobRunner.this.apiTicketService);
                        logger.info((Object)("About to run " + activity.id()));
                        JobRunner.this.activeActivityRunners.add(arunner);
                        if (JobRunner.this.skippedActivityIds.contains(activity.id())) {
                            logger.info((Object)"--> But it's skipped");
                            activity.state = ActivityState.SKIPPED;
                        } else if (activity.skipExplicitOrWriteProtected) {
                            logger.info((Object)"--> But it should be skipped because one output is marked as explicitly built or write protected.");
                            activity.state = ActivityState.SKIPPED;
                        } else {
                            activity.state = ActivityState.WAITING;
                            activity.startTime = System.currentTimeMillis();
                        }
                        if (JobRunner.this.abortNotified) {
                            logger.info((Object)"--> But the job has been aborted");
                            activity.state = ActivityState.ABORTED;
                        }
                    }
                }
                ActivityDoneContext adsc = new ActivityDoneContext();
                adsc.jobProjectKey = JobRunner.this.job.def.projectKey;
                adsc.jobId = JobRunner.this.job.def.id;
                adsc.scenarioRun = JobRunner.this.scenarioRunContext.getScenarioRun();
                adsc.stepRun = JobRunner.this.scenarioRunContext.getStepRun();
                if (arunner == null) {
                    DKUtils.unsafeSleep((long)100L);
                    continue;
                }
                activity = arunner.getActivity();
                if (activity.state == ActivityState.SKIPPED) {
                    JobRunner jobRunner2 = JobRunner.this;
                    synchronized (jobRunner2) {
                        JobRunner.this.activeActivityRunners.remove(arunner);
                    }
                }
                if (activity.state == ActivityState.WAITING) {
                    JobContext.setCurrentActivityInThread(activity);
                    ErrorContext.pushWithNDC((String)("running " + activity.id()));
                    activity.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.PREPARING, null, null);
                    try {
                        String permitId = JobRunner.this.acquireBuildPermit(activity);
                        if (permitId == null) {
                            JobRunner jobRunner3 = JobRunner.this;
                            synchronized (jobRunner3) {
                                activity.state = ActivityState.FAILED;
                                JobRunner.this.activeActivityRunners.remove(arunner);
                            }
                            try {
                                logger.debug((Object)"Signaling end of activity to backend");
                                JobRunner.this.apiClient.onActivityDone(JobRunner.this.job.def, activity.getStatus(), adsc);
                                logger.debug((Object)"Done signaling end of activity to backend");
                            }
                            catch (Exception e) {
                                logger.error((Object)"Failed to notify end of activity", (Throwable)e);
                            }
                        }
                        activity.state = ActivityState.RUNNING;
                        logger.debug((Object)"Calling runActivity");
                        boolean success = JobRunner.this.runActivity(this.transaction, arunner);
                        logger.debug((Object)("runActivity terminated, success=" + success));
                        assert (activity.state == ActivityState.RUNNING);
                        JobRunner jobRunner4 = JobRunner.this;
                        synchronized (jobRunner4) {
                            activity.state = success ? ActivityState.DONE : ActivityState.FAILED;
                            JobRunner.this.activeActivityRunners.remove(arunner);
                        }
                        activity.runSummary.state = activity.state.toString();
                        SerializedJobActivityStatus status = activity.getStatus();
                        if (status.firstFailure != null && status.firstFailure.code != null) {
                            activity.runSummary.failureCode = status.firstFailure.code;
                        } else if (status.firstFailure != null) {
                            activity.runSummary.failureCode = status.firstFailure.errorType;
                        }
                        activity.runSummary.activityId = activity.id();
                        JobRunner.this.job.runSummary.withActivity(activity);
                        try {
                            logger.debug((Object)"Signaling end of activity to backend");
                            JobRunner.this.apiClient.onActivityDone(JobRunner.this.job.def, activity.getStatus(), adsc);
                            logger.debug((Object)"Done signaling end of activity to backend");
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed to notify end of activity", (Throwable)e);
                        }
                        try {
                            JobRunner.this.apiClient.releaseBuildPermit(JobRunner.this.job, permitId);
                        }
                        catch (IOException e) {
                            logger.error((Object)"Failed to release build permit", (Throwable)e);
                        }
                    }
                    finally {
                        ErrorContext.popWithNDC();
                        JobContext.setCurrentActivityInThread(null);
                    }
                    continue;
                }
                try {
                    logger.debug((Object)"Signaling end of activity to backend");
                    JobRunner.this.apiClient.onActivityDone(JobRunner.this.job.def, activity.getStatus(), adsc);
                    logger.debug((Object)"Done signaling end of activity to backend");
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to notify end of activity", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    public static class ActivityDoneContext {
        public String jobProjectKey;
        public String jobId;
        public ScenarioRun scenarioRun;
        public StepRun stepRun;
    }
}

