/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner;

import com.dataiku.dip.dataflow.ImplicitDependencyRunnableSubgraph;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializedJob {
    public List<String> rootIds = new ArrayList<String>();
    public Map<String, SerializedJobActivity> allActivities = new HashMap<String, SerializedJobActivity>();

    public SerializedJob(JobActivity rootActivity) {
        if (rootActivity.getSubgraph() instanceof AbstractPipelineRunnableSubgraph || rootActivity.getSubgraph() instanceof RecipeRunnableSubgraph) {
            SerializedJob.fillFromActivity(this, rootActivity);
        } else if (rootActivity.getSubgraph() instanceof ImplicitDependencyRunnableSubgraph) {
            DKULogger.getLogger((String)"dip.job").info((Object)"Job root activity is an implicit dependency");
            SerializedJob.fillFromDependencies(this, rootActivity);
        } else if (rootActivity.getSubgraph() == null) {
            SerializedJob.fillFromDependencies(this, rootActivity);
        } else {
            DKULogger.getLogger((String)"dip.job").warn((Object)("Unexpected job root activity : " + String.valueOf(rootActivity.getSubgraph())));
            SerializedJob.fillFromDependencies(this, rootActivity);
        }
    }

    private static void fillFromActivity(SerializedJob serializedJob, JobActivity rootActivity) {
        serializedJob.rootIds.add(rootActivity.id());
        serializedJob.addAllRec(rootActivity);
    }

    private static void fillFromDependencies(SerializedJob serializedJob, JobActivity rootActivity) {
        for (JobActivity ja : rootActivity.dependencies) {
            serializedJob.rootIds.add(ja.id());
            serializedJob.addAllRec(ja);
        }
    }

    private void addAllRec(JobActivity ja) {
        if (this.allActivities.containsKey(ja.id())) {
            return;
        }
        this.allActivities.put(ja.id(), ja.getSerialized());
        for (JobActivity dep : ja.dependencies) {
            this.addAllRec(dep);
        }
    }
}

