/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.kernel.master.ActivityRunRequest;
import com.dataiku.dip.dataflow.kernel.master.locking.AcquirabilityTestResult;
import com.dataiku.dip.dataflow.kernel.master.locking.SchedulingConstraintPolicy;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ActivityRunLimiter
implements SchedulingConstraintPolicy<ActivityRunRequest> {
    private static final String KEY_PROJECT = "project/";
    private static final String KEY_RECIPE_TYPE = "recipeType/";
    private static final String KEY_USER = "user/";
    private static final String KEY_TAG = "tag/";
    private static Logger logger = Logger.getLogger((String)"dku.jobs.limiter");
    private final int maxRunningActivitiesPerJob;
    private final int maxRunningActivities;
    private final Map<String, Integer> slotsPerConnection = new HashMap<String, Integer>();
    private final Map<String, Integer> slotsPerResourceKey = new HashMap<String, Integer>();

    public ActivityRunLimiter(Map<String, DSSConnection> connections, GeneralSettingsDAO.GeneralSettings generalSettings) {
        Preconditions.checkNotNull((Object)generalSettings);
        this.maxRunningActivities = generalSettings.maxRunningActivities;
        this.maxRunningActivitiesPerJob = generalSettings.maxRunningActivitiesPerJob;
        for (DSSConnection connection : connections.values()) {
            if (connection.maxActivities <= 0) continue;
            this.slotsPerConnection.put(connection.name, connection.maxActivities);
        }
        for (SimpleKeyValue entry : generalSettings.maxRunningActivitiesPerKey) {
            if (!Strings.isNullOrEmpty((String)entry.value)) {
                try {
                    int limit = Integer.parseInt(entry.value);
                    if (limit <= 0) continue;
                    this.slotsPerResourceKey.put(entry.key, limit);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Ignoring limit for key '" + entry.key + "' because its value cannot be parsed as a valid integer: " + entry.value));
                }
                continue;
            }
            logger.warn((Object)("Ignoring limit for key '" + entry.key + "' because its value is empty."));
        }
    }

    @Override
    public SchedulingConstraintPolicy.ConstraintChecker<ActivityRunRequest> newConstraintChecker(final List<ActivityRunRequest> acquiredPermits) {
        final HashMap<String, Integer> remainingSlotsPerConnection = new HashMap<String, Integer>(this.slotsPerConnection);
        for (ActivityRunRequest activityRunRequest : acquiredPermits) {
            for (String string : activityRunRequest.involvedConnections) {
                ActivityRunLimiter.decrementSlot(remainingSlotsPerConnection, string);
            }
        }
        final HashMap<String, Integer> remainingSlotsPerResourceKey = new HashMap<String, Integer>(this.slotsPerResourceKey);
        for (Object resourceKey : remainingSlotsPerResourceKey.keySet()) {
            for (ActivityRunRequest permit : acquiredPermits) {
                if (!ActivityRunLimiter.match(permit, (String)resourceKey)) continue;
                ActivityRunLimiter.decrementSlot(remainingSlotsPerResourceKey, (String)resourceKey);
            }
        }
        final HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (ActivityRunRequest activityRunRequest : acquiredPermits) {
            this.incrementSlot(hashMap, activityRunRequest.getJobFullId());
        }
        final HashMap<String, Integer> usedSlotsPerRecipe = new HashMap<String, Integer>();
        for (ActivityRunRequest permit : acquiredPermits) {
            for (ActivityRunRequest.Recipe recipe : permit.recipes) {
                this.incrementSlot(usedSlotsPerRecipe, recipe.getFullName());
            }
        }
        return new SchedulingConstraintPolicy.ConstraintChecker<ActivityRunRequest>(){

            @Override
            public AcquirabilityTestResult canBeAcquired(ActivityRunRequest candidatePermit) {
                Integer cnt;
                if (ActivityRunLimiter.this.maxRunningActivities > 0 && acquiredPermits.size() >= ActivityRunLimiter.this.maxRunningActivities) {
                    return AcquirabilityTestResult.no("The global limit of " + ActivityRunLimiter.this.maxRunningActivities + " running activities has been reached.");
                }
                if (ActivityRunLimiter.this.maxRunningActivitiesPerJob > 0 && (cnt = (Integer)hashMap.get(candidatePermit.getJobFullId())) != null && cnt >= ActivityRunLimiter.this.maxRunningActivitiesPerJob) {
                    return AcquirabilityTestResult.no("The per-job limit of " + ActivityRunLimiter.this.maxRunningActivitiesPerJob + " running activities has been reached.");
                }
                for (String string : candidatePermit.involvedConnections) {
                    Integer val = (Integer)remainingSlotsPerConnection.get(string);
                    if (val == null || val > 0) continue;
                    return AcquirabilityTestResult.no("The limit of " + String.valueOf(ActivityRunLimiter.this.slotsPerConnection.get(string)) + " running activities for connection \"" + string + "\" has been reached.");
                }
                for (ActivityRunRequest.Recipe recipe : candidatePermit.recipes) {
                    Integer cnt2;
                    if (recipe.maxRunningActivities <= 0 || (cnt2 = (Integer)usedSlotsPerRecipe.get(recipe.getFullName())) == null || cnt2 < recipe.maxRunningActivities) continue;
                    return AcquirabilityTestResult.no("The limit of " + recipe.maxRunningActivities + " running activities for recipe \"" + recipe.getFullName() + "\" has been reached.");
                }
                for (Map.Entry entry : remainingSlotsPerResourceKey.entrySet()) {
                    String resourceKey;
                    Integer remainingSlot = (Integer)entry.getValue();
                    if (remainingSlot == null || remainingSlot > 0 || !ActivityRunLimiter.match(candidatePermit, resourceKey = (String)entry.getKey())) continue;
                    int separatorIndex = resourceKey.indexOf(47);
                    String item = separatorIndex > 0 ? resourceKey.substring(0, separatorIndex) + " \"" + resourceKey.substring(separatorIndex + 1) + "\"" : "key \"" + resourceKey + "\"";
                    return AcquirabilityTestResult.no("The limit of " + String.valueOf(ActivityRunLimiter.this.slotsPerResourceKey.get(resourceKey)) + " running activities for " + item + " has been reached.");
                }
                return AcquirabilityTestResult.yes();
            }
        };
    }

    private static boolean match(ActivityRunRequest request, String resourceKey) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)resourceKey);
        if (resourceKey.startsWith(KEY_PROJECT)) {
            return resourceKey.substring(KEY_PROJECT.length()).equals(request.projectKey);
        }
        if (resourceKey.startsWith(KEY_RECIPE_TYPE)) {
            return request.recipeTypes != null && request.recipeTypes.contains(resourceKey.substring(KEY_RECIPE_TYPE.length()));
        }
        if (resourceKey.startsWith(KEY_USER)) {
            return resourceKey.substring(KEY_USER.length()).equals(request.userIdentifier);
        }
        if (resourceKey.startsWith(KEY_TAG)) {
            return request.tags != null && request.tags.contains(resourceKey.substring(KEY_TAG.length()));
        }
        return request.resourceKeys != null && request.resourceKeys.contains(resourceKey);
    }

    private void incrementSlot(Map<String, Integer> slots, String key) {
        Integer count = slots.get(key);
        if (count == null) {
            count = 0;
        }
        slots.put(key, count + 1);
    }

    private static void decrementSlot(Map<String, Integer> slots, String key) {
        Integer count;
        if (key != null && (count = slots.get(key)) != null) {
            slots.put(key, count - 1);
        }
    }
}

