/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.postactions;

import com.dataiku.dip.dataflow.kernel.master.postactions.PostJobAction;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.server.services.ProjectsUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import java.io.File;

public class CompressLocalconfig
extends PostJobAction {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.jobs.postactions.localconfig");

    public CompressLocalconfig(String projectKey, String jobId) {
        super(projectKey, jobId);
    }

    @Override
    public void run() throws Exception {
        logger.debug((Object)("Executing post-action " + this.getClass().getSimpleName()));
        Params p = ProjectsUtils.getProjectDKUPropertiesAsParamsWithSystemOverrideEvenIfProjectDoesNotExist_AutoTXN(this.projectKey);
        File jobFolder = FlowJobUtils.jobFolder(false, this.projectKey, this.jobId);
        File localconfigFolder = new File(jobFolder, FlowJobUtils.LOCALCONFIG_FOLDER_NAME);
        if (!localconfigFolder.isDirectory()) {
            logger.trace((Object)"No localconfig folder to compress, skipping");
            return;
        }
        if (p.getBoolParam("dku.jobs.postActions.compressLocalConfig.enabled", true)) {
            long minSizeForCompressionKB = p.getLongParam("dku.jobs.postActions.compressLocalConfig.minSizeForCompressionKB", 2000L);
            try {
                ZipUnzipDir.zipDirectoryIfLargerThanSize(localconfigFolder, minSizeForCompressionKB);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to zip localconfig folder", (Throwable)e);
            }
        } else {
            logger.info((Object)"Not compressing job localconfig (requested by project property)");
        }
    }
}

