/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.window.WindowPartitionSlider;
import com.dataiku.dip.datalayer.window.WindowSlider;
import com.dataiku.dip.datalayer.window.Windower;
import java.io.IOException;

public class RowsDeltaWindowSlider
extends WindowPartitionSlider {
    private final long delta;
    private final boolean isLowerBoundary;
    private final boolean isUpperBoundary;
    private long wantedIndex;

    public RowsDeltaWindowSlider(SortedRowsIterator it, long delta, boolean isLowerBoundary, boolean isUpperBoundary) {
        super(it);
        this.delta = delta;
        this.isLowerBoundary = isLowerBoundary;
        this.isUpperBoundary = isUpperBoundary;
    }

    @Override
    public void position(RowAndSortMark at, Windower.WindowPartition partition, RowAndSortMark windowStart) throws IOException {
        super.position(at, partition, windowStart);
        this.wantedIndex = windowStart == null ? partition.last.mark.index + 1L : windowStart.mark.index + this.delta;
    }

    @Override
    public void slide(RowAndSortMark to, WindowSlider.SlideCallback callBefore, WindowSlider.SlideCallback callAfter) {
        RowAndSortMark oldCurrent = this.current();
        this.wantedIndex = to.mark.index + this.delta;
        RowAndSortMark newCurrent = this.current();
        if (oldCurrent == null && newCurrent != null && callAfter != null && this.current != null) {
            callAfter.handle(this.current);
        }
        long targetIndex = this.wantedIndex;
        targetIndex = Math.min(this.partition.last.mark.index, targetIndex);
        targetIndex = Math.max(this.partition.first.mark.index, targetIndex);
        while (!this.atEnd && this.current != null && this.current.mark.index < targetIndex) {
            if (callBefore != null && this.current != null) {
                callBefore.handle(this.current);
            }
            this.current = this.it.next();
            oldCurrent = newCurrent;
            newCurrent = this.current();
            if (callAfter == null || this.current == null) continue;
            callAfter.handle(this.current);
        }
        if (oldCurrent != null && newCurrent == null && callBefore != null && this.current != null) {
            callBefore.handle(this.current);
        }
    }

    @Override
    public RowAndSortMark current() {
        if (this.atEnd || this.current == null) {
            return null;
        }
        if (this.wantedIndex == this.current.mark.index) {
            return this.current;
        }
        if (this.isLowerBoundary && this.wantedIndex < this.current.mark.index) {
            return this.current;
        }
        if (this.isUpperBoundary && this.wantedIndex > this.current.mark.index) {
            return this.current;
        }
        return null;
    }
}

