/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.metrics.DisplayedChecksSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class DataQualityRuleSet {
    public boolean monitor = false;
    public List<DataQualityRule> checks = Lists.newArrayList();
    public DisplayedChecksSet displayedState = new DisplayedChecksSet();

    public void ensureRulesIdsUsingCheckLegacyIds(boolean allowDuplicates) {
        HashSet<String> usedIds = new HashSet<String>();
        for (DataQualityRule rule : this.getRules()) {
            String newId = rule.ensureIdUsingCheckLegacyId(usedIds);
            if (allowDuplicates) continue;
            usedIds.add(newId);
        }
    }

    public List<DataQualityRule> getRules() {
        return this.checks;
    }

    public List<DataQualityRule> getEnabledRules() {
        return this.checks.stream().filter(r -> r.enabled).collect(Collectors.toList());
    }

    public List<DataQualityRule> getAutoRunRules() {
        return this.checks.stream().filter(r -> r.autoRun).collect(Collectors.toList());
    }

    public void addRule(DataQualityRule rule) {
        this.checks.add(rule);
    }

    public DataQualityRuleSet withRules(List<DataQualityRule> rules) {
        this.checks = new ArrayList<DataQualityRule>(rules);
        return this;
    }

    public DataQualityRuleSet withRules(DataQualityRule ... rules) {
        return this.withRules(Arrays.asList(rules));
    }

    public List<String> getEnabledRuleIds() {
        return this.getEnabledRules().stream().map(DataQualityRule::getId).collect(Collectors.toList());
    }
}

