/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.ReadMetricValueHelper;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInRangeMetric;
import com.dataiku.dip.dataquality.rules.AbstractColumnsInRangeRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.DatasetCheckContext;
import com.dataiku.dip.security.AuthCtx;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ValuesInRangeRule
extends AbstractColumnsInRangeRule {
    public static final String TYPE = "ValuesInRangeRule";

    private ValuesInRangeMetric getMetricForOneColumn(String column) {
        return new ValuesInRangeMetric(this.getId(), column, this.minimum, this.maximum, this.minimumEnabled, this.maximumEnabled, this.softMinimum, this.softMaximum, this.softMinimumEnabled, this.softMaximumEnabled);
    }

    @Override
    public String getMetricsIdForOneColumn(String column) {
        return this.getMetricForOneColumn((String)column).id;
    }

    @Override
    public List<Metric> getMetricsForOneColumn(String column) {
        return List.of(this.getMetricForOneColumn(column));
    }

    @Override
    protected AbstractCheckContext.CheckResult runForOneColumn(String column, AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        SchemaColumn fullColumn = ((DatasetCheckContext)context).getDataset().getSchema().getColumn(column);
        if (fullColumn != null && !fullColumn.getType().isNumeric()) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.WARNING, "Cannot check: " + String.valueOf(fullColumn.getType()) + " is not numeric");
        }
        ValuesInRangeMetric metric = this.getMetricForOneColumn(column);
        try {
            Map<String, Long> result = ReadMetricValueHelper.readLongMapMetricsValue(context, metric.id);
            long hard = result.get("hard");
            long soft = result.get("soft");
            if (hard > 0L) {
                return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, hard + " values outside range found");
            }
            if (soft > 0L) {
                return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.WARNING, soft + " values outside soft range found");
            }
        }
        catch (ReadMetricValueHelper.ReadMetricError e) {
            return new AbstractCheckContext.CheckResult(e.outcome, e.message);
        }
        return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, "All column values within specified range");
    }

    @Override
    @Nullable
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        ArrayList<Metric> requiredMetrics = new ArrayList<Metric>();
        for (String column : this.getColumns()) {
            SchemaColumn schemaColumn = dataset.getSchema().getColumn(column);
            if (schemaColumn == null || !schemaColumn.getType().isNumeric()) continue;
            requiredMetrics.add(this.getMetricForOneColumn(column));
        }
        return this.checkComputedMetricsPresent(requiredMetrics, computedMetrics);
    }

    @Override
    public void accept(FailedRowsExtractRuleVisitor visitor) {
        visitor.visit(this);
    }
}

