/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Stopwatch;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.math.RandomUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ElasticSearchOutput
implements Output {
    private final ElasticSearchIndex esIndex;
    private final Partition targetPartition;
    private final boolean onPartition;
    private final WarningsContext wc;
    private final Map<String, DimensionValue> dimValues;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.elasticsearch.output");

    private static String jsonQuote(String value) {
        return JSONObject.quote((String)value);
    }

    public ElasticSearchOutput(ElasticSearchIndex esIndex, @Nullable Partition targetPartition, WarningsContext wc) {
        this.esIndex = esIndex;
        this.targetPartition = targetPartition;
        boolean bl = this.onPartition = targetPartition != null && targetPartition.getScheme() != null && targetPartition.getScheme().isPartitioned();
        if (this.onPartition) {
            assert (targetPartition.isComplete());
            this.dimValues = targetPartition.getDimensionValues();
        } else {
            this.dimValues = null;
        }
        this.wc = wc;
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException {
        return new ElasticSearchOutputWriter(mode == Output.WriteMode.APPEND);
    }

    public class ElasticSearchOutputWriter
    extends OutputWriter {
        private ColumnFactory scf;
        private final String bulkAddress;
        private final String targetIndex;
        private final StringBuilder sb = new StringBuilder();
        private final String indexCommand;
        private final boolean append;
        private long targetInitialCount = 0L;
        private long count;

        public ElasticSearchOutputWriter(boolean append) throws IOException {
            this.bulkAddress = ElasticSearchOutput.this.esIndex.address + "_bulk";
            this.targetIndex = ElasticSearchOutput.this.esIndex.getPartitionIndex(ElasticSearchOutput.this.targetPartition);
            this.append = append;
            try {
                JSONObject indexObject = new JSONObject().put("_index", (Object)this.targetIndex);
                if (ElasticSearchOutput.this.esIndex.dialect.hasType) {
                    indexObject.put("_type", (Object)ElasticSearchOutput.this.esIndex.type);
                }
                this.indexCommand = new JSONObject().put("index", (Object)indexObject).toString() + "\n";
            }
            catch (JSONException e) {
                throw new IOException("JSON error", e);
            }
        }

        public void init(ColumnFactory cf) throws Exception {
            this.scf = cf;
            if (ElasticSearchOutput.this.esIndex.dataset.isManaged()) {
                if (!this.append) {
                    this.deleteIndex(this.targetIndex);
                }
                ElasticSearchOutput.this.esIndex.createIndex(this.targetIndex, ElasticSearchOutput.this.onPartition ? ElasticSearchOutput.this.esIndex.rootIndex : null);
                ElasticSearchOutput.this.esIndex.updateMapping(this.targetIndex);
            } else if (!this.append) {
                ElasticSearchOutput.this.esIndex.deleteDocs(this.targetIndex);
            }
            if (this.append && !ElasticSearchOutput.this.esIndex.supportsFlushAndRefresh()) {
                this.targetInitialCount = ElasticSearchOutput.this.esIndex.count(this.targetIndex);
            }
        }

        private void deleteIndex(String targetIndex) throws Exception {
            if (!ElasticSearchOutput.this.esIndex.supportsConcurrentDeleteIndex() && ElasticSearchOutput.this.esIndex.partitioned) {
                long waitDelay = RandomUtils.nextLong() % (ElasticSearchOutput.this.esIndex.concurrentDeleteDelayMs * 3L);
                int i = 0;
                while ((long)i < ElasticSearchOutput.this.esIndex.maxRetriesOnDeleteIndex) {
                    try {
                        logger.debug((Object)("Waiting for " + waitDelay + "ms before deleting index " + targetIndex));
                        Thread.sleep(waitDelay);
                        ElasticSearchOutput.this.esIndex.deleteIndex(targetIndex);
                        return;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to delete index " + targetIndex + " (" + (ElasticSearchOutput.this.esIndex.maxRetriesOnDeleteIndex - (long)i) + " retries left): " + e.getMessage()));
                        waitDelay = RandomUtils.nextLong() % ElasticSearchOutput.this.esIndex.concurrentDeleteDelayMs + ElasticSearchOutput.this.esIndex.concurrentDeleteDelayMs;
                        ++i;
                    }
                }
                throw new Exception("Index " + targetIndex + " could not be deleted properly");
            }
            ElasticSearchOutput.this.esIndex.deleteIndex(targetIndex);
        }

        public void emitRow(Row row) throws Exception {
            this.sb.append(this.indexCommand);
            JSONObject valObj = ElasticSearchUtils.getElasticSearchValue(ElasticSearchOutput.this.esIndex.dataset, this.scf, row);
            if (ElasticSearchOutput.this.onPartition) {
                for (Map.Entry<String, DimensionValue> val : ElasticSearchOutput.this.dimValues.entrySet()) {
                    String value = ElasticSearchUtils.getPartitionValue(val.getValue());
                    valObj.put(val.getKey(), (Object)value);
                }
            }
            this.sb.append(valObj).append('\n');
            ++this.count;
            if (this.count % ElasticSearchOutput.this.esIndex.frameSize == 0L) {
                this.pushWithRetry();
            }
        }

        public void lastRowEmitted() throws Exception {
            logger.info((Object)("Last row emitted. Count=" + this.count));
            if (this.count != 0L) {
                this.pushWithRetry();
            }
            if (ElasticSearchOutput.this.esIndex.supportsFlushAndRefresh()) {
                ElasticSearchOutput.this.esIndex.refreshAndFlush(this.targetIndex, false);
            } else {
                this.awaitRows(this.targetInitialCount + this.count, ElasticSearchOutput.this.targetPartition, ElasticSearchOutput.this.wc);
            }
        }

        public long writtenBytes() throws IOException {
            return 0L;
        }

        public void cancel() throws Exception {
        }

        private void pushWithRetry() throws Exception {
            if (this.sb.length() == 0) {
                logger.info((Object)"Nothing to send to ElasticSearch");
                return;
            }
            if (ElasticSearchOutput.this.esIndex.supportsFlushAndRefresh()) {
                this.push();
            } else {
                Stopwatch stopwatch = Stopwatch.createStarted();
                while (stopwatch.elapsed(TimeUnit.MILLISECONDS) <= ElasticSearchOutput.this.esIndex.refreshWaitMaxDelayMs) {
                    try {
                        this.push();
                        break;
                    }
                    catch (Exception e) {
                        logger.warn((Object)e.getMessage());
                        Thread.sleep(ElasticSearchOutput.this.esIndex.refreshWaitDelayMs);
                    }
                }
            }
            this.sb.setLength(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void push() throws IOException {
            logger.infoV("Sending rows to ElasticSearch (total=%d) with address %s [%s/%s]", new Object[]{this.count, ElasticSearchOutput.this.esIndex.address, this.targetIndex, ElasticSearchOutput.this.esIndex.typeUrl});
            HttpPost put = new HttpPost(this.bulkAddress);
            put.setEntity((HttpEntity)new StringEntity(this.sb.toString(), ElasticSearchIndex.REQ_CONTENT_TYPE));
            HttpResponse resp = ElasticSearchOutput.this.esIndex.execute((HttpUriRequest)put, false, "Send bulk failed", new int[0]);
            String tresp = null;
            try {
                tresp = ElasticSearchUtils.tryToGetString(resp.getEntity().getContent());
                JSONObject jresp = new JSONObject(tresp);
                Object errors = jresp.opt("errors");
                if (errors != null && (errors.equals(true) || errors.equals("true"))) {
                    if (ElasticSearchOutput.this.wc != null) {
                        ElasticSearchOutput.this.wc.addWarning(WarningsContext.WarningType.OUTPUT_DATA_ELASTICSEARCH_ERROR, "Errors encountered while sending to ElasticSearch: " + tresp, logger);
                    } else {
                        logger.warn((Object)("Errors encountered while sending to ElasticSearch: " + tresp));
                    }
                } else {
                    logger.info((Object)"Sent with success");
                }
            }
            catch (JSONException e) {
                logger.warn((Object)("Failed to parse ElasticSearch response " + tresp), (Throwable)e);
            }
            finally {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
        }

        private void awaitRows(long rowsPushed, @Nullable Partition partition, WarningsContext warningsContext) throws Exception {
            Stopwatch stopwatch = Stopwatch.createStarted();
            long countReported = ElasticSearchOutput.this.esIndex.count(partition);
            while (countReported < rowsPushed && stopwatch.elapsed(TimeUnit.MILLISECONDS) <= ElasticSearchOutput.this.esIndex.refreshWaitMaxDelayMs) {
                logger.debug((Object)("Waiting for records to be indexed: " + countReported + " / " + rowsPushed));
                Thread.sleep(ElasticSearchOutput.this.esIndex.refreshWaitDelayMs);
                countReported = ElasticSearchOutput.this.esIndex.count(partition);
            }
            if (countReported < rowsPushed) {
                String message = "Some of the pushed rows are not indexed yet: " + countReported + "/" + rowsPushed;
                if (warningsContext != null) {
                    warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_COUNT_MISMATCH, message, logger);
                } else {
                    logger.warn((Object)message);
                }
            }
        }
    }
}

