/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FSDatasetUtils {
    private static final Pattern SPARK_CHECKPOINT_FILE = Pattern.compile("\\b_spark_(checkpoint|metadata)\\b");

    public static boolean isBadFile(String name) {
        return FSDatasetUtils.isBadFile(name, false);
    }

    public static boolean isBadFile(String name, boolean allowHiddenFiles) {
        if (name.equals("Thumbs.db")) {
            return true;
        }
        if (name.equals("Icon?")) {
            return true;
        }
        if (name.equals("ehthumbs.db")) {
            return true;
        }
        if (name.endsWith(".DS_Store")) {
            return true;
        }
        if (name.endsWith(".DSStore")) {
            return true;
        }
        if (name.endsWith("~")) {
            return true;
        }
        if (name.endsWith(".lock")) {
            return true;
        }
        if (allowHiddenFiles) {
            if (".".equals(name)) {
                return true;
            }
            if ("..".equals(name)) {
                return true;
            }
        } else {
            if (name.startsWith("_")) {
                return true;
            }
            if (name.startsWith(".")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isBadPath(String name) {
        return SPARK_CHECKPOINT_FILE.matcher(name).find();
    }

    public static InfoMessage.InfoMessages checkDatasetName(String name) {
        String[] chars;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (StringUtils.isBlank((String)name)) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name is empty");
            return ret;
        }
        if (FSDatasetUtils.isBadFile(name)) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Illegal dataset name");
        }
        if (name.startsWith("_") || name.startsWith(".")) {
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Dataset name should not start with" + name.charAt(0));
        }
        for (String c2 : chars = new String[]{"\\", "/", "*", "?", "\"", "<", ">", "|", ","}) {
            if (!name.contains(c2)) continue;
            ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Dataset name should not contain '%s'", new Object[]{c2});
        }
        return ret;
    }

    public static long totalSize(List<FSPath> paths) {
        long total = 0L;
        for (FSPath p : paths) {
            total += p.getSize();
        }
        return total;
    }

    public static void checkDestPathDoesNotExist(String path, FSPathOrDirectory statToPath) throws CodedIOException {
        if (statToPath != null) {
            FSDatasetUtils.raiseDestPathAlreadyExistsError(path, statToPath.isDirectory);
        }
    }

    public static void checkDestPathDoesNotExist(String path, FSPathOrDirectory statToPath, boolean isDirectory) throws CodedIOException {
        if (statToPath != null && statToPath.isDirectory == isDirectory) {
            FSDatasetUtils.raiseDestPathAlreadyExistsError(path, statToPath.isDirectory);
        }
    }

    public static void checkDestDirectoryDoesNotExist(String path, FSPathOrDirectory statToPath) throws CodedIOException {
        FSDatasetUtils.checkDestPathDoesNotExist(path, statToPath, true);
    }

    public static void checkDestFileDoesNotExist(String path, FSPathOrDirectory statToPath) throws CodedIOException {
        FSDatasetUtils.checkDestPathDoesNotExist(path, statToPath, false);
    }

    public static void raiseDestPathAlreadyExistsError(String path, boolean isDirectory) throws CodedIOException {
        String message = path + " is an existing ";
        message = message + (isDirectory ? "directory." : "file.");
        throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_DEST_PATH_ALREADY_EXISTS, message);
    }

    public static interface PathsBasedSplit {
        public List<FSPath> getPaths();

        public EnrichedInputStream getStreamForPath(FSPath var1) throws IOException, InterruptedException, DKUSecurityException, CodedException;
    }
}

