/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetParams;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.LoadedFSProvider;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.List;

public class CustomFSProviderDatasetMeta<Desc extends CustomFSProviderDesc>
extends DatasetHandler.NonFSMeta<CustomFSProviderDatasetHandler<?>, CustomFSProviderDatasetParams>
implements IPluginifiedHolderMeta {
    private LoadedFSProvider<Desc> desc;

    public CustomFSProviderDatasetMeta(LoadedFSProvider<Desc> desc) {
        this.desc = desc;
    }

    public LoadedFSProvider<Desc> getDesc() {
        return this.desc;
    }

    @Override
    public String getType() {
        return this.desc.fsProviderType;
    }

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return CustomFSProviderDatasetParams.class;
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        return new CustomFSProviderDatasetHandler<Desc>(authCtx, this.desc, dataset);
    }

    @Override
    public boolean isFSLike() {
        return true;
    }

    @Override
    public boolean isFS() {
        return true;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isParallelWritable() {
        return false;
    }

    @Override
    public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
        throw new NotImplementedException();
    }

    @Override
    public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
        List<IPluginifiedHolderMeta.Pluginifiable> components = super.getPluginifiables(object, payload);
        if (object instanceof SerializedDataset) {
            SerializedDataset dataset = (SerializedDataset)object;
            components.add(new IPluginifiedHolderMeta.Pluginifiable("format", dataset.formatType, dataset.getFormatParams()));
            components.add(new IPluginifiedHolderMeta.Pluginifiable("fsProvider", dataset.type, dataset.getParams()));
        }
        return components;
    }
}

