/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomJavaElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuildersRegistry;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetMeta;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProviderBuilder;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.LoadedJavaFSProvider;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomJavaFSProvidersService
extends CustomJavaElementService<CustomJavaFSProviderDesc, LoadedJavaFSProvider> {
    @Override
    public String getFolderName() {
        return "java-fs-providers";
    }

    @Override
    public String getPrefix() {
        return "fs-provider";
    }

    @Override
    protected String getCodeExtension(LoadedJavaFSProvider desc) {
        return ".java";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "fsprovider_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomJavaFSProviderDesc> getDescClass() {
        return CustomJavaFSProviderDesc.class;
    }

    @Override
    public Class<LoadedJavaFSProvider> getLoadedDescClass() {
        return LoadedJavaFSProvider.class;
    }

    @Override
    protected void removeElement(LoadedJavaFSProvider desc) {
        CustomFSProviderBuildersRegistry.deregister(desc.fsProviderType);
    }

    @Override
    protected LoadedJavaFSProvider load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedJavaFSProvider loaded = new LoadedJavaFSProvider(elementType, pluginId, elementId, (CustomJavaFSProviderDesc)JSON.parseFile((File)file, CustomJavaFSProviderDesc.class));
        CustomFSProviderBuildersRegistry.register(new CustomJavaFSProviderBuilder(loaded, this));
        CustomFSProviderDatasetMeta<CustomJavaFSProviderDesc> meta = new CustomFSProviderDatasetMeta<CustomJavaFSProviderDesc>(loaded);
        DatasetHandlerFactory.checkDuplicateDatasetMeta(pluginId, elementId, elementType, CustomFSProviderDatasetMeta.class);
        DatasetHandlerFactory.registerDatasetType(meta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomJavaFSProviderDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomJavaFSProvidersService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (StringUtils.isBlank((String)desc.fsProviderClass)) {
                    this.withFatal("Java plugin fs providers require a \"fsProviderClass\" field.");
                }
                return this.messages;
            }
        }.validate();
    }
}

