/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.google.common.base.Joiner;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractSQLQueryDatasetHandler
extends AbstractSQLDatasetHandler {
    protected static final Logger logger = Logger.getLogger((String)"dku.datasets.sql");

    public AbstractSQLQueryDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        super(authCtx, dataset, meta);
    }

    @Override
    public void createManaged() throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot manage a SQL query dataset");
    }

    @Override
    public void clearAllData() throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot manage a SQL query dataset");
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot manage a SQL query dataset");
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot manage a SQL query dataset");
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot write on a SQL Query dataset");
    }

    @Override
    public boolean outputHandlesClear() {
        throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot write on a SQL Query dataset");
    }

    @Override
    public long getRecords() throws DataStoreIOException, DKUSecurityException, InterruptedException {
        return this.runInExpandedAndSplitQuery("Failed to count records", null, new WorkOnMainQuery<Long>(){

            @Override
            public Long work(SQLConnectionProvider.SQLConnectionWrapper conn, Statement stmt, String q) throws SQLException, DKUSecurityException {
                String mainQuery = "SELECT COUNT(*) FROM (" + q + ")" + AbstractSQLQueryDatasetHandler.this.getDialect().quoteIdentifier("subQuery");
                ResultSet rs2 = stmt.executeQuery(mainQuery);
                rs2.next();
                return rs2.getLong(1);
            }
        });
    }

    @Override
    public DatasetReadiness getSQLReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        try {
            if (this.dataset.getParams().isNotReadyIfEmpty()) {
                logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                return RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
            }
            return this.runInExpandedAndSplitQuery("Failed to check readiness", p, new WorkOnMainQuery<DatasetReadiness>(){

                @Override
                public DatasetReadiness work(SQLConnectionProvider.SQLConnectionWrapper conn, Statement stmt, String q) throws SQLException, DKUSecurityException {
                    SQLDialect dialect = AbstractSQLQueryDatasetHandler.this.getDialect();
                    String query = q;
                    if (!dialect.supportsResultSetMetadataOnPreparedStatement(q)) {
                        query = dialect.getLimitedQuery("SELECT * FROM __dku_subquery__ " + dialect.quoteIdentifier("subQuery"), 1L).replace("__dku_subquery__", "(" + q + ")");
                    }
                    try {
                        SchemaReader.getQuerySchema(AbstractSQLQueryDatasetHandler.this.authCtx, AbstractSQLQueryDatasetHandler.this.getConnectionData(), conn, query, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING, null);
                    }
                    catch (SQLException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new SQLException("Failed to get schema of query", e);
                    }
                    return DatasetReadiness.ready(null);
                }
            });
        }
        catch (Exception e) {
            return DatasetReadiness.error(e);
        }
    }

    public String getResolvedQuery() {
        return this.resolvedAbstractConfig.query;
    }

    public String expandQueryForPartition(Partition partition) {
        if (StringUtils.isBlank((String)this.resolvedAbstractConfig.query)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Dataset " + this.dataset.getFullName() + " is configured with mode 'SQL query' but the query is missing");
        }
        if (partition == null || partition.id().equals("NP")) {
            return this.resolvedAbstractConfig.query;
        }
        logger.info((Object)("Getting query for partition " + String.valueOf(partition)));
        return SQLUtils.getQueryForPartition(this.resolvedAbstractConfig.query, partition);
    }

    protected String insertLimitClause(String query, long maxRecords) throws DKUSecurityException {
        SQLDialect dialect = this.getDialect();
        Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
        Object[] statementSqls = splitter.split(query);
        int lastSelectStatementIndex = SQLUtils.findLastSelectStatement((String[])statementSqls, splitter);
        if (lastSelectStatementIndex < 0) {
            lastSelectStatementIndex = statementSqls.length - 1;
        }
        statementSqls[lastSelectStatementIndex] = dialect.getLimitedQuery(statementSqls[lastSelectStatementIndex], maxRecords);
        return Joiner.on((String)";\n").join(statementSqls);
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() {
        return false;
    }

    /*
     * Exception decompiling
     */
    protected <T> T runInExpandedAndSplitQuery(String message, Partition partition, WorkOnMainQuery<T> worker) throws DataStoreIOException, DKUSecurityException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface WorkOnMainQuery<T> {
        public T work(SQLConnectionProvider.SQLConnectionWrapper var1, Statement var2, String var3) throws SQLException, DKUSecurityException;
    }

    class QueryBasedSplit
    extends RowsInputSplit {
        private final String query;

        QueryBasedSplit(String query) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)"query"));
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            long l;
            String q = limit != null && limit.maxRecords > 0L ? AbstractSQLQueryDatasetHandler.this.insertLimitClause(this.query, limit.maxRecords) : this.query;
            SQLConnectionProvider.SQLConnectionWrapper conn = AbstractSQLQueryDatasetHandler.this.newConnection();
            try {
                l = AbstractSQLQueryDatasetHandler.this.executePush(conn, q, out, cf, rf, limit, listener, warningsContext, true);
            }
            catch (Throwable throwable) {
                try {
                    SQLUtils.unsafeRollbackAndClose(conn);
                    throw throwable;
                }
                catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new DataStoreIOException("Failed to read data from DB", (Throwable)e);
                }
            }
            SQLUtils.unsafeRollbackAndClose(conn);
            return l;
        }

        public String getDesc() {
            return "SQLQuery";
        }
    }
}

