/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.AutoFastPathConnector;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.CanShareSQLConnection;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathOutput;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;

public class SQLViaCloudAutoFastPathOutputWriter
extends OutputWriter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.output.sql.autofastpath");
    private final Output.WriteMode writeMode;
    private final CanShareSQLConnection.SQLConnectionShare connectionShare;
    private final AutoFastPathConnector autoFastPathConnector;
    private final Dataset finalDataset;
    private final Dataset virtualDataset;
    private final Partition targetPartition;
    private final AuthCtx authCtx;
    private final WarningsContext warnContext;
    private DatasetHandler cloudHandler;
    private OutputWriter cloudOutputWriter;

    SQLViaCloudAutoFastPathOutputWriter(AuthCtx authCtx, Dataset finalDataset, Dataset virtualDataset, Partition targetPartition, CanShareSQLConnection.SQLConnectionShare connectionShare, WarningsContext warnContext, Output.WriteMode mode) {
        this.writeMode = mode;
        this.connectionShare = connectionShare;
        this.finalDataset = finalDataset;
        this.virtualDataset = virtualDataset;
        this.targetPartition = targetPartition;
        this.authCtx = authCtx;
        this.warnContext = warnContext;
        this.autoFastPathConnector = SQLViaCloudAutoFastPathOutput.buildAutoFastPathConnector(finalDataset, virtualDataset);
    }

    public void init(ColumnFactory cf) throws Exception {
        logger.debug((Object)("Creating handler for virtual dataset " + JSON.json((Object)this.virtualDataset.getModel())));
        this.cloudHandler = DatasetHandlerFactory.build(this.authCtx, this.virtualDataset);
        Output cloudOutput = this.cloudHandler.buildOutput(this.targetPartition, 0, 4, this.warnContext);
        Output.WriteMode tempWriteMode = "parquet".equals(this.virtualDataset.getFormatType()) || "orcfile".equals(this.virtualDataset.getFormatType()) ? Output.WriteMode.APPEND : Output.WriteMode.OVERWRITE;
        this.cloudOutputWriter = cloudOutput.getWriter(tempWriteMode);
        this.cloudOutputWriter.init(cf);
    }

    public void emitRow(Row row) throws Exception {
        this.cloudOutputWriter.emitRow(row);
    }

    public void lastRowEmitted() throws Exception {
        logger.info((Object)"Closing temporary cloud writer");
        this.cloudOutputWriter.lastRowEmitted();
        this.cloudOutputWriter = null;
        try {
            this.autoFastPathConnector.initForAutoFastPath(this.authCtx, this.warnContext, this.virtualDataset, this.targetPartition, this.finalDataset, this.writeMode);
            this.autoFastPathConnector.run();
            this.connectionShare.give(false);
            logger.info((Object)"Synchronization to target done");
        }
        finally {
            this.cleanCloudOutput();
            this.cloudHandler = null;
            logger.info((Object)"Auto-fast-path: complete");
        }
    }

    private void cleanCloudOutput() throws Exception {
        if (this.cloudHandler != null) {
            logger.info((Object)"Trying to clear cloud temporary files");
            try {
                this.cloudHandler.clearAllDataAndStructure();
            }
            catch (Exception e) {
                logger.warn((Object)"Clearing cloud temporary files failed", (Throwable)e);
            }
            this.cloudHandler.close();
        }
    }

    public void cancel() throws Exception {
        if (this.cloudOutputWriter != null) {
            this.cloudOutputWriter.cancel();
        }
        this.cleanCloudOutput();
    }

    public long writtenBytes() throws IOException {
        return 0L;
    }
}

