/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.sql.queries.CreateTableQueryBuilder;
import com.dataiku.dip.sql.queries.UpsertQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.TestFlag;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDSSDBService {
    private static final int LOCK_TIMEOUT = 300000;
    @Autowired
    DSSDBConnectionsManagementService internalDBConnectionsService;
    public static final String DSS_SCHEMA_INFO_TABLE = "DSS_SCHEMA_INFO";
    static final String SCHEMA_VERSION_COLUMN = "SCHEMA_VERSION";
    private static final SchemaColumn SCHEMA_VERSION_SCHEMA_COLUMN = new SchemaColumn("SCHEMA_VERSION", Type.INT);
    static final String INTERNAL_ID_COLUMN = "INTERNAL_ID";
    public static final SchemaColumn INTERNAL_ID_SCHEMA_COLUMN = new SchemaColumn("INTERNAL_ID", Type.STRING);
    private final int expectedSchemaVersion;
    protected final DSSDBRef ref;
    @VisibleForTesting
    public static final TestFlag skipCreateDb = new TestFlag();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.db.internal");

    public static String getInternalId(String originalName) {
        if (DSSDBConnectionsManagementService.isProjectTimeline(originalName)) {
            return "timeline";
        }
        return originalName;
    }

    protected static SchemaColumn[] toLowerCase(SchemaColumn[] columns) {
        SchemaColumn[] result = new SchemaColumn[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            SchemaColumn originalColumn = new SchemaColumn(columns[i]);
            originalColumn.setName(originalColumn.getName().toLowerCase());
            result[i] = originalColumn;
        }
        return result;
    }

    public AbstractDSSDBService(File file, String name, String nameForConfigKey, int expectedSchemaVersion, boolean autoServer) {
        assert (expectedSchemaVersion > 0);
        try {
            Class.forName("org.h2.Driver");
        }
        catch (Exception e) {
            throw new Error(e);
        }
        this.ref = new DSSDBRef(name, autoServer, file, 300000, nameForConfigKey);
        this.expectedSchemaVersion = expectedSchemaVersion;
        SpringUtils.getInstance().autowire((Object)this);
    }

    protected abstract void initDB(int var1, DSSDBConnection var2) throws SQLException;

    public DSSDBRef getDBRef() {
        return this.ref;
    }

    public String getName() {
        return this.ref.name;
    }

    public File getH2File() {
        return this.ref.h2File;
    }

    public SQLDialect getDialect() {
        return this.internalDBConnectionsService.getDialect();
    }

    protected void createAnonymousIndex(String tableBaseName, String[] indexColumns, Statement st2) throws CodedSQLException {
        try {
            CreateIndexQueryBuilder q = CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(tableBaseName)).addColumns(indexColumns);
            q.execute(st2, this.getDialect());
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed creation of index on table " + tableBaseName + " in internal database", (Throwable)e);
        }
    }

    protected void createNamedIndex(String tableBaseName, String indexName, String[] indexColumns, Statement st2) throws CodedSQLException {
        try {
            CreateIndexQueryBuilder q = CreateIndexQueryBuilder.createNamedIndex(this.resolveTable(tableBaseName), this.prefixTableName(indexName)).addColumns(indexColumns);
            q.execute(st2, this.getDialect());
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed create index " + indexName + " in internal database", (Throwable)e);
        }
    }

    protected void createAnonymousIndex(String tableBaseName, SchemaColumn[] indexColumns, Statement st2) throws CodedSQLException {
        try {
            CreateIndexQueryBuilder q = CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(tableBaseName)).addColumns(indexColumns);
            q.execute(st2, this.getDialect());
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed creation of index on table " + tableBaseName + " in internal database", (Throwable)e);
        }
    }

    protected void createAnonymousUniqueIndex(String tableBaseName, String[] indexColumns, Statement st2) throws CodedSQLException {
        try {
            CreateIndexQueryBuilder q = CreateIndexQueryBuilder.createAnonymousUniqueIndex(this.resolveTable(tableBaseName)).addColumns(indexColumns);
            q.execute(st2, this.getDialect());
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed creation of unique index on table " + tableBaseName + " internal database", (Throwable)e);
        }
    }

    protected void createTable(String tableName, SchemaColumn[] columns, String[] keyColumns, Statement st2) throws CodedSQLException {
        try {
            CreateTableQueryBuilder q = CreateTableQueryBuilder.createTable(this.resolveTable(tableName));
            q.addColumns(columns);
            q.addKeyColumns(keyColumns);
            q.execute(st2, this.getDialect());
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed create table in internal database", (Throwable)e);
        }
    }

    private String prefixTableName(String tableBaseName) {
        return (this.internalDBConnectionsService.getTablePrefix() + tableBaseName).toUpperCase();
    }

    public SQLUtils.SQLTable resolveTable(String tableBaseName) {
        return new SQLUtils.SQLTable(this.internalDBConnectionsService.getCatalog(), this.internalDBConnectionsService.getSchema(), this.prefixTableName(tableBaseName), true);
    }

    public String getQuotedFullResolvedTableName(String tableBaseName) {
        return this.getDialect().getQuotedTableFullName(this.resolveTable(tableBaseName));
    }

    protected String getQuotedIndexName(String indexBaseName) {
        return this.quote(this.prefixTableName(indexBaseName));
    }

    protected String quote(String identifier) {
        return this.getDialect().quoteIdentifier(identifier);
    }

    protected String quoteString(String value) {
        return this.getDialect().quoteString(value);
    }

    protected PreparedStatement getPreparedStatement(DSSDBConnection conn, String sql) throws CodedSQLException {
        return conn.getOrCreatePreparedStatement(sql);
    }

    public DSSDBConnection acquireConnection(boolean isReadOnly) throws CodedSQLException {
        return this.internalDBConnectionsService.acquire(this.ref, isReadOnly);
    }

    public DSSDBConnection acquireConnection() throws CodedSQLException {
        return this.internalDBConnectionsService.acquire(this.ref, false);
    }

    protected void deleteConnectionPool() {
        this.internalDBConnectionsService.deleteConnectionPool(this.ref);
    }

    public synchronized void create() throws CodedSQLException {
        if (skipCreateDb.isActivated()) {
            return;
        }
        MainLoggingConfigurator.ProcessType processType = ApplicationConfigurator.getProcessType();
        if (processType == MainLoggingConfigurator.ProcessType.JEK || processType == MainLoggingConfigurator.ProcessType.FEK || processType == MainLoggingConfigurator.ProcessType.CAK) {
            logger.infoV("In %s, skipping database initialization of %s", new Object[]{processType, this.getName()});
            return;
        }
        logger.info((Object)("Initialize database " + this.getName()));
        if (FeatureFlags.isEnabled((String)"NO_CHECK_DB_VERSION") && !DSSDBConnectionsManagementService.isProjectTimeline(this.ref.name)) {
            logger.debug((Object)("FeatureFlag: ignoring version check for " + this.ref.name));
            return;
        }
        try (DSSDBConnection ac = this.acquireConnection();){
            int schemaVersion = DSSDBConnectionsManagementService.getCurrentSchemaVersion(ac, this.resolveTable(DSS_SCHEMA_INFO_TABLE), AbstractDSSDBService.getInternalId(this.ref.name), this.getDialect());
            if (schemaVersion != this.expectedSchemaVersion) {
                logger.info((Object)("Current schema version for " + this.ref.name + " is: " + schemaVersion + ". Migrate to " + this.expectedSchemaVersion));
                if (schemaVersion == 0) {
                    try (Statement st2 = ac.createStatement();){
                        CreateTableQueryBuilder.createTable(this.resolveTable(DSS_SCHEMA_INFO_TABLE)).ifNotExists().addColumns(INTERNAL_ID_SCHEMA_COLUMN, SCHEMA_VERSION_SCHEMA_COLUMN).addKeyColumns(INTERNAL_ID_COLUMN).execute(st2, this.getDialect());
                        logger.info((Object)("Created database: " + this.ref.name));
                    }
                }
                String updateVersionNumberQuery = UpsertQueryBuilder.into(this.resolveTable(DSS_SCHEMA_INFO_TABLE)).addKeyColumns(INTERNAL_ID_COLUMN).addColumns(INTERNAL_ID_SCHEMA_COLUMN, SCHEMA_VERSION_SCHEMA_COLUMN).toSQL(this.getDialect());
                logger.debugV("Merge query: %s", new Object[]{updateVersionNumberQuery});
                try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(updateVersionNumberQuery);){
                    ps2.setString(1, AbstractDSSDBService.getInternalId(this.ref.name));
                    ps2.setInt(2, this.expectedSchemaVersion);
                    ps2.execute();
                }
            }
            this.initDB(schemaVersion, ac);
            if (schemaVersion != this.expectedSchemaVersion) {
                ac.commit();
            }
        }
        catch (CodedSQLException e) {
            logger.errorV((Throwable)e, "Failed to initialize internal database: %s", new Object[]{this.ref.name});
            throw e;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Failed to initialize internal database: %s", new Object[]{this.ref.name});
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to initialize internal database", (Throwable)e);
        }
    }

    protected void switchTimestampsToLong(Statement st2, Map<String, List<String>> columnsToSwitch) throws SQLException {
        HashSet oldIndexesSql = Sets.newHashSet();
        for (Map.Entry<String, List<String>> columnsToSwitchInTable : columnsToSwitch.entrySet()) {
            String tableName = columnsToSwitchInTable.getKey();
            logger.info((Object)("Switch timestamp columns to bigint in " + tableName));
            HashMap columnTypes = Maps.newHashMap();
            try (ResultSet rs2 = st2.executeQuery("select COLUMN_NAME, TYPE_NAME from information_schema.columns where TABLE_NAME = '" + tableName.toUpperCase() + "'");){
                while (rs2.next()) {
                    String columnName = rs2.getString(1).toLowerCase();
                    String typeName = rs2.getString(2).toLowerCase();
                    columnTypes.put(columnName, typeName);
                }
            }
            oldIndexesSql.addAll(this.dropExistingIndexesOnTable(st2, null, tableName));
            for (String columnName : columnsToSwitchInTable.getValue()) {
                logger.info((Object)("Switch column " + columnName));
                if (!columnTypes.containsKey(columnName)) {
                    logger.info((Object)"Conversion not needed, column doesn't exist in this version");
                    continue;
                }
                if ("timestamp".equals(columnTypes.get(columnName))) {
                    this.switchTimestampColumnToBigint(st2, tableName, columnName);
                    continue;
                }
                logger.info((Object)("Conversion not needed, type is " + (String)columnTypes.get(columnName)));
            }
        }
        logger.info((Object)"Re-create indexes");
        for (String sql : oldIndexesSql) {
            st2.execute(sql);
        }
    }

    private String getIndexesQuery(String schemaName, String tableName) {
        SQLDialect dialect = this.getDialect();
        if (dialect instanceof PostgreSQLDialect) {
            String schemaFilter = StringUtils.isNotBlank((String)schemaName) ? String.format("AND schemaname='%s'", schemaName) : "";
            return String.format("SELECT indexname from pg_indexes WHERE tablename='%s' %s", tableName, schemaFilter);
        }
        if (dialect instanceof MySQLDialect) {
            String schemaFilter = StringUtils.isNotBlank((String)schemaName) ? String.format("AND TABLE_SCHEMA='%s'", schemaName) : "";
            return String.format("SELECT INDEX_NAME FROM information_schema.statistics WHERE TABLE_NAME='%s' %s", tableName, schemaFilter);
        }
        if (dialect instanceof H2SQLDialect) {
            String schemaFilter = StringUtils.isNotBlank((String)schemaName) ? String.format("AND table_schema='%s'", schemaName) : "";
            return String.format("select index_name, sql from information_schema.indexes where table_name='%s' %s", tableName, schemaFilter);
        }
        return null;
    }

    private void switchTimestampColumnToBigint(Statement st2, String tableName, String columnName) throws SQLException {
        st2.execute("ALTER TABLE " + tableName + " ADD COLUMN (old_" + columnName + " timestamp) AFTER " + columnName);
        st2.execute("UPDATE " + tableName + " SET old_" + columnName + " = " + columnName);
        st2.execute("ALTER TABLE " + tableName + " DROP COLUMN " + columnName);
        st2.execute("ALTER TABLE " + tableName + " ADD COLUMN (" + columnName + " bigint) AFTER old_" + columnName);
        st2.execute("UPDATE " + tableName + " SET " + columnName + " = datediff('ms', '1970-01-01', old_" + columnName + ")");
        st2.execute("ALTER TABLE " + tableName + " DROP COLUMN old_" + columnName);
    }

    protected Set<String> dropExistingIndexesOnTable(Statement st2, String schemaName, String tableName) throws SQLException {
        HashSet<String> indexesSql = new HashSet<String>();
        String indexesQuery = this.getIndexesQuery(schemaName, tableName);
        if (indexesQuery == null) {
            return indexesSql;
        }
        st2.execute(indexesQuery);
        ResultSet rs2 = st2.getResultSet();
        if (rs2 != null) {
            HashSet<String> indexesToDelete = new HashSet<String>();
            while (rs2.next()) {
                indexesToDelete.add(rs2.getString(1));
                if (rs2.getMetaData().getColumnCount() <= 1) continue;
                indexesSql.add(rs2.getString(2));
            }
            logger.info((Object)("Deleting " + indexesToDelete.size() + " indexes"));
            for (String index : indexesToDelete) {
                SQLUtils.SQLTable resolvedIndex = new SQLUtils.SQLTable(this.internalDBConnectionsService.getCatalog(), schemaName, index, false);
                logger.info((Object)("Dropping index " + String.valueOf(resolvedIndex)));
                logger.info((Object)("Executing DROP INDEX: " + this.getDialect().getQuotedTableFullName(resolvedIndex)));
                st2.execute("Drop index " + this.getDialect().getQuotedTableFullName(resolvedIndex));
            }
        }
        return indexesSql;
    }

    public static class DSSDBRef {
        public final String name;
        final boolean autoServer;
        public final File h2File;
        public final int lockTimeout;
        public final String nameForConfigKey;

        DSSDBRef(String name, boolean autoServer, File h2File, int lockTimeout, String nameForConfigKey) {
            this.name = name;
            this.autoServer = autoServer;
            this.h2File = h2File;
            this.lockTimeout = lockTimeout;
            this.nameForConfigKey = nameForConfigKey;
        }
    }
}

