/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.H2Connection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.db.AbstractConnectionFactory;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.SecretKeyGenerator;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class SingleH2DatabaseConnectionsFactory
extends AbstractConnectionFactory {
    private static final String UNABLE_TO_OPEN_DB_FILE = "Unable to open the following internal database file: %s. Restore a backup or move the file away then restart DSS.";
    private static final String MISSING_DB_FILE = "Missing the following internal database file: %s. Restore a backup then restart DSS.";
    private static final String TOTAL_METRIC = "total";
    private final String name;
    private final String nameForMetrics;
    private final String jdbcUrl;

    public SingleH2DatabaseConnectionsFactory(String name, String nameForMetrics, String jdbcUrl) {
        this.name = name;
        this.nameForMetrics = nameForMetrics;
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    protected String getFactoryType() {
        return "H2";
    }

    @Override
    protected SQLDialect getDialect() {
        return new H2SQLDialect();
    }

    @Override
    protected String[] metricNamesForValidation() {
        return new String[]{DSSDBConnectionsManagementService.buildMultiDBMetricName(this.nameForMetrics, "validateConnection"), DSSDBConnectionsManagementService.buildMultiDBMetricName(TOTAL_METRIC, "validateConnection")};
    }

    @Override
    protected String[] metricNamesForValidationFailure() {
        return new String[]{DSSDBConnectionsManagementService.buildMultiDBMetricName(this.nameForMetrics, "droppedConnections"), DSSDBConnectionsManagementService.buildMultiDBMetricName(TOTAL_METRIC, "droppedConnections")};
    }

    public DSSDBConnection makeObject() throws CodedSQLException {
        DSSMetrics.MTimeCtx tctx = DSSMetrics.mtimeCtx((String[])new String[]{DSSDBConnectionsManagementService.buildMultiDBMetricName(this.nameForMetrics, "createConnection"), DSSDBConnectionsManagementService.buildMultiDBMetricName(TOTAL_METRIC, "createConnection")});
        try {
            String debugId = "dssdb-h2-" + this.name + "-" + SecretKeyGenerator.generateSmall();
            Connection conn = DriverManager.getDriver(this.jdbcUrl).connect(this.jdbcUrl, new Properties());
            SQLConnectionProvider.SQLConnectionWrapper wrapper = new SQLConnectionProvider.SQLConnectionWrapper(new FakeH2SQLConnectionData(), conn, debugId, false);
            wrapper.setAutoCommit(false);
            wrapper.setNoReportCRU();
            DSSDBConnection dSSDBConnection = new DSSDBConnection(wrapper, this.connectionPool, debugId);
            return dSSDBConnection;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, String.format(UNABLE_TO_OPEN_DB_FILE, this.jdbcUrl), (Throwable)e);
        }
        finally {
            if (tctx != null) {
                try {
                    tctx.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public void destroyObject(DSSDBConnection connection) {
        logger.debugV("Destroying connection %s", new Object[]{connection.debugId});
        connection.ultimateClose();
    }

    public static File getDBFile(File file) throws CodedSQLException {
        if (file == null) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, String.format(MISSING_DB_FILE, "?.mv.db"));
        }
        File dbFile = new File(file.getAbsolutePath() + ".mv.db");
        if (dbFile.exists()) {
            return dbFile;
        }
        dbFile = new File(file.getAbsolutePath() + ".db");
        if (dbFile.exists()) {
            return dbFile;
        }
        dbFile = new File(file.getAbsolutePath() + ".h2.db");
        if (dbFile.exists()) {
            return dbFile;
        }
        throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, String.format(MISSING_DB_FILE, file.getAbsolutePath() + ".mv.db"));
    }

    public static class FakeH2SQLConnectionData
    extends SQLConnectionProvider.AbstractSQLConnectionData {
        FakeH2SQLConnectionData() {
            super(ConnectionUtils.SQLConnectionType.H2, new H2SQLDialect(), new H2Connection());
        }

        @Override
        public String getDriver(AuthCtx authCtx, String projectKey) {
            throw new Error("don't call this");
        }

        @Override
        public SQLConnectionProvider.SQLConnectionWrapper buildConnection(AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback) {
            throw new Error("don't call this");
        }

        @Override
        public SQLConnectionProvider.SparkJDBCInfo getSparkConnectionInfo(AuthCtx authCtx, String projectKey) throws SQLException {
            throw new Error("don't call this");
        }
    }
}

