/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.dataset.status;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractStatusPlaceholder
implements FlowPlaceholder.TextPlaceholder<SerializedDataset> {
    @Autowired
    private DatasetMetricsStatusService datasetMetricsStatusService;

    public AbstractStatusPlaceholder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public Class<SerializedDataset> getInputType() {
        return SerializedDataset.class;
    }

    protected DatasetMetricsStatusService.DatasetSummaryStatus getStatus(SerializedDataset dataset) throws PlaceholderExpectedException {
        try {
            return this.datasetMetricsStatusService.getCachedSummaryStatus(Dataset.fromSerializedUnsafe(dataset.getFullName(), dataset));
        }
        catch (Exception e) {
            throw PlaceholderExpectedException.createWithLog("Unable to retrieve dataset status for " + dataset.getFullName(), e);
        }
    }
}

