/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.folder.details;

import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

public class FolderTypePlaceholder
implements FlowPlaceholder.TextPlaceholder<ManagedFolder> {
    @Autowired
    private CustomPythonFSProvidersService customPythonFSProvidersService;
    @Autowired
    private CustomJavaFSProvidersService customJavaFSProvidersService;
    private final Map<String, String> uiNameMap = new HashMap<String, String>();

    public FolderTypePlaceholder() {
        SpringUtils.getInstance().autowire((Object)this);
        this.uiNameMap.put("filesystem", "Server's Filesystem");
        this.uiNameMap.put("hdfs", "Hadoop HDFS");
        this.uiNameMap.put("ftp", "FTP");
        this.uiNameMap.put("sftp", "SFTP");
        this.uiNameMap.put("scp", "SCP");
        this.uiNameMap.put("azure", "Azure Blob Storage");
        this.uiNameMap.put("sharepointonline", "SharePoint Online");
        this.uiNameMap.put("gcs", "Google Cloud Storage");
        this.uiNameMap.put("s3", "Amazon S3");
        this.uiNameMap.put("url", "HTTP or FTP URL");
        Streams.concat((Stream[])new Stream[]{this.customPythonFSProvidersService.list().stream(), this.customJavaFSProvidersService.list().stream()}).forEach(desc -> {
            if (desc.desc != null && ((CustomFSProviderDesc)desc.desc).meta != null && ((CustomFSProviderDesc)desc.desc).meta.label != null) {
                this.uiNameMap.put(desc.fsProviderType, ((CustomFSProviderDesc)desc.desc).meta.label);
            }
        });
    }

    @Override
    public Class<ManagedFolder> getInputType() {
        return ManagedFolder.class;
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ManagedFolder folder) throws PlaceholderExpectedException {
        return new PlaceholderOutput.Text(this.uiNameMap.getOrDefault(folder.type.toLowerCase(), folder.type.toLowerCase()));
    }
}

